/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.AttributeHelper;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeGenerator
extends LinkedHashMap<String, String> {
    private String content = null;

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void put(String key, long value) {
        this.put(key, Long.toString(value));
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    @Override
    public void put(String key, float value) {
        if (value == Float.POSITIVE_INFINITY) {
            this.put(key, "INF");
        } else if (value == Float.NEGATIVE_INFINITY) {
            this.put(key, "-INF");
        } else {
            this.put(key, Float.toString(value));
        }
    }

    @Override
    public void put(String key, double value) {
        if (value == Double.POSITIVE_INFINITY) {
            this.put(key, "INF");
        } else if (value == Double.NEGATIVE_INFINITY) {
            this.put(key, "-INF");
        } else {
            this.put(key, Double.toString(value));
        }
    }

    @Override
    public void put(String key, Object value) {
        if (value == null) {
            super.put(key, null);
        } else if (value instanceof Float) {
            Float boxedFloat = (Float)value;
            this.put(key, boxedFloat.floatValue());
        } else if (value instanceof Double) {
            Double boxedDouble = (Double)value;
            this.put(key, boxedDouble);
        } else {
            this.put(key, value.toString());
        }
    }

    public <T extends Enum<T>> void put(String key, T value, AttributeHelper.EnumToAttributeValue<T> enumToAttributeValue) {
        this.put(key, value == null ? null : enumToAttributeValue.getAttributeValue(value));
    }
}

