/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.Element;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeElementVisitor
implements ElementVisitor {
    private final List<ElementVisitor> visitors;
    private final Map<ElementVisitor, ElementVisitor.StoppedException> stoppedVisitors = new HashMap<ElementVisitor, ElementVisitor.StoppedException>();
    private final Map<ElementVisitor, Element> ignoringVisitors = new HashMap<ElementVisitor, Element>();

    public CompositeElementVisitor(ElementVisitor ... visitors) {
        this.visitors = new ArrayList<ElementVisitor>(visitors.length);
        for (ElementVisitor visitor : visitors) {
            this.visitors.add(visitor);
        }
    }

    public void addVisitor(ElementVisitor visitor) {
        this.visitors.add(visitor);
    }

    public List<ElementVisitor> getVisitors() {
        return this.visitors;
    }

    public ElementVisitor.StoppedException getStoppedException(ElementVisitor visitor) {
        return this.stoppedVisitors.get(visitor);
    }

    @Override
    public boolean visit(Element parent, Element target, ElementMetadata<?, ?> metadata) throws ElementVisitor.StoppedException {
        boolean newStopped = false;
        for (ElementVisitor visitor : this.visitors) {
            if (this.ignoringVisitors.containsKey(visitor)) continue;
            try {
                boolean visitChildren = visitor.visit(parent, target, metadata);
                if (visitChildren) continue;
                this.ignoringVisitors.put(visitor, target);
            }
            catch (ElementVisitor.StoppedException se) {
                this.stoppedVisitors.put(visitor, se);
                newStopped = true;
            }
        }
        if (newStopped) {
            this.visitors.removeAll(this.stoppedVisitors.keySet());
            if (this.visitors.isEmpty()) {
                throw new ElementVisitor.StoppedException("All visitors stopped");
            }
        }
        return this.visitors.size() != this.ignoringVisitors.size();
    }

    @Override
    public void visitComplete(Element parent, Element target, ElementMetadata<?, ?> metadata) throws ElementVisitor.StoppedException {
        ArrayList<ElementVisitor> resetList = null;
        for (Map.Entry<ElementVisitor, Element> stateEntry : this.ignoringVisitors.entrySet()) {
            Element ignoring = stateEntry.getValue();
            if (ignoring != target) continue;
            if (resetList == null) {
                resetList = new ArrayList<ElementVisitor>();
            }
            resetList.add(stateEntry.getKey());
        }
        if (resetList != null) {
            for (ElementVisitor enabledVisitor : resetList) {
                this.ignoringVisitors.remove(enabledVisitor);
            }
        }
        for (ElementVisitor visitor : this.visitors) {
            if (this.ignoringVisitors.containsKey(visitor)) continue;
            visitor.visitComplete(parent, target, metadata);
        }
    }
}

