/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.AttributeTransform;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.Path;
import com.google.gdata.model.QName;
import com.google.gdata.model.Schema;
import com.google.gdata.model.Transform;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MetadataImpl<D>
implements Metadata<D> {
    final Schema schema;
    final MetadataKey<D> key;
    final ElementKey<?, ?> parent;
    final MetadataContext context;
    private final QName name;
    private final boolean isRequired;
    private final boolean isVisible;
    private final Metadata.VirtualValue virtualValue;

    MetadataImpl(Schema schema, Transform transform, ElementKey<?, ?> parent, MetadataKey<D> key, MetadataContext context) {
        this.schema = Preconditions.checkNotNull(schema, "schema");
        this.key = Preconditions.checkNotNull(key, "key");
        this.parent = parent;
        this.context = context;
        transform = AttributeTransform.mergeSource(schema, transform, context);
        this.name = MetadataImpl.firstNonNull(transform.getName(), key.getId());
        this.isRequired = MetadataImpl.firstNonNull(transform.getRequired(), false);
        Path path = transform.getPath();
        this.isVisible = transform.isMoved() ? false : (path != null ? MetadataImpl.isVisible(path, schema, parent, context) : MetadataImpl.firstNonNull(transform.getVisible(), true));
        this.virtualValue = transform.getVirtualValue();
    }

    static boolean isVisible(Path path, Schema schema, ElementKey<?, ?> parent, MetadataContext context) {
        for (MetadataKey<?> part : path.getSteps()) {
            Transform transform = schema.getTransform(parent, part, context);
            Boolean visible = transform.getVisible();
            if (visible != null && !visible.booleanValue()) {
                return false;
            }
            if (!(part instanceof ElementKey)) continue;
            parent = (ElementKey)part;
        }
        return true;
    }

    static <T> T firstNonNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        throw new IllegalArgumentException("Values must contain at least a single non-null value.");
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public MetadataKey<D> getKey() {
        return this.key;
    }

    @Override
    public ElementKey<?, ?> getParent() {
        return this.parent;
    }

    @Override
    public MetadataContext getContext() {
        return this.context;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Object generateValue(Element element, ElementMetadata<?, ?> metadata) {
        if (this.virtualValue != null) {
            return this.virtualValue.generate(element, metadata);
        }
        return null;
    }

    @Override
    public void parseValue(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
        this.parse(element, metadata, value);
    }

    boolean parse(Element element, ElementMetadata<?, ?> metadata, Object value) throws ParseException {
        if (this.virtualValue != null) {
            this.virtualValue.parse(element, metadata, value);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getKey() + "}@" + Integer.toHexString(this.hashCode());
    }
}

