/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.List;
import org.jitsi.impl.neomedia.RTPConnectorUDPInputStream;
import org.jitsi.service.neomedia.event.RTCPFeedbackEvent;
import org.jitsi.service.neomedia.event.RTCPFeedbackListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTCPConnectorInputStream
extends RTPConnectorUDPInputStream {
    private final List<RTCPFeedbackListener> listeners = new ArrayList<RTCPFeedbackListener>();

    public RTCPConnectorInputStream(DatagramSocket socket) {
        super(socket);
    }

    public void addRTCPFeedbackListener(RTCPFeedbackListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public static void fireRTCPFeedbackReceived(Object source, byte[] buffer, int offset, int length, List<RTCPFeedbackListener> listeners) {
        int pt;
        if (!(length < 12 || listeners.isEmpty() || (pt = buffer[offset + 1] & 0xFF) != 206 && pt != 205)) {
            int fmt = buffer[offset] & 0x1F;
            RTCPFeedbackEvent evt = new RTCPFeedbackEvent(source, fmt, pt);
            for (RTCPFeedbackListener l : listeners) {
                l.rtcpFeedbackReceived(evt);
            }
        }
    }

    public void removeRTCPFeedbackListener(RTCPFeedbackListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int pktLength = super.read(buffer, offset, length);
        RTCPConnectorInputStream.fireRTCPFeedbackReceived(this, buffer, offset, pktLength, this.listeners);
        return pktLength;
    }
}

