/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PackageManager;
import javax.media.PlugInManager;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.util.Logger;

public class FMJPlugInConfiguration {
    private static boolean codecsRegistered = false;
    private static final String[] CUSTOM_CODECS = new String[]{"org.jitsi.impl.neomedia.codec.audio.alaw.DePacketizer", "org.jitsi.impl.neomedia.codec.audio.alaw.JavaEncoder", "org.jitsi.impl.neomedia.codec.audio.alaw.Packetizer", "org.jitsi.impl.neomedia.codec.audio.ulaw.JavaDecoder", "org.jitsi.impl.neomedia.codec.audio.ulaw.JavaEncoder", "org.jitsi.impl.neomedia.codec.audio.ulaw.Packetizer", "org.jitsi.impl.neomedia.codec.audio.opus.JNIDecoder", "org.jitsi.impl.neomedia.codec.audio.opus.JNIEncoder", "org.jitsi.impl.neomedia.codec.audio.speex.JNIDecoder", "org.jitsi.impl.neomedia.codec.audio.speex.JNIEncoder", "org.jitsi.impl.neomedia.codec.audio.speex.SpeexResampler", "org.jitsi.impl.neomedia.codec.audio.mp3.JNIEncoder", "org.jitsi.impl.neomedia.codec.audio.ilbc.JavaDecoder", "org.jitsi.impl.neomedia.codec.audio.ilbc.JavaEncoder", null, null, "net.java.sip.communicator.impl.neomedia.codec.audio.g722.JNIDecoder", "net.java.sip.communicator.impl.neomedia.codec.audio.g722.JNIEncoder", "org.jitsi.impl.neomedia.codec.audio.gsm.Decoder", "org.jitsi.impl.neomedia.codec.audio.gsm.Encoder", "org.jitsi.impl.neomedia.codec.audio.gsm.DePacketizer", "org.jitsi.impl.neomedia.codec.audio.gsm.Packetizer", "org.jitsi.impl.neomedia.codec.audio.silk.JavaDecoder", "org.jitsi.impl.neomedia.codec.audio.silk.JavaEncoder", "org.jitsi.impl.neomedia.codec.video.h263p.DePacketizer", "org.jitsi.impl.neomedia.codec.video.h263p.JNIDecoder", "org.jitsi.impl.neomedia.codec.video.h263p.JNIEncoder", "org.jitsi.impl.neomedia.codec.video.h263p.Packetizer", "org.jitsi.impl.neomedia.codec.video.h264.DePacketizer", "org.jitsi.impl.neomedia.codec.video.h264.JNIDecoder", "org.jitsi.impl.neomedia.codec.video.h264.JNIEncoder", "org.jitsi.impl.neomedia.codec.video.h264.Packetizer", "org.jitsi.impl.neomedia.codec.video.SwScale", "org.jitsi.impl.neomedia.codec.video.vp8.Packetizer", "org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer", "org.jitsi.impl.neomedia.codec.video.vp8.VPXEncoder", "org.jitsi.impl.neomedia.codec.video.vp8.VPXDecoder"};
    private static final String[] CUSTOM_PACKAGES = new String[]{"org.jitsi.impl.neomedia.jmfext", "net.java.sip.communicator.impl.neomedia.jmfext", "net.sf.fmj"};
    private static final Logger logger = Logger.getLogger(FMJPlugInConfiguration.class);
    private static boolean packagesRegistered = false;

    public static void registerCustomCodecs() {
        String[] gsmCodecClasses;
        if (codecsRegistered) {
            return;
        }
        HashSet registeredPlugins = new HashSet(PlugInManager.getPlugInList(null, null, (int)2));
        boolean commit = false;
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.colorspace.JavaRGBToYUV", (int)2);
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.colorspace.JavaRGBConverter", (int)2);
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.colorspace.RGBScaler", (int)2);
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.vh263.NativeDecoder", (int)2);
        PlugInManager.removePlugIn((String)"com.ibm.media.codec.video.h263.NativeEncoder", (int)2);
        String gsmCodecPackage = "com.ibm.media.codec.audio.gsm.";
        for (String gsmCodecClass : gsmCodecClasses = new String[]{"JavaDecoder", "JavaDecoder_ms", "JavaEncoder", "JavaEncoder_ms", "NativeDecoder", "NativeDecoder_ms", "NativeEncoder", "NativeEncoder_ms", "Packetizer"}) {
            PlugInManager.removePlugIn((String)(gsmCodecPackage + gsmCodecClass), (int)2);
        }
        PlugInManager.removePlugIn((String)"net.sf.fmj.media.codec.JavaSoundCodec", (int)2);
        for (String className : CUSTOM_CODECS) {
            boolean registered;
            if (className == null) continue;
            if (registeredPlugins.contains(className)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Codec " + className + " is already registered");
                continue;
            }
            commit = true;
            Throwable exception = null;
            try {
                Codec codec = (Codec)Class.forName(className).newInstance();
                registered = PlugInManager.addPlugIn((String)className, (Format[])codec.getSupportedInputFormats(), (Format[])codec.getSupportedOutputFormats(null), (int)2);
            }
            catch (Throwable ex) {
                registered = false;
                exception = ex;
            }
            if (registered) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Codec " + className + " is successfully registered");
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Codec " + className + " is NOT successfully registered", exception);
        }
        Vector codecs = PlugInManager.getPlugInList(null, null, (int)2);
        if (codecs != null) {
            boolean setPlugInList = false;
            for (int i = CUSTOM_CODECS.length - 1; i >= 0; --i) {
                int classNameIndex;
                String className;
                className = CUSTOM_CODECS[i];
                if (className == null || (classNameIndex = codecs.indexOf(className)) == -1) continue;
                codecs.remove(classNameIndex);
                codecs.add(0, className);
                setPlugInList = true;
            }
            if (setPlugInList) {
                PlugInManager.setPlugInList((Vector)codecs, (int)2);
            }
        }
        if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
            try {
                PlugInManager.commit();
            }
            catch (IOException ex) {
                logger.error("Cannot commit to PlugInManager", ex);
            }
        }
        codecsRegistered = true;
    }

    public static void registerCustomPackages() {
        if (packagesRegistered) {
            return;
        }
        Vector packages = PackageManager.getProtocolPrefixList();
        boolean loggerIsDebugEnabled = logger.isDebugEnabled();
        for (String customPackage : CUSTOM_PACKAGES) {
            if (packages.contains(customPackage)) continue;
            packages.add(customPackage);
            if (!loggerIsDebugEnabled) continue;
            logger.debug("Adding package  : " + customPackage);
        }
        PackageManager.setProtocolPrefixList((Vector)packages);
        PackageManager.commitProtocolPrefixList();
        if (loggerIsDebugEnabled) {
            logger.debug("Registering new protocol prefix list: " + packages);
        }
        packagesRegistered = true;
    }
}

