/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.Silk_SigProc_FIX;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_SigProc_FLP;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_decimate2_coarse_FLP;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_decimate2_coarsest_FLP;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_energy_FLP;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_inner_product_FLP;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_macros;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_pitch_est_tables;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_resampler_down2_3;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_resampler_down3;
import org.jitsi.impl.neomedia.codec.audio.silk.Silk_sort_FLP;

public class Silk_pitch_analysis_core_FLP {
    static final int SCRATCH_SIZE = 22;
    static final float eps = 1.1920929E-7f;

    static float SKP_P_log2(double x) {
        return (float)(3.32192809488736 * Math.log10(x));
    }

    static int SKP_Silk_pitch_analysis_core_FLP(float[] signal, int[] pitch_out, int[] lagIndex, int[] contourIndex, float[] LTPCorr, int prevLag, float search_thres1, float search_thres2, int Fs_kHz, int complexity) {
        float CCmax_new;
        float prevLag_log2;
        int j;
        int d;
        double cross_corr;
        int basis_ptr_offset;
        float[] basis_ptr;
        int k;
        int i;
        int i_djinn;
        int i_djinn2;
        int i_djinn3;
        float[] signal_8kHz = new float[320];
        float[] signal_4kHz = new float[160];
        float[] scratch_mem = new float[2880];
        float[] filt_state = new float[7];
        float[][] C = new float[4][221];
        float[] CC = new float[11];
        int[] d_srch = new int[24];
        short[] d_comp = new short[221];
        float[][][] energies_st3 = new float[4][34][5];
        float[][][] cross_corr_st3 = new float[4][34][5];
        assert (Fs_kHz == 8 || Fs_kHz == 12 || Fs_kHz == 16 || Fs_kHz == 24);
        assert (complexity >= 0);
        assert (complexity <= 2);
        assert (search_thres1 >= 0.0f && search_thres1 <= 1.0f);
        assert (search_thres2 >= 0.0f && search_thres2 <= 1.0f);
        int frame_length = 40 * Fs_kHz;
        int frame_length_4kHz = 160;
        int frame_length_8kHz = 320;
        int sf_length = frame_length >> 3;
        int sf_length_4kHz = frame_length_4kHz >> 3;
        int sf_length_8kHz = frame_length_8kHz >> 3;
        int min_lag = 2 * Fs_kHz;
        int min_lag_4kHz = 8;
        int min_lag_8kHz = 16;
        int max_lag = 18 * Fs_kHz;
        int max_lag_4kHz = 72;
        int max_lag_8kHz = 144;
        for (i_djinn3 = 0; i_djinn3 < 4; ++i_djinn3) {
            for (int j_djinn = 0; j_djinn < 221; ++j_djinn) {
                C[i_djinn3][j_djinn] = 0.0f;
            }
        }
        if (Fs_kHz == 12) {
            short[] signal_12 = new short[480];
            short[] signal_8 = new short[320];
            int[] R23 = new int[6];
            for (i_djinn2 = 0; i_djinn2 < 6; ++i_djinn2) {
                R23[i_djinn2] = 0;
            }
            Silk_SigProc_FLP.SKP_float2short_array(signal_12, 0, signal, 0, 480);
            Silk_resampler_down2_3.SKP_Silk_resampler_down2_3(R23, 0, signal_8, 0, signal_12, 0, 480);
            Silk_SigProc_FLP.SKP_short2float_array(signal_8kHz, 0, signal_8, 0, frame_length_8kHz);
        } else if (Fs_kHz == 16) {
            if (complexity == 2) {
                for (i_djinn3 = 0; i_djinn3 < 4; ++i_djinn3) {
                    filt_state[i_djinn3] = 0.0f;
                }
                Silk_decimate2_coarse_FLP.SKP_Silk_decimate2_coarse_FLP(signal, 0, filt_state, 0, signal_8kHz, 0, scratch_mem, 0, frame_length_8kHz);
            } else {
                for (i_djinn3 = 0; i_djinn3 < 2; ++i_djinn3) {
                    filt_state[i_djinn3] = 0.0f;
                }
                Silk_decimate2_coarsest_FLP.SKP_Silk_decimate2_coarsest_FLP(signal, 0, filt_state, 0, signal_8kHz, 0, scratch_mem, 0, frame_length_8kHz);
            }
        } else if (Fs_kHz == 24) {
            short[] signal_24 = new short[960];
            short[] signal_8 = new short[320];
            int[] filt_state_fix = new int[8];
            Silk_SigProc_FLP.SKP_float2short_array(signal_24, 0, signal, 0, 960);
            for (i_djinn2 = 0; i_djinn2 < 8; ++i_djinn2) {
                filt_state_fix[i_djinn2] = 0;
            }
            Silk_resampler_down3.SKP_Silk_resampler_down3(filt_state_fix, 0, signal_8, 0, signal_24, 0, 960);
            Silk_SigProc_FLP.SKP_short2float_array(signal_8kHz, 0, signal_8, 0, frame_length_8kHz);
        } else {
            assert (Fs_kHz == 8);
            for (i_djinn3 = 0; i_djinn3 < frame_length_8kHz; ++i_djinn3) {
                signal_8kHz[i_djinn3] = signal[i_djinn3];
            }
        }
        if (complexity == 2) {
            for (i_djinn = 0; i_djinn < 4; ++i_djinn) {
                filt_state[i_djinn] = 0.0f;
            }
            Silk_decimate2_coarse_FLP.SKP_Silk_decimate2_coarse_FLP(signal_8kHz, 0, filt_state, 0, signal_4kHz, 0, scratch_mem, 0, frame_length_4kHz);
        } else {
            for (i_djinn = 0; i_djinn < 4; ++i_djinn) {
                filt_state[i_djinn] = 0.0f;
            }
            Silk_decimate2_coarsest_FLP.SKP_Silk_decimate2_coarsest_FLP(signal_8kHz, 0, filt_state, 0, signal_4kHz, 0, scratch_mem, 0, frame_length_4kHz);
        }
        for (i = frame_length_4kHz - 1; i > 0; --i) {
            int n = i;
            signal_4kHz[n] = signal_4kHz[n] + signal_4kHz[i - 1];
        }
        float[] target_ptr = signal_4kHz;
        int target_ptr_offset = frame_length_4kHz >> 1;
        for (k = 0; k < 2; ++k) {
            assert (target_ptr_offset >= 0);
            assert (target_ptr_offset + sf_length_8kHz <= frame_length_4kHz);
            basis_ptr = target_ptr;
            basis_ptr_offset = target_ptr_offset - min_lag_4kHz;
            assert (basis_ptr_offset >= 0);
            assert (basis_ptr_offset + sf_length_8kHz <= frame_length_4kHz);
            cross_corr = Silk_inner_product_FLP.SKP_Silk_inner_product_FLP(target_ptr, target_ptr_offset, basis_ptr, basis_ptr_offset, sf_length_8kHz);
            double normalizer = Silk_energy_FLP.SKP_Silk_energy_FLP(basis_ptr, basis_ptr_offset, sf_length_8kHz) + 1000.0;
            float[] fArray = C[0];
            int n = min_lag_4kHz;
            fArray[n] = fArray[n] + (float)(cross_corr / Math.sqrt(normalizer));
            d = min_lag_4kHz + 1;
            while (d <= max_lag_4kHz) {
                assert (--basis_ptr_offset >= 0);
                assert (basis_ptr_offset + sf_length_8kHz <= frame_length_4kHz);
                cross_corr = Silk_inner_product_FLP.SKP_Silk_inner_product_FLP(target_ptr, target_ptr_offset, basis_ptr, basis_ptr_offset, sf_length_8kHz);
                float[] fArray2 = C[0];
                int n2 = d++;
                fArray2[n2] = fArray2[n2] + (float)(cross_corr / Math.sqrt(normalizer += (double)(basis_ptr[basis_ptr_offset + 0] * basis_ptr[basis_ptr_offset + 0] - basis_ptr[basis_ptr_offset + sf_length_8kHz] * basis_ptr[basis_ptr_offset + sf_length_8kHz])));
            }
            target_ptr_offset += sf_length_8kHz;
        }
        for (i = max_lag_4kHz; i >= min_lag_4kHz; --i) {
            float[] fArray = C[0];
            int n = i;
            fArray[n] = fArray[n] - C[0][i] * (float)i / 4096.0f;
        }
        int length_d_srch = 5 + complexity;
        assert (length_d_srch <= 24);
        Silk_sort_FLP.SKP_Silk_insertion_sort_decreasing_FLP(C[0], min_lag_4kHz, d_srch, max_lag_4kHz - min_lag_4kHz + 1, length_d_srch);
        float Cmax = C[0][min_lag_4kHz];
        target_ptr = signal_4kHz;
        target_ptr_offset = frame_length_4kHz >> 1;
        double energy = 1000.0;
        for (i = 0; i < frame_length_4kHz >> 1; ++i) {
            energy += (double)(target_ptr[target_ptr_offset + i] * target_ptr[target_ptr_offset + i]);
        }
        float threshold = Cmax * Cmax;
        if (energy / 16.0 > (double)threshold) {
            for (i_djinn = 0; i_djinn < 4; ++i_djinn) {
                pitch_out[i_djinn] = 0;
            }
            LTPCorr[0] = 0.0f;
            lagIndex[0] = 0;
            contourIndex[0] = 0;
            return 1;
        }
        threshold = search_thres1 * Cmax;
        for (i = 0; i < length_d_srch; ++i) {
            if (!(C[0][min_lag_4kHz + i] > threshold)) {
                length_d_srch = i;
                break;
            }
            d_srch[i] = d_srch[i] + min_lag_4kHz << 1;
        }
        assert (length_d_srch > 0);
        for (i = min_lag_8kHz - 5; i < max_lag_8kHz + 5; ++i) {
            d_comp[i] = 0;
        }
        for (i = 0; i < length_d_srch; ++i) {
            d_comp[d_srch[i]] = 1;
        }
        for (i = max_lag_8kHz + 3; i >= min_lag_8kHz; --i) {
            int n = i;
            d_comp[n] = (short)(d_comp[n] + (d_comp[i - 1] + d_comp[i - 2]));
        }
        length_d_srch = 0;
        for (i = min_lag_8kHz; i < max_lag_8kHz + 1; ++i) {
            if (d_comp[i + 1] <= 0) continue;
            d_srch[length_d_srch] = i;
            ++length_d_srch;
        }
        for (i = max_lag_8kHz + 3; i >= min_lag_8kHz; --i) {
            int n = i;
            d_comp[n] = (short)(d_comp[n] + (d_comp[i - 1] + d_comp[i - 2] + d_comp[i - 3]));
        }
        int length_d_comp = 0;
        for (i = min_lag_8kHz; i < max_lag_8kHz + 4; ++i) {
            if (d_comp[i] <= 0) continue;
            d_comp[length_d_comp] = (short)(i - 2);
            ++length_d_comp;
        }
        for (i_djinn = 0; i_djinn < 4; ++i_djinn) {
            for (int j_djinn = 0; j_djinn < 221; ++j_djinn) {
                C[i_djinn][j_djinn] = 0.0f;
            }
        }
        target_ptr = signal_8kHz;
        target_ptr_offset = frame_length_4kHz;
        for (k = 0; k < 4; ++k) {
            assert (target_ptr_offset >= 0);
            assert (target_ptr_offset + sf_length_8kHz <= frame_length_8kHz);
            double energy_tmp = Silk_energy_FLP.SKP_Silk_energy_FLP(target_ptr, target_ptr_offset, sf_length_8kHz);
            for (j = 0; j < length_d_comp; ++j) {
                d = d_comp[j];
                basis_ptr = target_ptr;
                basis_ptr_offset = target_ptr_offset - d;
                assert (basis_ptr_offset >= 0);
                assert (basis_ptr_offset + sf_length_8kHz <= frame_length_8kHz);
                cross_corr = Silk_inner_product_FLP.SKP_Silk_inner_product_FLP(basis_ptr, basis_ptr_offset, target_ptr, target_ptr_offset, sf_length_8kHz);
                energy = Silk_energy_FLP.SKP_Silk_energy_FLP(basis_ptr, basis_ptr_offset, sf_length_8kHz);
                C[k][d] = cross_corr > 0.0 ? (float)(cross_corr * cross_corr / (energy * energy_tmp + 1.1920928955078125E-7)) : 0.0f;
            }
            target_ptr_offset += sf_length_8kHz;
        }
        float CCmax = 0.0f;
        float CCmax_b = -1000.0f;
        int CBimax = 0;
        int lag = -1;
        if (prevLag > 0) {
            if (Fs_kHz == 12) {
                prevLag = (prevLag << 1) / 3;
            } else if (Fs_kHz == 16) {
                prevLag >>= 1;
            } else if (Fs_kHz == 24) {
                prevLag /= 3;
            }
            prevLag_log2 = Silk_pitch_analysis_core_FLP.SKP_P_log2(prevLag);
        } else {
            prevLag_log2 = 0.0f;
        }
        int nb_cbks_stage2 = Fs_kHz == 8 && complexity > 0 ? 11 : 3;
        for (k = 0; k < length_d_srch; ++k) {
            d = d_srch[k];
            for (j = 0; j < nb_cbks_stage2; ++j) {
                CC[j] = 0.0f;
                for (i = 0; i < 4; ++i) {
                    int n = j;
                    CC[n] = CC[n] + C[i][d + Silk_pitch_est_tables.SKP_Silk_CB_lags_stage2[i][j]];
                }
            }
            CCmax_new = -1000.0f;
            int CBimax_new = 0;
            for (i = 0; i < nb_cbks_stage2; ++i) {
                if (!(CC[i] > CCmax_new)) continue;
                CCmax_new = CC[i];
                CBimax_new = i;
            }
            float CCmax_new_b = CCmax_new = Math.max(CCmax_new, 0.0f);
            float lag_log2 = Silk_pitch_analysis_core_FLP.SKP_P_log2(d);
            CCmax_new_b -= 0.8f * lag_log2;
            if (prevLag > 0) {
                float delta_lag_log2_sqr = lag_log2 - prevLag_log2;
                delta_lag_log2_sqr *= delta_lag_log2_sqr;
                CCmax_new_b -= 0.8f * LTPCorr[0] * delta_lag_log2_sqr / (delta_lag_log2_sqr + 0.5f);
            }
            if (!(CCmax_new_b > CCmax_b) || !(CCmax_new > 4.0f * search_thres2 * search_thres2)) continue;
            CCmax_b = CCmax_new_b;
            CCmax = CCmax_new;
            lag = d;
            CBimax = CBimax_new;
        }
        if (lag == -1) {
            for (i_djinn = 0; i_djinn < 4; ++i_djinn) {
                pitch_out[i_djinn] = 0;
            }
            LTPCorr[0] = 0.0f;
            lagIndex[0] = 0;
            contourIndex[0] = 0;
            return 1;
        }
        if (Fs_kHz > 8) {
            assert (lag == Silk_SigProc_FIX.SKP_SAT16(lag));
            lag = Fs_kHz == 12 ? Silk_SigProc_FIX.SKP_RSHIFT_ROUND(Silk_macros.SKP_SMULBB(lag, 3), 1) : (Fs_kHz == 16 ? (lag <<= 1) : Silk_macros.SKP_SMULBB(lag, 3));
            lag = Silk_SigProc_FIX.SKP_LIMIT_int(lag, min_lag, max_lag);
            int start_lag = Math.max(lag - 2, min_lag);
            int end_lag = Math.min(lag + 2, max_lag);
            int lag_new = lag;
            CBimax = 0;
            assert (CCmax >= 0.0f);
            LTPCorr[0] = (float)Math.sqrt(CCmax / 4.0f);
            CCmax = -1000.0f;
            Silk_pitch_analysis_core_FLP.SKP_P_Ana_calc_corr_st3(cross_corr_st3, signal, 0, start_lag, sf_length, complexity);
            Silk_pitch_analysis_core_FLP.SKP_P_Ana_calc_energy_st3(energies_st3, signal, 0, start_lag, sf_length, complexity);
            int lag_counter = 0;
            assert (lag == Silk_SigProc_FIX.SKP_SAT16(lag));
            float contour_bias = 0.05f / (float)lag;
            short cbk_size = Silk_pitch_est_tables.SKP_Silk_cbk_sizes_stage3[complexity];
            int cbk_offset = Silk_pitch_est_tables.SKP_Silk_cbk_offsets_stage3[complexity];
            for (d = start_lag; d <= end_lag; ++d) {
                for (j = cbk_offset; j < cbk_offset + cbk_size; ++j) {
                    cross_corr = 0.0;
                    energy = 1.1920928955078125E-7;
                    for (k = 0; k < 4; ++k) {
                        energy += (double)energies_st3[k][j][lag_counter];
                        cross_corr += (double)cross_corr_st3[k][j][lag_counter];
                    }
                    if (cross_corr > 0.0) {
                        CCmax_new = (float)(cross_corr * cross_corr / energy);
                        int diff = j - 17;
                        CCmax_new *= 1.0f - contour_bias * (float)diff * (float)diff;
                    } else {
                        CCmax_new = 0.0f;
                    }
                    if (!(CCmax_new > CCmax)) continue;
                    CCmax = CCmax_new;
                    lag_new = d;
                    CBimax = j;
                }
                ++lag_counter;
            }
            for (k = 0; k < 4; ++k) {
                pitch_out[k] = lag_new + Silk_pitch_est_tables.SKP_Silk_CB_lags_stage3[k][CBimax];
            }
            lagIndex[0] = lag_new - min_lag;
            contourIndex[0] = CBimax;
        } else {
            assert (CCmax >= 0.0f);
            LTPCorr[0] = (float)Math.sqrt(CCmax / 4.0f);
            for (k = 0; k < 4; ++k) {
                pitch_out[k] = lag + Silk_pitch_est_tables.SKP_Silk_CB_lags_stage2[k][CBimax];
            }
            lagIndex[0] = lag - min_lag;
            contourIndex[0] = CBimax;
        }
        assert (lagIndex[0] >= 0);
        return 0;
    }

    static void SKP_P_Ana_calc_corr_st3(float[][][] cross_corr_st3, float[] signal, int signal_offset, int start_lag, int sf_length, int complexity) {
        float[] scratch_mem = new float[22];
        assert (complexity >= 0);
        assert (complexity <= 2);
        int cbk_offset = Silk_pitch_est_tables.SKP_Silk_cbk_offsets_stage3[complexity];
        short cbk_size = Silk_pitch_est_tables.SKP_Silk_cbk_sizes_stage3[complexity];
        float[] target_ptr = signal;
        int target_ptr_offset = signal_offset + (sf_length << 2);
        for (int k = 0; k < 4; ++k) {
            int j;
            int lag_counter = 0;
            for (j = Silk_pitch_est_tables.SKP_Silk_Lag_range_stage3[complexity][k][0]; j <= Silk_pitch_est_tables.SKP_Silk_Lag_range_stage3[complexity][k][1]; ++j) {
                float[] basis_ptr = target_ptr;
                int basis_ptr_offset = target_ptr_offset - (start_lag + j);
                assert (lag_counter < 22);
                scratch_mem[lag_counter] = (float)Silk_inner_product_FLP.SKP_Silk_inner_product_FLP(target_ptr, target_ptr_offset, basis_ptr, basis_ptr_offset, sf_length);
                ++lag_counter;
            }
            short delta = Silk_pitch_est_tables.SKP_Silk_Lag_range_stage3[complexity][k][0];
            for (int i = cbk_offset; i < cbk_offset + cbk_size; ++i) {
                int idx = Silk_pitch_est_tables.SKP_Silk_CB_lags_stage3[k][i] - delta;
                for (j = 0; j < 5; ++j) {
                    assert (idx + j < 22);
                    assert (idx + j < lag_counter);
                    cross_corr_st3[k][i][j] = scratch_mem[idx + j];
                }
            }
            target_ptr_offset += sf_length;
        }
    }

    static void SKP_P_Ana_calc_energy_st3(float[][][] energies_st3, float[] signal, int signal_offset, int start_lag, int sf_length, int complexity) {
        float[] scratch_mem = new float[22];
        assert (complexity >= 0);
        assert (complexity <= 2);
        int cbk_offset = Silk_pitch_est_tables.SKP_Silk_cbk_offsets_stage3[complexity];
        short cbk_size = Silk_pitch_est_tables.SKP_Silk_cbk_sizes_stage3[complexity];
        float[] target_ptr = signal;
        int target_ptr_offset = signal_offset + (sf_length << 2);
        for (int k = 0; k < 4; ++k) {
            int i;
            int lag_counter = 0;
            float[] basis_ptr = target_ptr;
            int basis_ptr_offset = target_ptr_offset - (start_lag + Silk_pitch_est_tables.SKP_Silk_Lag_range_stage3[complexity][k][0]);
            double energy = Silk_energy_FLP.SKP_Silk_energy_FLP(basis_ptr, basis_ptr_offset, sf_length) + 0.001;
            assert (energy >= 0.0);
            scratch_mem[lag_counter] = (float)energy;
            ++lag_counter;
            for (i = 1; i < Silk_pitch_est_tables.SKP_Silk_Lag_range_stage3[complexity][k][1] - Silk_pitch_est_tables.SKP_Silk_Lag_range_stage3[complexity][k][0] + 1; ++i) {
                assert ((energy -= (double)(basis_ptr[basis_ptr_offset + sf_length - i] * basis_ptr[basis_ptr_offset + sf_length - i])) >= 0.0);
                assert ((energy += (double)(basis_ptr[basis_ptr_offset - i] * basis_ptr[basis_ptr_offset - i])) >= 0.0);
                assert (lag_counter < 22);
                scratch_mem[lag_counter] = (float)energy;
                ++lag_counter;
            }
            short delta = Silk_pitch_est_tables.SKP_Silk_Lag_range_stage3[complexity][k][0];
            for (i = cbk_offset; i < cbk_offset + cbk_size; ++i) {
                int idx = Silk_pitch_est_tables.SKP_Silk_CB_lags_stage3[k][i] - delta;
                for (int j = 0; j < 5; ++j) {
                    assert (idx + j < 22);
                    assert (idx + j < lag_counter);
                    energies_st3[k][i][j] = scratch_mem[idx + j];
                    assert (energies_st3[k][i][j] >= 0.0f);
                }
            }
            target_ptr_offset += sf_length;
        }
    }
}

