/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h264;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.video.h264.Packetizer;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.util.Logger;

public class DePacketizer
extends AbstractCodec2 {
    private static final Logger logger = Logger.getLogger(DePacketizer.class);
    public static final byte[] NAL_PREFIX = new byte[]{0, 0, 0, 1};
    private static final boolean OUTPUT_INCOMPLETE_NAL_UNITS = true;
    private static final long TIME_BETWEEN_REQUEST_KEY_FRAME = 500L;
    private static final long TIME_FROM_KEY_FRAME_TO_REQUEST_KEY_FRAME = 13000L;
    private static final int UNSPECIFIED_NAL_UNIT_TYPE = 0;
    private boolean fuaStartedAndNotEnded = false;
    private KeyFrameControl keyFrameControl;
    private long lastKeyFrameTime = -1L;
    private long lastRequestKeyFrameTime = -1L;
    private long lastSequenceNumber = -1L;
    private int nal_unit_type;
    private final int outputPaddingSize = 8;
    private boolean requestKeyFrame = false;
    private Thread requestKeyFrameThread;

    public DePacketizer() {
        super("H264 DePacketizer", VideoFormat.class, (Format[])new VideoFormat[]{new VideoFormat("h264")});
        ArrayList<VideoFormat> inputFormats = new ArrayList<VideoFormat>();
        inputFormats.add(new VideoFormat("h264/rtp"));
        Collections.addAll(inputFormats, Packetizer.SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = inputFormats.toArray(EMPTY_FORMATS);
    }

    private int dePacketizeFUA(byte[] in, int inOffset, int inLength, Buffer outBuffer) {
        int octet;
        int nal_unit_type;
        byte fu_indicator = in[inOffset];
        --inLength;
        byte fu_header = in[++inOffset];
        ++inOffset;
        this.nal_unit_type = nal_unit_type = fu_header & 0x1F;
        boolean start_bit = (fu_header & 0x80) != 0;
        boolean end_bit = (fu_header & 0x40) != 0;
        int outOffset = outBuffer.getOffset();
        int newOutLength = --inLength;
        if (start_bit) {
            if (end_bit) {
                outBuffer.setDiscard(true);
                return 0;
            }
            this.fuaStartedAndNotEnded = true;
            newOutLength += NAL_PREFIX.length + 1;
            octet = fu_indicator & 0xE0 | nal_unit_type;
        } else {
            if (!this.fuaStartedAndNotEnded) {
                outBuffer.setDiscard(true);
                return 0;
            }
            int outLength = outBuffer.getLength();
            outOffset += outLength;
            newOutLength += outLength;
            octet = 0;
        }
        byte[] out = DePacketizer.validateByteArraySize(outBuffer, outBuffer.getOffset() + newOutLength + 8, true);
        if (start_bit) {
            System.arraycopy(NAL_PREFIX, 0, out, outOffset, NAL_PREFIX.length);
            out[outOffset += DePacketizer.NAL_PREFIX.length] = (byte)(octet & 0xFF);
            ++outOffset;
        }
        System.arraycopy(in, inOffset, out, outOffset, inLength);
        this.padOutput(out, outOffset += inLength);
        outBuffer.setLength(newOutLength);
        if (end_bit) {
            this.fuaStartedAndNotEnded = false;
            return 0;
        }
        return 4;
    }

    private int dePacketizeSingleNALUnitPacket(int nal_unit_type, byte[] in, int inOffset, int inLength, Buffer outBuffer) {
        this.nal_unit_type = nal_unit_type;
        int outOffset = outBuffer.getOffset();
        int newOutLength = NAL_PREFIX.length + inLength;
        byte[] out = DePacketizer.validateByteArraySize(outBuffer, outOffset + newOutLength + 8, true);
        System.arraycopy(NAL_PREFIX, 0, out, outOffset, NAL_PREFIX.length);
        System.arraycopy(in, inOffset, out, outOffset += NAL_PREFIX.length, inLength);
        this.padOutput(out, outOffset += inLength);
        outBuffer.setLength(newOutLength);
        return 0;
    }

    protected synchronized void doClose() {
        this.requestKeyFrameThread = null;
        ((Object)((Object)this)).notifyAll();
    }

    protected synchronized void doOpen() throws ResourceUnavailableException {
        this.fuaStartedAndNotEnded = false;
        this.lastKeyFrameTime = -1L;
        this.lastRequestKeyFrameTime = -1L;
        this.lastSequenceNumber = -1L;
        this.nal_unit_type = 0;
        this.requestKeyFrame = false;
        this.requestKeyFrameThread = null;
    }

    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int inOffset;
        int ret;
        boolean requestKeyFrame;
        long sequenceNumber = inBuffer.getSequenceNumber();
        boolean bl = requestKeyFrame = this.lastKeyFrameTime == -1L;
        if (this.lastSequenceNumber != -1L && sequenceNumber - this.lastSequenceNumber != 1L) {
            if (logger.isTraceEnabled()) {
                logger.trace("Dropped RTP packets upto sequenceNumber " + this.lastSequenceNumber + " and continuing with sequenceNumber " + sequenceNumber);
            }
            requestKeyFrame = true;
            ret = this.reset(outBuffer);
            if ((ret & 4) == 0) {
                this.setRequestKeyFrame(requestKeyFrame);
                return ret;
            }
        }
        this.lastSequenceNumber = sequenceNumber;
        byte[] in = (byte[])inBuffer.getData();
        byte octet = in[inOffset = inBuffer.getOffset()];
        int nal_unit_type = octet & 0x1F;
        if (nal_unit_type >= 1 && nal_unit_type <= 23) {
            this.fuaStartedAndNotEnded = false;
            ret = this.dePacketizeSingleNALUnitPacket(nal_unit_type, in, inOffset, inBuffer.getLength(), outBuffer);
        } else if (nal_unit_type == 28) {
            ret = this.dePacketizeFUA(in, inOffset, inBuffer.getLength(), outBuffer);
            if (outBuffer.isDiscard()) {
                this.fuaStartedAndNotEnded = false;
            }
        } else {
            logger.warn("Dropping NAL unit of unsupported type " + nal_unit_type);
            this.nal_unit_type = nal_unit_type;
            this.fuaStartedAndNotEnded = false;
            outBuffer.setDiscard(true);
            ret = 0;
        }
        outBuffer.setSequenceNumber(sequenceNumber);
        if ((inBuffer.getFlags() & 0x800) != 0) {
            outBuffer.setFlags(outBuffer.getFlags() | 0x800);
        }
        switch (this.nal_unit_type) {
            case 5: {
                this.lastKeyFrameTime = System.currentTimeMillis();
            }
            case 7: 
            case 8: {
                requestKeyFrame = false;
                break;
            }
        }
        this.setRequestKeyFrame(requestKeyFrame);
        return ret;
    }

    private void padOutput(byte[] out, int outOffset) {
        Arrays.fill(out, outOffset, outOffset + 8, (byte)0);
    }

    public synchronized boolean requestKeyFrame(boolean urgent) {
        this.lastKeyFrameTime = -1L;
        this.setRequestKeyFrame(true);
        return true;
    }

    private int reset(Buffer outBuffer) {
        Object outData;
        if (this.fuaStartedAndNotEnded && outBuffer.getLength() >= NAL_PREFIX.length + 1 + 1 && (outData = outBuffer.getData()) instanceof byte[]) {
            int octetIndex;
            byte[] out = (byte[])outData;
            int n = octetIndex = outBuffer.getOffset() + NAL_PREFIX.length;
            out[n] = (byte)(out[n] | 0x80);
            this.fuaStartedAndNotEnded = false;
            return 2;
        }
        this.fuaStartedAndNotEnded = false;
        outBuffer.setLength(0);
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInRequestKeyFrameThread() {
        while (true) {
            List<KeyFrameControl.KeyFrameRequester> keyFrameRequesters;
            DePacketizer dePacketizer = this;
            synchronized (dePacketizer) {
                long nextRequestKeyFrameTime;
                long nextKeyFrameTime;
                if (this.requestKeyFrameThread != Thread.currentThread()) {
                    break;
                }
                long now = System.currentTimeMillis();
                long timeout = this.requestKeyFrame ? (now >= (nextKeyFrameTime = this.lastKeyFrameTime + 13000L) ? (now >= (nextRequestKeyFrameTime = this.lastRequestKeyFrameTime + 500L) ? -1L : nextRequestKeyFrameTime - now) : nextKeyFrameTime - now) : 0L;
                if (timeout >= 0L) {
                    try {
                        ((Object)((Object)this)).wait(timeout);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    continue;
                }
            }
            KeyFrameControl keyFrameControl = this.keyFrameControl;
            if (keyFrameControl != null && (keyFrameRequesters = keyFrameControl.getKeyFrameRequesters()) != null) {
                for (KeyFrameControl.KeyFrameRequester keyFrameRequester : keyFrameRequesters) {
                    try {
                        if (!keyFrameRequester.requestKeyFrame()) continue;
                        break;
                    }
                    catch (Exception e) {
                    }
                }
            }
            this.lastRequestKeyFrameTime = System.currentTimeMillis();
        }
    }

    public void setKeyFrameControl(KeyFrameControl keyFrameControl) {
        this.keyFrameControl = keyFrameControl;
    }

    private synchronized void setRequestKeyFrame(boolean requestKeyFrame) {
        if (this.requestKeyFrame != requestKeyFrame) {
            this.requestKeyFrame = requestKeyFrame;
            if (this.requestKeyFrame && this.requestKeyFrameThread == null) {
                this.requestKeyFrameThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        DePacketizer dePacketizer;
                        try {
                            DePacketizer.this.runInRequestKeyFrameThread();
                            Object var2_1 = null;
                            dePacketizer = DePacketizer.this;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            DePacketizer dePacketizer2 = DePacketizer.this;
                            synchronized (dePacketizer2) {
                                if (DePacketizer.this.requestKeyFrameThread == Thread.currentThread()) {
                                    DePacketizer.this.requestKeyFrameThread = null;
                                }
                            }
                            throw throwable;
                        }
                        synchronized (dePacketizer) {
                            if (DePacketizer.this.requestKeyFrameThread == Thread.currentThread()) {
                                DePacketizer.this.requestKeyFrameThread = null;
                            }
                        }
                    }
                };
                this.requestKeyFrameThread.start();
            }
            ((Object)((Object)this)).notifyAll();
        }
    }
}

