/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferStream;
import org.jitsi.impl.neomedia.conference.InputDataSourceDesc;
import org.jitsi.impl.neomedia.conference.InputStreamDesc;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.impl.neomedia.protocol.CachingPushBufferStream;
import org.jitsi.impl.neomedia.protocol.StreamSubstituteBufferTransferHandler;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AudioMixerPushBufferStream
extends ControlsAdapter
implements PushBufferStream {
    private static final Logger logger = Logger.getLogger(AudioMixerPushBufferStream.class);
    private static final float INT_TO_SHORT_RATIO = 65538.0f;
    private static final float SHORT_TO_INT_RATIO = 1.5258323E-5f;
    private static final long TRACE_NON_CONTRIBUTING_READ_COUNT = 0L;
    private final AudioMixer audioMixer;
    private InputStreamDesc[] inputStreams;
    private final Object inputStreamsSyncRoot = new Object();
    private SoftReference<List<int[]>> intArrays;
    private final Object intArraysSyncRoot = new Object();
    private AudioFormat lastReadInputFormat;
    private final AudioFormat outputFormat;
    private final List<AudioMixingPushBufferStream> outputStreams = new ArrayList<AudioMixingPushBufferStream>();
    private final BufferTransferHandler transferHandler = new BufferTransferHandler(){
        private final Buffer buffer = new Buffer();

        public void transferData(PushBufferStream stream) {
            this.buffer.setLength(0);
            AudioMixerPushBufferStream.this.transferData(this.buffer);
            this.buffer.setLength(0);
        }
    };

    public AudioMixerPushBufferStream(AudioMixer audioMixer, AudioFormat outputFormat) {
        this.audioMixer = audioMixer;
        this.outputFormat = outputFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOutputStream(AudioMixingPushBufferStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream");
        }
        List<AudioMixingPushBufferStream> list = this.outputStreams;
        synchronized (list) {
            block8: {
                if (!this.outputStreams.contains(outputStream) && this.outputStreams.add(outputStream) && this.outputStreams.size() == 1) {
                    boolean started = false;
                    try {
                        this.audioMixer.start(this);
                        started = true;
                        Object var5_4 = null;
                        if (started) break block8;
                        this.outputStreams.remove(outputStream);
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (!started) {
                            this.outputStreams.remove(outputStream);
                        }
                        throw throwable;
                    }
                    {
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] allocateIntArray(int minSize) {
        Object object = this.intArraysSyncRoot;
        synchronized (object) {
            List<int[]> intArrays;
            List<int[]> list = intArrays = this.intArrays == null ? null : this.intArrays.get();
            if (intArrays != null) {
                Iterator<int[]> i = intArrays.iterator();
                while (i.hasNext()) {
                    int[] intArray = i.next();
                    if (intArray.length < minSize) continue;
                    i.remove();
                    return intArray;
                }
            }
        }
        return new int[minSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocateIntArray(int[] intArray) {
        if (intArray == null) {
            return;
        }
        Object object = this.intArraysSyncRoot;
        synchronized (object) {
            List<Object> intArrays;
            if (this.intArrays == null || (intArrays = this.intArrays.get()) == null) {
                intArrays = new LinkedList();
                this.intArrays = new SoftReference<List<Object>>(intArrays);
            }
            if (intArrays.size() != 0) {
                for (int[] nArray : intArrays) {
                    if (nArray != intArray) continue;
                    return;
                }
            }
            intArrays.add(intArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endOfStream() {
        Object object = this.inputStreamsSyncRoot;
        synchronized (object) {
            if (this.inputStreams != null) {
                for (InputStreamDesc inputStreamDesc : this.inputStreams) {
                    if (inputStreamDesc.getInputStream().endOfStream()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void equalizeInputStreamBufferLength() {
        Object object = this.inputStreamsSyncRoot;
        synchronized (object) {
            if (this.inputStreams == null || this.inputStreams.length < 1) {
                return;
            }
            BufferControl bufferControl = this.getBufferControl(this.inputStreams[0]);
            long bufferLength = bufferControl == null ? 20L : bufferControl.getBufferLength();
            for (int i = 1; i < this.inputStreams.length; ++i) {
                BufferControl inputStreamBufferControl = this.getBufferControl(this.inputStreams[i]);
                if (inputStreamBufferControl == null) continue;
                inputStreamBufferControl.setBufferLength(bufferLength);
            }
        }
    }

    private BufferControl getBufferControl(InputStreamDesc inputStreamDesc) {
        BufferControl bufferControl;
        BufferControl bufferControl2;
        InputDataSourceDesc inputDataSourceDesc = inputStreamDesc.inputDataSourceDesc;
        DataSource effectiveInputDataSource = inputDataSourceDesc.getEffectiveInputDataSource();
        String bufferControlType = BufferControl.class.getName();
        if (effectiveInputDataSource != null && (bufferControl2 = (BufferControl)effectiveInputDataSource.getControl(bufferControlType)) != null) {
            return bufferControl2;
        }
        DataSource inputDataSource = inputDataSourceDesc.inputDataSource;
        if (inputDataSource != null && inputDataSource != effectiveInputDataSource && (bufferControl = (BufferControl)inputDataSource.getControl(bufferControlType)) != null) {
            return bufferControl;
        }
        return (BufferControl)inputStreamDesc.getInputStream().getControl(bufferControlType);
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor(this.audioMixer.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength() {
        long contentLength = 0L;
        Object object = this.inputStreamsSyncRoot;
        synchronized (object) {
            if (this.inputStreams != null) {
                for (InputStreamDesc inputStreamDesc : this.inputStreams) {
                    long inputContentLength = inputStreamDesc.getInputStream().getContentLength();
                    if (-1L == inputContentLength) {
                        return -1L;
                    }
                    if (contentLength >= inputContentLength) continue;
                    contentLength = inputContentLength;
                }
            }
        }
        return contentLength;
    }

    public AudioFormat getFormat() {
        return this.outputFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStreamDesc[] getInputStreams() {
        Object object = this.inputStreamsSyncRoot;
        synchronized (object) {
            return this.inputStreams == null ? null : (InputStreamDesc[])this.inputStreams.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        int maxInputSampleCount;
        InputSampleDesc inputSampleDesc;
        Object object = this.inputStreamsSyncRoot;
        synchronized (object) {
            InputStreamDesc[] thisInputStreams = this.inputStreams;
            if (thisInputStreams == null || thisInputStreams.length == 0) {
                return;
            }
            inputSampleDesc = (InputSampleDesc)buffer.getData();
            int inputStreamCount = thisInputStreams.length;
            if (inputSampleDesc != null) {
                InputStreamDesc[] inputSampleDescInputStreams = inputSampleDesc.inputStreams;
                if (inputSampleDescInputStreams.length == inputStreamCount) {
                    for (int i = 0; i < inputStreamCount; ++i) {
                        if (inputSampleDescInputStreams[i] == thisInputStreams[i]) continue;
                        inputSampleDesc = null;
                        break;
                    }
                } else {
                    inputSampleDesc = null;
                }
            }
            if (inputSampleDesc == null) {
                inputSampleDesc = new InputSampleDesc(new int[inputStreamCount][], (InputStreamDesc[])thisInputStreams.clone());
            }
        }
        AudioFormat outputFormat = this.getFormat();
        try {
            maxInputSampleCount = this.readInputPushBufferStreams(outputFormat, inputSampleDesc);
        }
        catch (UnsupportedFormatException ufex) {
            IOException ioex = new IOException();
            ioex.initCause(ufex);
            throw ioex;
        }
        maxInputSampleCount = Math.max(maxInputSampleCount, this.readInputPullBufferStreams(outputFormat, maxInputSampleCount, inputSampleDesc));
        buffer.setData((Object)inputSampleDesc);
        buffer.setLength(maxInputSampleCount);
        long timeStamp = inputSampleDesc.getTimeStamp();
        if (timeStamp != -1L) {
            buffer.setTimeStamp(timeStamp);
        }
    }

    private int readInputPullBufferStreams(AudioFormat outputFormat, int outputSampleCount, InputSampleDesc inputSampleDesc) throws IOException {
        InputStreamDesc[] inputStreams = inputSampleDesc.inputStreams;
        int maxInputSampleCount = 0;
        for (InputStreamDesc inputStream : inputStreams) {
            if (!(inputStream.getInputStream() instanceof PullBufferStream)) continue;
            throw new UnsupportedOperationException(AudioMixerPushBufferStream.class.getSimpleName() + ".readInputPullBufferStreams" + "(AudioFormat,int,InputSampleDesc)");
        }
        return maxInputSampleCount;
    }

    private void readInputPushBufferStream(InputStreamDesc inputStreamDesc, AudioFormat outputFormat, int sampleCount, Buffer outputBuffer) throws IOException, UnsupportedFormatException {
        Object inputData;
        double outputSampleRate;
        int outputChannels;
        int inputFormatSigned;
        PushBufferStream inputStream = (PushBufferStream)inputStreamDesc.getInputStream();
        AudioFormat inputStreamFormat = (AudioFormat)inputStream.getFormat();
        Buffer inputBuffer = inputStreamDesc.getBuffer(true);
        if (sampleCount != 0) {
            Class inputDataType = inputStreamFormat.getDataType();
            if (Format.byteArray.equals(inputDataType)) {
                Object data = inputBuffer.getData();
                int length = sampleCount * (inputStreamFormat.getSampleSizeInBits() / 8);
                if (!(data instanceof byte[]) || ((byte[])data).length != length) {
                    inputBuffer.setData((Object)new byte[length]);
                }
                inputBuffer.setLength(0);
                inputBuffer.setOffset(0);
            } else {
                throw new UnsupportedFormatException("!Format.getDataType().equals(byte[].class)", (Format)inputStreamFormat);
            }
        }
        this.audioMixer.read(inputStream, inputBuffer, inputStreamDesc.inputDataSourceDesc.inputDataSource);
        if (inputBuffer.isDiscard()) {
            outputBuffer.setDiscard(true);
            return;
        }
        int inputLength = inputBuffer.getLength();
        if (inputLength <= 0) {
            outputBuffer.setDiscard(true);
            return;
        }
        AudioFormat inputFormat = (AudioFormat)inputBuffer.getFormat();
        if (inputFormat == null) {
            inputFormat = inputStreamFormat;
        }
        if (logger.isTraceEnabled() && this.lastReadInputFormat != null && !this.lastReadInputFormat.matches((Format)inputFormat)) {
            this.lastReadInputFormat = inputFormat;
            logger.trace("Read inputSamples in different format " + this.lastReadInputFormat);
        }
        if ((inputFormatSigned = inputFormat.getSigned()) != 1 && inputFormatSigned != -1) {
            throw new UnsupportedFormatException("AudioFormat.getSigned()", (Format)inputFormat);
        }
        int inputChannels = inputFormat.getChannels();
        if (inputChannels != (outputChannels = outputFormat.getChannels()) && inputChannels != -1 && outputChannels != -1) {
            logger.error("Read inputFormat with channels " + inputChannels + " while expected outputFormat channels is " + outputChannels);
            throw new UnsupportedFormatException("AudioFormat.getChannels()", (Format)inputFormat);
        }
        double inputSampleRate = inputFormat.getSampleRate();
        if (inputSampleRate != (outputSampleRate = outputFormat.getSampleRate())) {
            logger.warn("Read inputFormat with sampleRate " + inputSampleRate + " while expected outputFormat sampleRate is " + outputSampleRate);
        }
        if ((inputData = inputBuffer.getData()) == null) {
            outputBuffer.setDiscard(true);
        } else if (inputData instanceof byte[]) {
            int outputLength;
            int inputSampleSizeInBits = inputFormat.getSampleSizeInBits();
            int outputSampleSizeInBits = outputFormat.getSampleSizeInBits();
            if (logger.isTraceEnabled() && inputSampleSizeInBits != outputSampleSizeInBits) {
                logger.trace("Read inputFormat with sampleSizeInBits " + inputSampleSizeInBits + ". Will convert to sampleSizeInBits " + outputSampleSizeInBits);
            }
            byte[] inputSamples = (byte[])inputData;
            switch (inputSampleSizeInBits) {
                case 16: {
                    outputLength = inputLength / 2;
                    int[] outputSamples = this.validateIntArraySize(outputBuffer, outputLength);
                    for (int i = 0; i < outputLength; ++i) {
                        int sample = ArrayIOUtils.readInt16(inputSamples, i * 2);
                        switch (outputSampleSizeInBits) {
                            case 16: {
                                break;
                            }
                            case 32: {
                                sample = Math.round((float)sample * 65538.0f);
                                break;
                            }
                            default: {
                                throw new UnsupportedFormatException("AudioFormat.getSampleSizeInBits()", (Format)outputFormat);
                            }
                        }
                        outputSamples[i] = sample;
                    }
                    break;
                }
                case 32: {
                    outputLength = inputSamples.length / 4;
                    int[] outputSamples = this.validateIntArraySize(outputBuffer, outputLength);
                    for (int i = 0; i < outputLength; ++i) {
                        int sample = AudioMixerPushBufferStream.readInt(inputSamples, i * 4);
                        switch (outputSampleSizeInBits) {
                            case 16: {
                                sample = Math.round((float)sample * 1.5258323E-5f);
                                break;
                            }
                            case 32: {
                                break;
                            }
                            default: {
                                throw new UnsupportedFormatException("AudioFormat.getSampleSizeInBits()", (Format)outputFormat);
                            }
                        }
                        outputSamples[i] = sample;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedFormatException("AudioFormat.getSampleSizeInBits()", (Format)inputFormat);
                }
            }
            outputBuffer.setFlags(inputBuffer.getFlags());
            outputBuffer.setFormat((Format)outputFormat);
            outputBuffer.setLength(outputLength);
            outputBuffer.setOffset(0);
            outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
        } else {
            throw new UnsupportedFormatException("Format.getDataType().equals(" + inputData.getClass() + ")", (Format)inputFormat);
        }
    }

    private int readInputPushBufferStreams(AudioFormat outputFormat, InputSampleDesc inputSampleDesc) throws IOException, UnsupportedFormatException {
        InputStreamDesc[] inputStreams = inputSampleDesc.inputStreams;
        Buffer buffer = inputSampleDesc.getBuffer(true);
        int maxInputSampleCount = 0;
        int[][] inputSamples = inputSampleDesc.inputSamples;
        for (int i = 0; i < inputStreams.length; ++i) {
            InputStreamDesc inputStreamDesc = inputStreams[i];
            SourceStream inputStream = inputStreamDesc.getInputStream();
            if (inputStream instanceof PushBufferStream) {
                int[] samples;
                int sampleCount;
                buffer.setDiscard(false);
                buffer.setLength(0);
                this.readInputPushBufferStream(inputStreamDesc, outputFormat, maxInputSampleCount, buffer);
                if (buffer.isDiscard()) {
                    sampleCount = 0;
                    samples = null;
                } else {
                    sampleCount = buffer.getLength();
                    if (sampleCount <= 0) {
                        sampleCount = 0;
                        samples = null;
                    } else {
                        samples = (int[])buffer.getData();
                    }
                }
                if (sampleCount != 0) {
                    buffer.setData(null);
                    if (samples.length > sampleCount) {
                        Arrays.fill(samples, sampleCount, samples.length, 0);
                    }
                    inputSamples[i] = samples;
                    if (maxInputSampleCount < samples.length) {
                        maxInputSampleCount = samples.length;
                    }
                    if (inputSampleDesc.getTimeStamp() != -1L) continue;
                    inputSampleDesc.setTimeStamp(buffer.getTimeStamp());
                    continue;
                }
            }
            inputSamples[i] = null;
        }
        return maxInputSampleCount;
    }

    private static int readInt(byte[] input, int inputOffset) {
        return input[inputOffset + 3] << 24 | (input[inputOffset + 2] & 0xFF) << 16 | (input[inputOffset + 1] & 0xFF) << 8 | input[inputOffset] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOutputStream(AudioMixingPushBufferStream outputStream) throws IOException {
        List<AudioMixingPushBufferStream> list = this.outputStreams;
        synchronized (list) {
            if (outputStream != null && this.outputStreams.remove(outputStream) && this.outputStreams.isEmpty()) {
                this.audioMixer.stop(this);
            }
        }
    }

    private void setInputSamples(AudioMixingPushBufferStream outputStream, InputSampleDesc inputSampleDesc, int maxInputSampleCount) {
        int[][] inputSamples = inputSampleDesc.inputSamples;
        InputStreamDesc[] inputStreams = inputSampleDesc.inputStreams;
        inputSamples = (int[][])inputSamples.clone();
        CaptureDevice captureDevice = this.audioMixer.captureDevice;
        AudioMixingPushBufferDataSource outputDataSource = outputStream.getDataSource();
        boolean outputDataSourceIsSendingDTMF = captureDevice instanceof AudioMixingPushBufferDataSource ? outputDataSource.isSendingDTMF() : false;
        boolean outputDataSourceIsMute = outputDataSource.isMute();
        for (int i = 0; i < inputSamples.length; ++i) {
            InputStreamDesc inputStreamDesc = inputStreams[i];
            DataSource inputDataSource = inputStreamDesc.inputDataSourceDesc.inputDataSource;
            if (outputDataSourceIsSendingDTMF && inputDataSource == captureDevice) {
                PushBufferStream inputStream = (PushBufferStream)inputStreamDesc.getInputStream();
                AudioFormat inputStreamFormat = (AudioFormat)inputStream.getFormat();
                double sampleRate = inputStreamFormat.getSampleRate();
                int sampleSizeInBits = inputStreamFormat.getSampleSizeInBits();
                inputSamples[i] = outputDataSource.getNextToneSignal(sampleRate, sampleSizeInBits);
                if (maxInputSampleCount >= inputSamples[i].length) continue;
                maxInputSampleCount = inputSamples[i].length;
                continue;
            }
            if (!outputDataSource.equals(inputStreamDesc.getOutputDataSource()) && (!outputDataSourceIsMute || inputDataSource != captureDevice)) continue;
            inputSamples[i] = null;
        }
        outputStream.setInputSamples(inputSamples, maxInputSampleCount, inputSampleDesc.getTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputStreams(Collection<InputStreamDesc> inputStreams) {
        boolean valueIsChanged;
        Object[] oldValue;
        Object[] newValue = null == inputStreams ? null : inputStreams.toArray(new InputStreamDesc[inputStreams.size()]);
        Object object = this.inputStreamsSyncRoot;
        synchronized (object) {
            oldValue = this.inputStreams;
            this.inputStreams = newValue;
        }
        boolean bl = valueIsChanged = !Arrays.equals(oldValue, newValue);
        if (valueIsChanged) {
            if (oldValue != null) {
                this.setTransferHandler((InputStreamDesc[])oldValue, null);
            }
            if (newValue == null) {
                return;
            }
            boolean skippedForTransferHandler = false;
            for (Object inputStreamDesc : newValue) {
                SourceStream inputStream = ((InputStreamDesc)inputStreamDesc).getInputStream();
                if (!(inputStream instanceof PushBufferStream)) continue;
                if (!skippedForTransferHandler) {
                    skippedForTransferHandler = true;
                    continue;
                }
                if (inputStream instanceof CachingPushBufferStream) continue;
                CachingPushBufferStream cachingInputStream = new CachingPushBufferStream((PushBufferStream)inputStream);
                ((InputStreamDesc)inputStreamDesc).setInputStream((SourceStream)cachingInputStream);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Created CachingPushBufferStream with hashCode " + cachingInputStream.hashCode() + " for inputStream with hashCode " + inputStream.hashCode());
            }
            this.setTransferHandler((InputStreamDesc[])newValue, this.transferHandler);
            this.equalizeInputStreamBufferLength();
            if (logger.isTraceEnabled()) {
                int oldValueLength;
                int newValueLength = newValue == null ? 0 : newValue.length;
                int difference = newValueLength - (oldValueLength = oldValue == null ? 0 : oldValue.length);
                if (difference > 0) {
                    logger.trace("Added " + difference + " inputStream(s) and the total is " + newValueLength);
                } else if (difference < 0) {
                    logger.trace("Removed " + difference + " inputStream(s) and the total is " + newValueLength);
                }
            }
        }
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        throw new UnsupportedOperationException(AudioMixerPushBufferStream.class.getSimpleName() + ".setTransferHandler(BufferTransferHandler)");
    }

    private void setTransferHandler(InputStreamDesc[] inputStreams, BufferTransferHandler transferHandler) {
        if (inputStreams == null || inputStreams.length <= 0) {
            return;
        }
        boolean transferHandlerIsSet = false;
        for (InputStreamDesc inputStreamDesc : inputStreams) {
            SourceStream inputStream = inputStreamDesc.getInputStream();
            if (!(inputStream instanceof PushBufferStream)) continue;
            PushBufferStream inputPushBufferStream = (PushBufferStream)inputStream;
            Object inputStreamTransferHandler = transferHandler == null ? null : (transferHandlerIsSet ? new BufferTransferHandler(){

                public void transferData(PushBufferStream stream) {
                }
            } : new StreamSubstituteBufferTransferHandler(transferHandler, inputPushBufferStream, this));
            inputPushBufferStream.setTransferHandler(inputStreamTransferHandler);
            transferHandlerIsSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferData(Buffer buffer) {
        AudioMixingPushBufferStream[] outputStreams;
        try {
            this.read(buffer);
        }
        catch (IOException ex) {
            throw new UndeclaredThrowableException(ex);
        }
        InputSampleDesc inputSampleDesc = (InputSampleDesc)buffer.getData();
        int[][] inputSamples = inputSampleDesc.inputSamples;
        int maxInputSampleCount = buffer.getLength();
        if (inputSamples == null || inputSamples.length == 0 || maxInputSampleCount <= 0) {
            return;
        }
        List<AudioMixingPushBufferStream> list = this.outputStreams;
        synchronized (list) {
            outputStreams = this.outputStreams.toArray(new AudioMixingPushBufferStream[this.outputStreams.size()]);
        }
        for (AudioMixingPushBufferStream outputStream : outputStreams) {
            this.setInputSamples(outputStream, inputSampleDesc, maxInputSampleCount);
        }
        for (int i = 0; i < inputSamples.length; ++i) {
            this.deallocateIntArray(inputSamples[i]);
            inputSamples[i] = null;
        }
    }

    private int[] validateIntArraySize(Buffer buffer, int newSize) {
        int[] intArray;
        Object data = buffer.getData();
        if (data instanceof int[]) {
            intArray = (int[])data;
            if (intArray.length < newSize) {
                this.deallocateIntArray(intArray);
                intArray = null;
            }
        } else {
            intArray = null;
        }
        if (intArray == null) {
            intArray = this.allocateIntArray(newSize);
            buffer.setData((Object)intArray);
        }
        return intArray;
    }

    private static class InputSampleDesc {
        private SoftReference<Buffer> buffer;
        public final int[][] inputSamples;
        public final InputStreamDesc[] inputStreams;
        private long timeStamp = -1L;

        public InputSampleDesc(int[][] inputSamples, InputStreamDesc[] inputStreams) {
            this.inputSamples = inputSamples;
            this.inputStreams = inputStreams;
        }

        public Buffer getBuffer(boolean create) {
            Buffer buffer;
            Buffer buffer2 = buffer = this.buffer == null ? null : this.buffer.get();
            if (buffer == null && create) {
                buffer = new Buffer();
                this.setBuffer(buffer);
            }
            return buffer;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setBuffer(Buffer buffer) {
            this.buffer = buffer == null ? null : new SoftReference<Buffer>(buffer);
        }

        public void setTimeStamp(long timeStamp) {
            if (this.timeStamp != -1L) {
                throw new IllegalStateException("timeStamp");
            }
            this.timeStamp = timeStamp;
        }
    }
}

