/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import javax.media.CaptureDeviceInfo;
import javax.media.Controls;
import javax.media.Time;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixerPushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferStream;
import org.jitsi.impl.neomedia.control.AbstractControls;
import org.jitsi.impl.neomedia.protocol.InbandDTMFDataSource;
import org.jitsi.impl.neomedia.protocol.MuteDataSource;
import org.jitsi.service.neomedia.DTMFInbandTone;
import org.jitsi.util.Logger;

public class AudioMixingPushBufferDataSource
extends PushBufferDataSource
implements CaptureDevice,
MuteDataSource,
InbandDTMFDataSource {
    private static final Logger logger = Logger.getLogger(AudioMixingPushBufferDataSource.class);
    private final AudioMixer audioMixer;
    private boolean connected;
    private AudioMixingPushBufferStream outputStream;
    private boolean started;
    private boolean mute = false;
    private LinkedList<DTMFInbandTone> tones = new LinkedList();

    public AudioMixingPushBufferDataSource(AudioMixer audioMixer) {
        this.audioMixer = audioMixer;
    }

    public void addInputDataSource(DataSource inputDataSource) {
        this.audioMixer.addInputDataSource(inputDataSource, this);
    }

    public void updateInputDataSource(DataSource inputDataSource) {
        this.audioMixer.getOutputStream();
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            this.audioMixer.connect();
            this.connected = true;
        }
    }

    public synchronized void disconnect() {
        try {
            this.stop();
        }
        catch (IOException ioex) {
            throw new UndeclaredThrowableException(ioex);
        }
        if (this.connected) {
            this.outputStream = null;
            this.connected = false;
            this.audioMixer.disconnect();
        }
    }

    private BufferControl getBufferControl() {
        return this.audioMixer.getBufferControl();
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return this.audioMixer.getCaptureDeviceInfo();
    }

    public String getContentType() {
        return this.audioMixer.getContentType();
    }

    public Object getControl(String controlType) {
        return AbstractControls.getControl((Controls)this, controlType);
    }

    public Object[] getControls() {
        BufferControl bufferControl = this.getBufferControl();
        Object[] formatControls = this.getFormatControls();
        if (bufferControl == null) {
            return formatControls;
        }
        if (formatControls == null || formatControls.length < 1) {
            return new Object[]{bufferControl};
        }
        Object[] controls = new Object[1 + formatControls.length];
        controls[0] = bufferControl;
        System.arraycopy(formatControls, 0, controls, 1, formatControls.length);
        return controls;
    }

    public Time getDuration() {
        return this.audioMixer.getDuration();
    }

    public FormatControl[] getFormatControls() {
        return this.audioMixer.getFormatControls();
    }

    public synchronized PushBufferStream[] getStreams() {
        PushBufferStream[] pushBufferStreamArray;
        AudioMixerPushBufferStream audioMixerOutputStream;
        if (this.connected && this.outputStream == null && (audioMixerOutputStream = this.audioMixer.getOutputStream()) != null) {
            this.outputStream = new AudioMixingPushBufferStream(audioMixerOutputStream, this);
            if (this.started) {
                try {
                    this.outputStream.start();
                }
                catch (IOException ioex) {
                    logger.error("Failed to start " + this.outputStream.getClass().getSimpleName() + " with hashCode " + this.outputStream.hashCode(), ioex);
                }
            }
        }
        if (this.outputStream == null) {
            pushBufferStreamArray = new PushBufferStream[]{};
        } else {
            PushBufferStream[] pushBufferStreamArray2 = new PushBufferStream[1];
            pushBufferStreamArray = pushBufferStreamArray2;
            pushBufferStreamArray2[0] = this.outputStream;
        }
        return pushBufferStreamArray;
    }

    public synchronized void start() throws IOException {
        if (!this.started) {
            this.started = true;
            if (this.outputStream != null) {
                this.outputStream.start();
            }
        }
    }

    public synchronized void stop() throws IOException {
        if (this.started) {
            this.started = false;
            if (this.outputStream != null) {
                this.outputStream.stop();
            }
        }
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean mute) {
        if (this.mute != mute) {
            this.mute = mute;
        }
    }

    public void addDTMF(DTMFInbandTone tone) {
        this.tones.add(tone);
    }

    public boolean isSendingDTMF() {
        return !this.tones.isEmpty();
    }

    public int[] getNextToneSignal(double samplingFrequency, int sampleSizeInBits) {
        DTMFInbandTone tone = this.tones.poll();
        return tone.getAudioSamples(samplingFrequency, sampleSizeInBits);
    }
}

