/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.ArrayIOUtils;
import org.jitsi.impl.neomedia.conference.AudioMixerPushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.util.Logger;

public class AudioMixingPushBufferStream
extends ControlsAdapter
implements PushBufferStream {
    private static final Logger logger = Logger.getLogger(AudioMixingPushBufferStream.class);
    private final AudioMixerPushBufferStream audioMixerStream;
    private final AudioMixingPushBufferDataSource dataSource;
    private int[][] inputSamples;
    private int maxInputSampleCount;
    private final Object readSyncRoot = new Object();
    private long timeStamp;
    private BufferTransferHandler transferHandler;

    AudioMixingPushBufferStream(AudioMixerPushBufferStream audioMixerStream, AudioMixingPushBufferDataSource dataSource) {
        this.audioMixerStream = audioMixerStream;
        this.dataSource = dataSource;
    }

    public boolean endOfStream() {
        return this.audioMixerStream.endOfStream();
    }

    public ContentDescriptor getContentDescriptor() {
        return this.audioMixerStream.getContentDescriptor();
    }

    public long getContentLength() {
        return this.audioMixerStream.getContentLength();
    }

    public AudioMixingPushBufferDataSource getDataSource() {
        return this.dataSource;
    }

    public AudioFormat getFormat() {
        return this.audioMixerStream.getFormat();
    }

    private static int getMaxOutputSample(AudioFormat outputFormat) throws UnsupportedFormatException {
        switch (outputFormat.getSampleSizeInBits()) {
            case 8: {
                return 127;
            }
            case 16: {
                return Short.MAX_VALUE;
            }
            case 32: {
                return Integer.MAX_VALUE;
            }
        }
        throw new UnsupportedFormatException("Format.getSampleSizeInBits()", (Format)outputFormat);
    }

    private static int[] mix(int[][] inputSamples, AudioFormat outputFormat, int outputSampleCount) {
        int maxOutputSample;
        int[] outputSamples = new int[outputSampleCount];
        if (inputSamples.length == 1) {
            int[] inputStreamSamples = inputSamples[0];
            if (inputStreamSamples != null) {
                System.arraycopy(inputStreamSamples, 0, outputSamples, 0, inputStreamSamples.length);
            }
            return outputSamples;
        }
        try {
            maxOutputSample = AudioMixingPushBufferStream.getMaxOutputSample(outputFormat);
        }
        catch (UnsupportedFormatException ufex) {
            throw new UnsupportedOperationException(ufex);
        }
        for (int[] inputStreamSamples : inputSamples) {
            int inputStreamSampleCount;
            if (inputStreamSamples == null || (inputStreamSampleCount = inputStreamSamples.length) <= 0) continue;
            for (int i = 0; i < inputStreamSampleCount; ++i) {
                int inputStreamSample = inputStreamSamples[i];
                int outputSample = outputSamples[i];
                outputSamples[i] = inputStreamSample + outputSample - Math.round((float)inputStreamSample * ((float)outputSample / (float)maxOutputSample));
            }
        }
        return outputSamples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        byte[] outputData;
        int inputSampleCount;
        long timeStamp;
        int maxInputSampleCount;
        int[][] inputSamples;
        Object object = this.readSyncRoot;
        synchronized (object) {
            inputSamples = this.inputSamples;
            maxInputSampleCount = this.maxInputSampleCount;
            timeStamp = this.timeStamp;
            this.inputSamples = null;
            this.maxInputSampleCount = 0;
            this.timeStamp = -1L;
        }
        int n = inputSampleCount = inputSamples == null ? 0 : inputSamples.length;
        if (inputSampleCount == 0 || maxInputSampleCount <= 0) {
            buffer.setLength(0);
            return;
        }
        AudioFormat outputFormat = this.getFormat();
        int[] outputSamples = AudioMixingPushBufferStream.mix(inputSamples, outputFormat, maxInputSampleCount);
        Class outputDataType = outputFormat.getDataType();
        if (Format.byteArray.equals(outputDataType)) {
            outputData = null;
            Object o = buffer.getData();
            if (o instanceof byte[]) {
                outputData = (byte[])o;
            }
            switch (outputFormat.getSampleSizeInBits()) {
                case 16: {
                    if (outputData == null || outputData.length < outputSamples.length * 2) {
                        outputData = new byte[outputSamples.length * 2];
                    }
                    for (int i = 0; i < outputSamples.length; ++i) {
                        ArrayIOUtils.writeInt16(outputSamples[i], outputData, i * 2);
                    }
                    break;
                }
                case 32: {
                    if (outputData == null || outputData.length < outputSamples.length * 4) {
                        outputData = new byte[outputSamples.length * 4];
                    }
                    for (int i = 0; i < outputSamples.length; ++i) {
                        AudioMixingPushBufferStream.writeInt(outputSamples[i], outputData, i * 4);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("AudioMixingPushBufferStream.read(Buffer)");
                }
            }
        } else {
            throw new UnsupportedOperationException("AudioMixingPushBufferStream.read(Buffer)");
        }
        buffer.setData((Object)outputData);
        buffer.setFormat((Format)outputFormat);
        buffer.setLength(outputData.length);
        buffer.setOffset(0);
        buffer.setTimeStamp(timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputSamples(int[][] inputSamples, int maxInputSampleCount, long timeStamp) {
        Object object = this.readSyncRoot;
        synchronized (object) {
            this.inputSamples = inputSamples;
            this.maxInputSampleCount = maxInputSampleCount;
        }
        BufferTransferHandler transferHandler = this.transferHandler;
        if (transferHandler != null) {
            transferHandler.transferData((PushBufferStream)this);
        }
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandler = transferHandler;
    }

    synchronized void start() throws IOException {
        this.audioMixerStream.addOutputStream(this);
        if (logger.isTraceEnabled()) {
            logger.trace("Started " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode());
        }
    }

    synchronized void stop() throws IOException {
        this.audioMixerStream.removeOutputStream(this);
        if (logger.isTraceEnabled()) {
            logger.trace("Stopped " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode());
        }
    }

    private static void writeInt(int input, byte[] output, int outputOffset) {
        output[outputOffset] = (byte)(input & 0xFF);
        output[outputOffset + 1] = (byte)(input >>> 8 & 0xFF);
        output[outputOffset + 2] = (byte)(input >>> 16 & 0xFF);
        output[outputOffset + 3] = (byte)(input >> 24);
    }
}

