/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio;

import java.awt.Component;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.AbstractVolumeControl;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.control.DiagnosticsControl;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.device.PortAudioSystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio.DataSource;
import org.jitsi.impl.neomedia.portaudio.Pa;
import org.jitsi.impl.neomedia.portaudio.PortAudioException;
import org.jitsi.util.Logger;

public class PortAudioStream
extends AbstractPullBufferStream {
    private static final Logger logger = Logger.getLogger(PortAudioStream.class);
    private static final long NEVER = 0L;
    private final boolean audioQualityImprovement;
    private int bytesPerBuffer;
    private String deviceID;
    private final DiagnosticsControl diagnosticsControl = new DiagnosticsControl(){

        public Component getControlComponent() {
            return null;
        }

        public long getMalfunctioningSince() {
            return PortAudioStream.this.readIsMalfunctioningSince;
        }

        public String toString() {
            long info;
            int index;
            String id = PortAudioStream.this.deviceID;
            String name = null;
            if (PortAudioStream.this.deviceID != null && (index = Pa.getDeviceIndex(id, 1, 0)) != -1 && (info = Pa.GetDeviceInfo(index)) != 0L) {
                name = Pa.DeviceInfo_getName(info);
            }
            return name;
        }
    };
    private AudioFormat format;
    private int framesPerBuffer;
    private final GainControl gainControl;
    private long inputParameters = 0L;
    private final PortAudioSystem.PaUpdateAvailableDeviceListListener paUpdateAvailableDeviceListListener = new PortAudioSystem.PaUpdateAvailableDeviceListListener(){
        private String deviceID = null;
        private boolean start = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void didPaUpdateAvailableDeviceList() throws Exception {
            PortAudioStream portAudioStream = PortAudioStream.this;
            synchronized (portAudioStream) {
                try {
                    PortAudioStream.this.waitWhileStreamIsBusy();
                    if (PortAudioStream.this.stream == 0L) {
                        PortAudioStream.this.setDeviceID(this.deviceID);
                        if (this.start) {
                            PortAudioStream.this.start();
                        }
                    }
                    Object var3_2 = null;
                    this.deviceID = null;
                    this.start = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.deviceID = null;
                    this.start = false;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void willPaUpdateAvailableDeviceList() throws Exception {
            PortAudioStream portAudioStream = PortAudioStream.this;
            synchronized (portAudioStream) {
                PortAudioStream.this.waitWhileStreamIsBusy();
                if (PortAudioStream.this.stream == 0L) {
                    this.deviceID = null;
                    this.start = false;
                } else {
                    this.deviceID = PortAudioStream.this.deviceID;
                    this.start = PortAudioStream.this.started;
                    boolean disconnected = false;
                    try {
                        PortAudioStream.this.setDeviceID(null);
                        disconnected = true;
                        Object var4_3 = null;
                        if (!disconnected) {
                            this.deviceID = null;
                            this.start = false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (!disconnected) {
                            this.deviceID = null;
                            this.start = false;
                        }
                        throw throwable;
                    }
                }
            }
        }
    };
    private long readIsMalfunctioningSince = 0L;
    private int sequenceNumber = 0;
    private boolean started = false;
    private long stream = 0L;
    private boolean streamIsBusy = false;

    public PortAudioStream(DataSource dataSource, FormatControl formatControl, boolean audioQualityImprovement) {
        super(dataSource, formatControl);
        this.audioQualityImprovement = audioQualityImprovement;
        MediaServiceImpl mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl();
        this.gainControl = mediaServiceImpl == null ? null : (GainControl)mediaServiceImpl.getInputVolumeControl();
        PortAudioSystem.addPaUpdateAvailableDeviceListListener(this.paUpdateAvailableDeviceListListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect() throws IOException {
        DeviceConfiguration devCfg;
        int framesPerBuffer;
        double sampleRate;
        long sampleFormat;
        int sampleSizeInBits;
        int channels;
        block10: {
            int deviceIndex = Pa.getDeviceIndex(this.deviceID, 1, 0);
            if (deviceIndex == -1) {
                throw new IOException("The audio device " + this.deviceID + " appears to be disconnected.");
            }
            AudioFormat format = (AudioFormat)this.getFormat();
            channels = format.getChannels();
            if (channels == -1) {
                channels = 1;
            }
            sampleSizeInBits = format.getSampleSizeInBits();
            sampleFormat = Pa.getPaSampleFormat(sampleSizeInBits);
            sampleRate = format.getSampleRate();
            framesPerBuffer = (int)(sampleRate * 20.0 / (double)(channels * 1000));
            try {
                try {
                    this.inputParameters = Pa.StreamParameters_new(deviceIndex, channels, sampleFormat, Pa.getSuggestedLatency());
                    this.stream = Pa.OpenStream(this.inputParameters, 0L, sampleRate, framesPerBuffer, 3L, null);
                }
                catch (PortAudioException paex) {
                    logger.error("Failed to open " + this.getClass().getSimpleName(), paex);
                    IOException ioex = new IOException(paex.getLocalizedMessage());
                    ioex.initCause(paex);
                    throw ioex;
                }
                Object var13_8 = null;
                if (this.stream != 0L || this.inputParameters == 0L) break block10;
            }
            catch (Throwable throwable) {
                Object var13_9 = null;
                if (this.stream == 0L && this.inputParameters != 0L) {
                    Pa.StreamParameters_free(this.inputParameters);
                    this.inputParameters = 0L;
                }
                throw throwable;
            }
            Pa.StreamParameters_free(this.inputParameters);
            this.inputParameters = 0L;
        }
        if (this.stream == 0L) {
            throw new IOException("Pa_OpenStream");
        }
        this.framesPerBuffer = framesPerBuffer;
        this.bytesPerBuffer = Pa.GetSampleSize(sampleFormat) * channels * framesPerBuffer;
        this.format = new AudioFormat("LINEAR", sampleRate, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray);
        MediaServiceImpl mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl();
        boolean denoise = true;
        boolean echoCancel = true;
        long echoCancelFilterLengthInMillis = 100L;
        if (mediaServiceImpl != null && (devCfg = mediaServiceImpl.getDeviceConfiguration()) != null) {
            denoise = devCfg.isDenoise();
            echoCancel = devCfg.isEchoCancel();
            echoCancelFilterLengthInMillis = devCfg.getEchoCancelFilterLengthInMillis();
        }
        Pa.setDenoise(this.stream, this.audioQualityImprovement && denoise);
        Pa.setEchoFilterLengthInMillis(this.stream, this.audioQualityImprovement && echoCancel ? echoCancelFilterLengthInMillis : 0L);
        if (this.readIsMalfunctioningSince != 0L) {
            this.setReadIsMalfunctioning(false);
        }
    }

    protected Format doGetFormat() {
        return this.format == null ? super.doGetFormat() : this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        PortAudioStream portAudioStream;
        boolean yield2;
        String message;
        PortAudioStream portAudioStream2 = this;
        synchronized (portAudioStream2) {
            if (this.stream == 0L) {
                message = this.getClass().getName() + " is disconnected.";
            } else if (!this.started) {
                message = this.getClass().getName() + " is stopped.";
            } else {
                message = null;
                this.streamIsBusy = true;
            }
            if (message != null && this.readIsMalfunctioningSince != 0L) {
                this.setReadIsMalfunctioning(false);
            }
        }
        if (message != null) {
            PortAudioStream.yield();
            throw new IOException(message);
        }
        long errorCode = 0L;
        Pa.HostApiTypeId hostApiType = null;
        try {
            byte[] data = AbstractCodec2.validateByteArraySize(buffer, this.bytesPerBuffer, false);
            try {
                Pa.ReadStream(this.stream, data, this.framesPerBuffer);
            }
            catch (PortAudioException pae) {
                errorCode = pae.getErrorCode();
                hostApiType = pae.getHostApiType();
                logger.error("Failed to read from PortAudio stream.", pae);
                IOException ioe = new IOException(pae.getLocalizedMessage());
                ioe.initCause(pae);
                throw ioe;
            }
            if (this.gainControl != null) {
                AbstractVolumeControl.applyGain(this.gainControl, data, 0, this.bytesPerBuffer);
            }
            long bufferTimeStamp = System.nanoTime();
            buffer.setFlags(128);
            if (this.format != null) {
                buffer.setFormat((Format)this.format);
            }
            buffer.setHeader(null);
            buffer.setLength(this.bytesPerBuffer);
            buffer.setOffset(0);
            buffer.setSequenceNumber((long)this.sequenceNumber++);
            buffer.setTimeStamp(bufferTimeStamp);
            Object var10_11 = null;
            yield2 = false;
            portAudioStream = this;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            boolean yield2 = false;
            PortAudioStream portAudioStream3 = this;
            synchronized (portAudioStream3) {
                this.streamIsBusy = false;
                this.notifyAll();
                if (errorCode == 0L) {
                    if (this.readIsMalfunctioningSince != 0L) {
                        this.setReadIsMalfunctioning(false);
                    }
                } else if (-9987L == errorCode || Pa.HostApiTypeId.paMME.equals((Object)hostApiType) && 6L == errorCode) {
                    if (this.readIsMalfunctioningSince == 0L) {
                        this.setReadIsMalfunctioning(true);
                    }
                    yield2 = true;
                }
            }
            if (yield2) {
                PortAudioStream.yield();
            }
            throw throwable;
        }
        synchronized (portAudioStream) {
            this.streamIsBusy = false;
            this.notifyAll();
            if (errorCode == 0L) {
                if (this.readIsMalfunctioningSince != 0L) {
                    this.setReadIsMalfunctioning(false);
                }
            } else if (-9987L == errorCode || Pa.HostApiTypeId.paMME.equals((Object)hostApiType) && 6L == errorCode) {
                if (this.readIsMalfunctioningSince == 0L) {
                    this.setReadIsMalfunctioning(true);
                }
                yield2 = true;
            }
        }
        if (yield2) {
            PortAudioStream.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void setDeviceID(String deviceID) throws IOException {
        block17: {
            if (this.deviceID != null) {
                this.waitWhileStreamIsBusy();
                if (this.stream != 0L) {
                    block18: {
                        if (this.started) {
                            try {
                                this.stop();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        boolean closed = false;
                        try {
                            try {
                                Pa.CloseStream(this.stream);
                                closed = true;
                            }
                            catch (PortAudioException pae) {
                                long errorCode = pae.getErrorCode();
                                if (errorCode == -9987L || Pa.HostApiTypeId.paMME.equals((Object)pae.getHostApiType()) && errorCode == 6L) {
                                    closed = true;
                                }
                                if (!closed) {
                                    logger.error("Failed to close " + this.getClass().getSimpleName(), pae);
                                    IOException ioe = new IOException(pae.getLocalizedMessage());
                                    ioe.initCause(pae);
                                    throw ioe;
                                }
                                Object var8_5 = null;
                                if (!closed) break block17;
                                this.stream = 0L;
                                if (this.inputParameters != 0L) {
                                    Pa.StreamParameters_free(this.inputParameters);
                                    this.inputParameters = 0L;
                                }
                                this.format = null;
                                if (this.readIsMalfunctioningSince != 0L) {
                                    this.setReadIsMalfunctioning(false);
                                }
                                break block17;
                            }
                            Object var8_4 = null;
                            if (!closed) break block17;
                            this.stream = 0L;
                            if (this.inputParameters == 0L) break block18;
                        }
                        catch (Throwable throwable) {
                            Object var8_6 = null;
                            if (!closed) throw throwable;
                            this.stream = 0L;
                            if (this.inputParameters != 0L) {
                                Pa.StreamParameters_free(this.inputParameters);
                                this.inputParameters = 0L;
                            }
                            this.format = null;
                            if (this.readIsMalfunctioningSince == 0L) throw throwable;
                            this.setReadIsMalfunctioning(false);
                            throw throwable;
                        }
                        Pa.StreamParameters_free(this.inputParameters);
                        this.inputParameters = 0L;
                    }
                    this.format = null;
                    if (this.readIsMalfunctioningSince != 0L) {
                        this.setReadIsMalfunctioning(false);
                    }
                }
            }
        }
        this.deviceID = deviceID;
        this.started = false;
        if (this.deviceID == null) return;
        PortAudioSystem.willPaOpenStream();
        try {
            this.connect();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            PortAudioSystem.didPaOpenStream();
            throw throwable;
        }
        PortAudioSystem.didPaOpenStream();
    }

    private void setReadIsMalfunctioning(boolean malfunctioning) {
        if (malfunctioning) {
            if (this.readIsMalfunctioningSince == 0L) {
                this.readIsMalfunctioningSince = System.currentTimeMillis();
                PortAudioSystem.monitorFunctionalHealth(this.diagnosticsControl);
            }
        } else {
            this.readIsMalfunctioningSince = 0L;
        }
    }

    public synchronized void start() throws IOException {
        if (this.stream != 0L) {
            this.waitWhileStreamIsBusy();
            try {
                Pa.StartStream(this.stream);
                this.started = true;
            }
            catch (PortAudioException paex) {
                logger.error("Failed to start " + this.getClass().getSimpleName(), paex);
                IOException ioex = new IOException(paex.getLocalizedMessage());
                ioex.initCause(paex);
                throw ioex;
            }
        }
    }

    public synchronized void stop() throws IOException {
        if (this.stream != 0L) {
            this.waitWhileStreamIsBusy();
            try {
                Pa.StopStream(this.stream);
                this.started = false;
                if (this.readIsMalfunctioningSince != 0L) {
                    this.setReadIsMalfunctioning(false);
                }
            }
            catch (PortAudioException paex) {
                logger.error("Failed to stop " + this.getClass().getSimpleName(), paex);
                IOException ioex = new IOException(paex.getLocalizedMessage());
                ioex.initCause(paex);
                throw ioex;
            }
        }
    }

    private void waitWhileStreamIsBusy() {
        boolean interrupted = false;
        while (this.stream != 0L && this.streamIsBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException iex) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static void yield() {
        boolean interrupted = false;
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

