/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi;

import java.util.ArrayList;
import java.util.Collection;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.IMMNotificationClient;
import org.jitsi.util.Logger;

public class MMNotificationClient {
    private static final Logger logger = Logger.getLogger(MMNotificationClient.class);
    private static Collection<IMMNotificationClient> pNotifySet;

    public static void OnDefaultDeviceChanged(int flow, int role, String pwstrDefaultDevice) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OnDeviceAdded(String pwstrDeviceId) {
        Class<MMNotificationClient> clazz = MMNotificationClient.class;
        synchronized (MMNotificationClient.class) {
            Collection<IMMNotificationClient> pNotifySet = MMNotificationClient.pNotifySet;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (pNotifySet != null) {
                for (IMMNotificationClient pNotify : pNotifySet) {
                    try {
                        pNotify.OnDeviceAdded(pwstrDeviceId);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error("An IMMNotificationClient failed to normally complete the handling of an OnDeviceAdded notification.", t);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OnDeviceRemoved(String pwstrDeviceId) {
        Class<MMNotificationClient> clazz = MMNotificationClient.class;
        synchronized (MMNotificationClient.class) {
            Collection<IMMNotificationClient> pNotifySet = MMNotificationClient.pNotifySet;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (pNotifySet != null) {
                for (IMMNotificationClient pNotify : pNotifySet) {
                    try {
                        pNotify.OnDeviceRemoved(pwstrDeviceId);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error("An IMMNotificationClient failed to normally complete the handling of an OnDeviceRemoved notification.", t);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OnDeviceStateChanged(String pwstrDeviceId, int dwNewState) {
        Class<MMNotificationClient> clazz = MMNotificationClient.class;
        synchronized (MMNotificationClient.class) {
            Collection<IMMNotificationClient> pNotifySet = MMNotificationClient.pNotifySet;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (pNotifySet != null) {
                for (IMMNotificationClient pNotify : pNotifySet) {
                    try {
                        pNotify.OnDeviceStateChanged(pwstrDeviceId, dwNewState);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error("An IMMNotificationClient failed to normally complete the handling of an OnDeviceStateChanged notification.", t);
                    }
                }
            }
            return;
        }
    }

    public static void OnPropertyValueChanged(String pwstrDeviceId, long key) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RegisterEndpointNotificationCallback(IMMNotificationClient pNotify) {
        if (pNotify == null) {
            throw new NullPointerException("pNotify");
        }
        Class<MMNotificationClient> clazz = MMNotificationClient.class;
        synchronized (MMNotificationClient.class) {
            ArrayList<IMMNotificationClient> newPNotifySet;
            if (pNotifySet == null) {
                newPNotifySet = new ArrayList<IMMNotificationClient>();
            } else {
                if (pNotifySet.contains(pNotify)) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                newPNotifySet = new ArrayList(pNotifySet.size() + 1);
                newPNotifySet.addAll(pNotifySet);
            }
            if (newPNotifySet.add(pNotify)) {
                pNotifySet = newPNotifySet;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UnregisterEndpointNotificationCallback(IMMNotificationClient pNotify) {
        if (pNotify == null) {
            throw new NullPointerException("pNotify");
        }
        Class<MMNotificationClient> clazz = MMNotificationClient.class;
        synchronized (MMNotificationClient.class) {
            if (pNotifySet != null && pNotifySet.contains(pNotify)) {
                if (pNotifySet.size() == 1) {
                    pNotifySet = null;
                } else {
                    ArrayList<IMMNotificationClient> newPNotifySet = new ArrayList<IMMNotificationClient>(pNotifySet);
                    if (newPNotifySet.remove(pNotify)) {
                        pNotifySet = newPNotifySet;
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private MMNotificationClient() {
    }
}

