/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.io.IOException;
import java.util.LinkedList;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import org.jitsi.impl.neomedia.protocol.InbandDTMFDataSource;
import org.jitsi.impl.neomedia.protocol.MuteDataSource;
import org.jitsi.impl.neomedia.protocol.PullBufferDataSourceDelegate;
import org.jitsi.impl.neomedia.protocol.RewritablePushBufferDataSource;
import org.jitsi.impl.neomedia.protocol.SourceStreamDelegate;
import org.jitsi.service.neomedia.DTMFInbandTone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewritablePullBufferDataSource
extends PullBufferDataSourceDelegate<PullBufferDataSource>
implements MuteDataSource,
InbandDTMFDataSource {
    private boolean mute;
    private LinkedList<DTMFInbandTone> tones = new LinkedList();

    public RewritablePullBufferDataSource(PullBufferDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public boolean isMute() {
        return this.mute;
    }

    @Override
    public void addDTMF(DTMFInbandTone tone) {
        this.tones.add(tone);
    }

    public boolean isSendingDTMF() {
        return !this.tones.isEmpty();
    }

    public PullBufferDataSource getWrappedDataSource() {
        return (PullBufferDataSource)this.dataSource;
    }

    @Override
    public PullBufferStream[] getStreams() {
        PullBufferStream[] streams = ((PullBufferDataSource)this.dataSource).getStreams();
        if (streams != null) {
            for (int streamIndex = 0; streamIndex < streams.length; ++streamIndex) {
                streams[streamIndex] = new MutePullBufferStream(streams[streamIndex]);
            }
        }
        return streams;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MutePullBufferStream
    extends SourceStreamDelegate<PullBufferStream>
    implements PullBufferStream {
        private MutePullBufferStream(PullBufferStream stream) {
            super(stream);
        }

        public Format getFormat() {
            return ((PullBufferStream)this.stream).getFormat();
        }

        public void read(Buffer buffer) throws IOException {
            ((PullBufferStream)this.stream).read(buffer);
            if (RewritablePullBufferDataSource.this.isSendingDTMF()) {
                RewritablePushBufferDataSource.sendDTMF(buffer, (DTMFInbandTone)RewritablePullBufferDataSource.this.tones.poll());
            } else if (RewritablePullBufferDataSource.this.isMute()) {
                RewritablePushBufferDataSource.mute(buffer);
            }
        }

        public boolean willReadBlock() {
            return ((PullBufferStream)this.stream).willReadBlock();
        }
    }
}

