/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtmf;

import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.util.Logger;

public class DtmfRawPacket
extends RawPacket {
    private static final Logger logger = Logger.getLogger(DtmfRawPacket.class);
    private int code;
    private boolean end;
    private int duration;

    public DtmfRawPacket(byte[] buffer, int offset, int length, byte payload) {
        super(buffer, offset, length);
        this.setPayload(payload);
    }

    public DtmfRawPacket(RawPacket pkt) {
        super(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
        int at = this.getHeaderLength();
        this.code = this.readByte(at++);
        this.end = (this.readByte(at++) & 0x80) != 0;
        this.duration = (this.readByte(at++) & 0xFF) << 8 | this.readByte(at++) & 0xFF;
    }

    public void init(int code, boolean end, boolean marker, int duration, long timestamp) {
        if (logger.isTraceEnabled()) {
            logger.trace("DTMF send on RTP, code : " + code + " duration = " + duration + " timestamps = " + timestamp + " Marker = " + marker + " End = " + end);
        }
        this.setMarker(marker);
        this.setTimestamp(timestamp);
        this.setDtmfPayload(code, end, duration);
    }

    private void setDtmfPayload(int code, boolean end, int duration) {
        this.code = code;
        this.end = end;
        this.duration = duration;
        int at = this.getHeaderLength();
        this.writeByte(at++, (byte)code);
        this.writeByte(at++, end ? (byte)-128 : 0);
        this.writeByte(at++, (byte)(duration >> 8));
        this.writeByte(at++, (byte)duration);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isEnd() {
        return this.end;
    }

    public int getDuration() {
        return this.duration;
    }
}

