/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.sdes;

import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import ch.imvs.sdes4j.srtp.SrtpSDesFactory;
import gnu.java.zrtp.utils.ZrtpFortuna;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.sdes.SDesTransformEngine;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SDesControl;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.event.SrtpListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDesControlImpl
implements SDesControl {
    private List<String> enabledCryptoSuites = new ArrayList<String>(3){
        private static final long serialVersionUID = 0L;
        {
            this.add("AES_CM_128_HMAC_SHA1_80");
            this.add("AES_CM_128_HMAC_SHA1_32");
            this.add("F8_128_HMAC_SHA1_80");
        }
    };
    private final List<String> supportedCryptoSuites = new ArrayList<String>(3){
        private static final long serialVersionUID = 0L;
        {
            this.add("AES_CM_128_HMAC_SHA1_80");
            this.add("AES_CM_128_HMAC_SHA1_32");
            this.add("F8_128_HMAC_SHA1_80");
        }
    };
    private SrtpSDesFactory sdesFactory = new SrtpSDesFactory();
    private SrtpCryptoAttribute[] attributes;
    private SDesTransformEngine engine;
    private SrtpCryptoAttribute selectedInAttribute;
    private SrtpCryptoAttribute selectedOutAttribute;
    private SrtpListener srtpListener;

    public SDesControlImpl() {
        Random r = new Random(){
            private static final long serialVersionUID = 0L;

            public void nextBytes(byte[] bytes) {
                ZrtpFortuna.getInstance().getFortuna().nextBytes(bytes);
            }
        };
        this.sdesFactory.setRandomGenerator(r);
    }

    @Override
    public void setEnabledCiphers(Iterable<String> ciphers) {
        this.enabledCryptoSuites.clear();
        for (String c : ciphers) {
            this.enabledCryptoSuites.add(c);
        }
    }

    @Override
    public Iterable<String> getSupportedCryptoSuites() {
        return Collections.unmodifiableList(this.supportedCryptoSuites);
    }

    @Override
    public void cleanup() {
        if (this.engine != null) {
            this.engine.close();
            this.engine = null;
        }
    }

    @Override
    public void setSrtpListener(SrtpListener srtpListener) {
        this.srtpListener = srtpListener;
    }

    @Override
    public SrtpListener getSrtpListener() {
        return this.srtpListener;
    }

    @Override
    public boolean getSecureCommunicationStatus() {
        return this.engine != null;
    }

    @Override
    public void setMasterSession(boolean masterSession) {
    }

    @Override
    public void start(MediaType type) {
        this.srtpListener.securityNegotiationStarted(type.equals((Object)MediaType.AUDIO) ? 1 : 2, this);
        this.srtpListener.securityTurnedOn(type.equals((Object)MediaType.AUDIO) ? 1 : 2, this.selectedInAttribute.getCryptoSuite().encode(), this);
    }

    @Override
    public void setMultistream(SrtpControl master) {
    }

    @Override
    public TransformEngine getTransformEngine() {
        if (this.engine == null) {
            this.engine = new SDesTransformEngine(this.selectedInAttribute, this.selectedOutAttribute);
        }
        return this.engine;
    }

    private void initAttributes() {
        if (this.attributes == null) {
            this.attributes = new SrtpCryptoAttribute[this.enabledCryptoSuites.size()];
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i] = this.sdesFactory.createCryptoAttribute(i + 1, this.enabledCryptoSuites.get(i));
            }
        }
    }

    @Override
    public SrtpCryptoAttribute[] getInitiatorCryptoAttributes() {
        this.initAttributes();
        return this.attributes;
    }

    @Override
    public SrtpCryptoAttribute responderSelectAttribute(Iterable<SrtpCryptoAttribute> peerAttributes) {
        for (SrtpCryptoAttribute ea : peerAttributes) {
            for (String suite : this.enabledCryptoSuites) {
                if (!suite.equals(ea.getCryptoSuite().encode())) continue;
                this.selectedInAttribute = ea;
                this.selectedOutAttribute = this.sdesFactory.createCryptoAttribute(1, suite);
                return this.selectedOutAttribute;
            }
        }
        return null;
    }

    @Override
    public SrtpCryptoAttribute initiatorSelectAttribute(Iterable<SrtpCryptoAttribute> peerAttributes) {
        for (SrtpCryptoAttribute peerCA : peerAttributes) {
            for (SrtpCryptoAttribute localCA : this.attributes) {
                if (!localCA.getCryptoSuite().equals((Object)peerCA.getCryptoSuite())) continue;
                this.selectedInAttribute = peerCA;
                this.selectedOutAttribute = localCA;
                return peerCA;
            }
        }
        return null;
    }

    @Override
    public SrtpCryptoAttribute getInAttribute() {
        return this.selectedInAttribute;
    }

    @Override
    public SrtpCryptoAttribute getOutAttribute() {
        return this.selectedOutAttribute;
    }

    @Override
    public void setConnector(AbstractRTPConnector newValue) {
    }

    @Override
    public boolean requiresSecureSignalingTransport() {
        return true;
    }
}

