/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPCryptoContext;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;

public class SRTCPTransformer
implements PacketTransformer {
    private final SRTPContextFactory forwardFactory;
    private final SRTPContextFactory reverseFactory;
    private final Hashtable<Long, SRTCPCryptoContext> contexts;

    public SRTCPTransformer(SRTPContextFactory factory) {
        this(factory, factory);
    }

    public SRTCPTransformer(SRTPContextFactory forwardFactory, SRTPContextFactory reverseFactory) {
        this.forwardFactory = forwardFactory;
        this.reverseFactory = reverseFactory;
        this.contexts = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable<Long, SRTCPCryptoContext> hashtable = this.contexts;
        synchronized (hashtable) {
            this.forwardFactory.close();
            if (this.reverseFactory != this.forwardFactory) {
                this.reverseFactory.close();
            }
            Iterator<Map.Entry<Long, SRTCPCryptoContext>> iter = this.contexts.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, SRTCPCryptoContext> entry = iter.next();
                SRTCPCryptoContext context = entry.getValue();
                iter.remove();
                if (context == null) continue;
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRTCPCryptoContext getContext(RawPacket pkt, SRTPContextFactory engine) {
        long ssrc = pkt.getRTCPSSRC();
        SRTCPCryptoContext context = null;
        Hashtable<Long, SRTCPCryptoContext> hashtable = this.contexts;
        synchronized (hashtable) {
            context = this.contexts.get(ssrc);
            if (context == null && engine != null && (context = engine.getDefaultContextControl()) != null) {
                context = context.deriveContext(ssrc);
                context.deriveSrtcpKeys();
                this.contexts.put(ssrc, context);
            }
        }
        return context;
    }

    public RawPacket reverseTransform(RawPacket pkt) {
        SRTCPCryptoContext context = this.getContext(pkt, this.reverseFactory);
        return context != null && context.reverseTransformPacket(pkt) ? pkt : null;
    }

    public RawPacket transform(RawPacket pkt) {
        SRTCPCryptoContext context = this.getContext(pkt, this.forwardFactory);
        if (context != null) {
            context.transformPacket(pkt);
            return pkt;
        }
        return null;
    }
}

