/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCryptoContext;

public class SRTPTransformer
implements PacketTransformer {
    private final SRTPContextFactory forwardFactory;
    private final SRTPContextFactory reverseFactory;
    private final Hashtable<Long, SRTPCryptoContext> contexts;

    public SRTPTransformer(SRTPContextFactory factory) {
        this(factory, factory);
    }

    public SRTPTransformer(SRTPContextFactory forwardFactory, SRTPContextFactory reverseFactory) {
        this.forwardFactory = forwardFactory;
        this.reverseFactory = reverseFactory;
        this.contexts = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable<Long, SRTPCryptoContext> hashtable = this.contexts;
        synchronized (hashtable) {
            this.forwardFactory.close();
            if (this.reverseFactory != this.forwardFactory) {
                this.reverseFactory.close();
            }
            Iterator<Map.Entry<Long, SRTPCryptoContext>> iter = this.contexts.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, SRTPCryptoContext> entry = iter.next();
                SRTPCryptoContext context = entry.getValue();
                iter.remove();
                if (context == null) continue;
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRTPCryptoContext getContext(long ssrc, SRTPContextFactory engine, int deriveSrtpKeysIndex) {
        SRTPCryptoContext context;
        Hashtable<Long, SRTPCryptoContext> hashtable = this.contexts;
        synchronized (hashtable) {
            context = this.contexts.get(ssrc);
            if (context == null && (context = engine.getDefaultContext()) != null) {
                context = context.deriveContext(ssrc, 0, 0L);
                context.deriveSrtpKeys(deriveSrtpKeysIndex);
                this.contexts.put(ssrc, context);
            }
        }
        return context;
    }

    public RawPacket reverseTransform(RawPacket pkt) {
        if ((pkt.readByte(0) & 0xC0) != 128) {
            return null;
        }
        SRTPCryptoContext context = this.getContext(pkt.getSSRC(), this.reverseFactory, pkt.getSequenceNumber());
        return context != null && context.reverseTransformPacket(pkt) ? pkt : null;
    }

    public RawPacket transform(RawPacket pkt) {
        SRTPCryptoContext context = this.getContext(pkt.getSSRC(), this.forwardFactory, 0);
        context.transformPacket(pkt);
        return pkt;
    }
}

