/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import org.jitsi.service.protocol.DTMFTone;

public class DTMFInbandTone {
    private static final double[] frequencyList1 = new double[]{697.0, 770.0, 852.0, 941.0};
    private static final double[] frequencyList2 = new double[]{1209.0, 1336.0, 1477.0, 1633.0};
    public static final DTMFInbandTone DTMF_INBAND_0 = new DTMFInbandTone("0", frequencyList1[3], frequencyList2[1]);
    public static final DTMFInbandTone DTMF_INBAND_1 = new DTMFInbandTone("1", frequencyList1[0], frequencyList2[0]);
    public static final DTMFInbandTone DTMF_INBAND_2 = new DTMFInbandTone("2", frequencyList1[0], frequencyList2[1]);
    public static final DTMFInbandTone DTMF_INBAND_3 = new DTMFInbandTone("3", frequencyList1[0], frequencyList2[2]);
    public static final DTMFInbandTone DTMF_INBAND_4 = new DTMFInbandTone("4", frequencyList1[1], frequencyList2[0]);
    public static final DTMFInbandTone DTMF_INBAND_5 = new DTMFInbandTone("5", frequencyList1[1], frequencyList2[1]);
    public static final DTMFInbandTone DTMF_INBAND_6 = new DTMFInbandTone("6", frequencyList1[1], frequencyList2[2]);
    public static final DTMFInbandTone DTMF_INBAND_7 = new DTMFInbandTone("7", frequencyList1[2], frequencyList2[0]);
    public static final DTMFInbandTone DTMF_INBAND_8 = new DTMFInbandTone("8", frequencyList1[2], frequencyList2[1]);
    public static final DTMFInbandTone DTMF_INBAND_9 = new DTMFInbandTone("9", frequencyList1[2], frequencyList2[2]);
    public static final DTMFInbandTone DTMF_INBAND_STAR = new DTMFInbandTone("*", frequencyList1[3], frequencyList2[0]);
    public static final DTMFInbandTone DTMF_INBAND_SHARP = new DTMFInbandTone("#", frequencyList1[3], frequencyList2[2]);
    public static final DTMFInbandTone DTMF_INBAND_A = new DTMFInbandTone("A", frequencyList1[0], frequencyList2[3]);
    public static final DTMFInbandTone DTMF_INBAND_B = new DTMFInbandTone("B", frequencyList1[1], frequencyList2[3]);
    public static final DTMFInbandTone DTMF_INBAND_C = new DTMFInbandTone("C", frequencyList1[2], frequencyList2[3]);
    public static final DTMFInbandTone DTMF_INBAND_D = new DTMFInbandTone("D", frequencyList1[3], frequencyList2[3]);
    private static final int toneDuration = 150;
    private static final int interDigitInterval = 45;
    private String value;
    private double frequency1;
    private double frequency2;

    public DTMFInbandTone(String value, double frequency1, double frequency2) {
        this.value = value;
        this.frequency1 = frequency1;
        this.frequency2 = frequency2;
    }

    public String getValue() {
        return this.value;
    }

    public double getFrequency1() {
        return this.frequency1;
    }

    public double getFrequency2() {
        return this.frequency2;
    }

    public double getAudioSampleContinuous(double samplingFrequency, int sampleNumber) {
        double u1 = Math.PI * 2 * this.frequency1 / samplingFrequency;
        double u2 = Math.PI * 2 * this.frequency2 / samplingFrequency;
        double audioSample = Math.sin(u1 * (double)sampleNumber) * 0.5 + Math.sin(u2 * (double)sampleNumber) * 0.5;
        return audioSample;
    }

    public int getAudioSampleDiscrete(double samplingFrequency, int sampleNumber, int sampleSizeInBits) {
        double amplitudeCoefficient = Math.pow(2.0, sampleSizeInBits - 1) - 1.0;
        double audioSampleContinuous = this.getAudioSampleContinuous(samplingFrequency, sampleNumber);
        int audioSampleDiscrete = (int)(audioSampleContinuous * amplitudeCoefficient);
        return audioSampleDiscrete;
    }

    public int[] getAudioSamples(double samplingFrequency, int sampleSizeInBits) {
        int sampleNumber;
        int nbToneSamples = (int)(samplingFrequency / 1000.0) * 150;
        int nbInterDigitSamples = (int)(samplingFrequency / 1000.0) * 45;
        int[] sampleData = new int[nbInterDigitSamples + nbToneSamples + nbInterDigitSamples];
        for (sampleNumber = 0; sampleNumber < nbInterDigitSamples; ++sampleNumber) {
            sampleData[sampleNumber] = 0;
        }
        while (sampleNumber < nbInterDigitSamples + nbToneSamples) {
            sampleData[sampleNumber] = this.getAudioSampleDiscrete(samplingFrequency, sampleNumber, sampleSizeInBits);
            ++sampleNumber;
        }
        while (sampleNumber < sampleData.length) {
            sampleData[sampleNumber] = 0;
            ++sampleNumber;
        }
        return sampleData;
    }

    public static DTMFInbandTone mapTone(DTMFTone tone) {
        if (tone.equals(DTMFTone.DTMF_0)) {
            return DTMF_INBAND_0;
        }
        if (tone.equals(DTMFTone.DTMF_1)) {
            return DTMF_INBAND_1;
        }
        if (tone.equals(DTMFTone.DTMF_2)) {
            return DTMF_INBAND_2;
        }
        if (tone.equals(DTMFTone.DTMF_3)) {
            return DTMF_INBAND_3;
        }
        if (tone.equals(DTMFTone.DTMF_4)) {
            return DTMF_INBAND_4;
        }
        if (tone.equals(DTMFTone.DTMF_5)) {
            return DTMF_INBAND_5;
        }
        if (tone.equals(DTMFTone.DTMF_6)) {
            return DTMF_INBAND_6;
        }
        if (tone.equals(DTMFTone.DTMF_7)) {
            return DTMF_INBAND_7;
        }
        if (tone.equals(DTMFTone.DTMF_8)) {
            return DTMF_INBAND_8;
        }
        if (tone.equals(DTMFTone.DTMF_9)) {
            return DTMF_INBAND_9;
        }
        if (tone.equals(DTMFTone.DTMF_A)) {
            return DTMF_INBAND_A;
        }
        if (tone.equals(DTMFTone.DTMF_B)) {
            return DTMF_INBAND_B;
        }
        if (tone.equals(DTMFTone.DTMF_C)) {
            return DTMF_INBAND_C;
        }
        if (tone.equals(DTMFTone.DTMF_D)) {
            return DTMF_INBAND_D;
        }
        if (tone.equals(DTMFTone.DTMF_SHARP)) {
            return DTMF_INBAND_SHARP;
        }
        if (tone.equals(DTMFTone.DTMF_STAR)) {
            return DTMF_INBAND_STAR;
        }
        return null;
    }
}

