/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.jitsi.util.swing.TransparentPanel;
import org.jitsi.util.swing.VideoLayout;

public class VideoContainer
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.BLACK;
    private static final String PREFERRED_SIZE_PROPERTY_NAME = "preferredSize";
    private int inAddOrRemove;
    private final Component noVideoComponent;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            VideoContainer.this.propertyChange(ev);
        }
    };
    private final Object syncRoot = new Object();
    private boolean validateAndRepaint;

    public VideoContainer(Component noVideoComponent, boolean conference) {
        this.setLayout(new VideoLayout(conference));
        this.noVideoComponent = noVideoComponent;
        if (DEFAULT_BACKGROUND_COLOR != null) {
            this.setBackground(DEFAULT_BACKGROUND_COLOR);
        }
        this.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent ev) {
                VideoContainer.this.onContainerEvent(ev);
            }

            public void componentRemoved(ContainerEvent ev) {
                VideoContainer.this.onContainerEvent(ev);
            }
        });
        if (this.noVideoComponent != null) {
            this.add(this.noVideoComponent, "CENTER_REMOTE", -1);
        }
    }

    public Component add(Component comp) {
        this.add(comp, "CENTER_REMOTE");
        return comp;
    }

    public Component add(Component comp, int index) {
        this.add(comp, null, index);
        return comp;
    }

    public void add(Component comp, Object constraints) {
        this.add(comp, constraints, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Component comp, Object constraints, int index) {
        this.enterAddOrRemove();
        try {
            if ("CENTER_REMOTE".equals(constraints) && this.noVideoComponent != null && !this.noVideoComponent.equals(comp) || comp.equals(this.noVideoComponent) && this.noVideoComponent.getParent() != null) {
                this.remove(this.noVideoComponent);
            }
            super.add(comp, constraints, index);
            Object var5_4 = null;
            this.exitAddOrRemove();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.exitAddOrRemove();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterAddOrRemove() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.inAddOrRemove == 0) {
                this.validateAndRepaint = false;
            }
            ++this.inAddOrRemove;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitAddOrRemove() {
        Object object = this.syncRoot;
        synchronized (object) {
            --this.inAddOrRemove;
            if (this.inAddOrRemove < 1) {
                this.inAddOrRemove = 0;
                if (this.validateAndRepaint) {
                    this.validateAndRepaint = false;
                    if (this.isDisplayable()) {
                        if (this.isValid()) {
                            this.doLayout();
                        } else {
                            this.validate();
                        }
                        this.repaint();
                    } else {
                        this.doLayout();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onContainerEvent(ContainerEvent ev) {
        Object object;
        try {
            Component component = ev.getChild();
            switch (ev.getID()) {
                case 300: {
                    component.addPropertyChangeListener(PREFERRED_SIZE_PROPERTY_NAME, this.propertyChangeListener);
                    break;
                }
                case 301: {
                    component.removePropertyChangeListener(PREFERRED_SIZE_PROPERTY_NAME, this.propertyChangeListener);
                }
            }
            if (DEFAULT_BACKGROUND_COLOR != null) {
                int componentCount = this.getComponentCount();
                if (componentCount == 1 && this.getComponent(0) == this.noVideoComponent) {
                    componentCount = 0;
                }
                this.setOpaque(componentCount > 0);
            }
            Object var5_4 = null;
            object = this.syncRoot;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Object object2 = this.syncRoot;
            synchronized (object2) {
                if (this.inAddOrRemove != 0) {
                    this.validateAndRepaint = true;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            if (this.inAddOrRemove != 0) {
                this.validateAndRepaint = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propertyChange(PropertyChangeEvent ev) {
        if (PREFERRED_SIZE_PROPERTY_NAME.equals(ev.getPropertyName()) && SwingUtilities.isEventDispatchThread()) {
            Object object = this.syncRoot;
            synchronized (object) {
                this.enterAddOrRemove();
                this.validateAndRepaint = true;
                this.exitAddOrRemove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component comp) {
        this.enterAddOrRemove();
        try {
            super.remove(comp);
            Component[] components = this.getComponents();
            VideoLayout videoLayout = (VideoLayout)this.getLayout();
            boolean hasComponentsAtCenterRemote = false;
            for (Component c : components) {
                if (c.equals(this.noVideoComponent) || !"CENTER_REMOTE".equals(videoLayout.getComponentConstraints(c))) continue;
                hasComponentsAtCenterRemote = true;
                break;
            }
            if (!hasComponentsAtCenterRemote && this.noVideoComponent != null && !this.noVideoComponent.equals(comp)) {
                this.add(this.noVideoComponent, "CENTER_REMOTE");
            }
            Object var10_9 = null;
            this.exitAddOrRemove();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.exitAddOrRemove();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.enterAddOrRemove();
        try {
            super.removeAll();
            if (this.noVideoComponent != null) {
                this.add(this.noVideoComponent, "CENTER_REMOTE");
            }
            Object var2_1 = null;
            this.exitAddOrRemove();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.exitAddOrRemove();
            throw throwable;
        }
    }
}

