/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jitsi.util.swing.FitLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoLayout
extends FitLayout {
    public static final String CANVAS = "CANVAS";
    public static final String CENTER_REMOTE = "CENTER_REMOTE";
    public static final String CLOSE_LOCAL_BUTTON = "CLOSE_LOCAL_BUTTON";
    public static final String EAST_REMOTE = "EAST_REMOTE";
    private static final int HGAP = 10;
    public static final String LOCAL = "LOCAL";
    private static final float LOCAL_TO_REMOTE_RATIO = 0.3f;
    private Component canvas;
    private Component closeButton;
    private final boolean conference;
    private final Map<Component, Object> constraints = new HashMap<Component, Object>();
    private Component local;
    private float remoteAlignmentX = 0.5f;
    private final List<Component> remotes = new LinkedList<Component>();

    public VideoLayout(boolean conference) {
        this.conference = conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        super.addLayoutComponent(name, comp);
        Map<Component, Object> map = this.constraints;
        synchronized (map) {
            this.constraints.put(comp, name);
        }
        if (name == null || name.equals(CENTER_REMOTE)) {
            if (!this.remotes.contains(comp)) {
                this.remotes.add(comp);
            }
            this.remoteAlignmentX = 0.5f;
        } else if (name.equals(EAST_REMOTE)) {
            if (!this.remotes.contains(comp)) {
                this.remotes.add(comp);
            }
            this.remoteAlignmentX = 1.0f;
        } else if (name.equals(LOCAL)) {
            this.local = comp;
        } else if (name.equals(CLOSE_LOCAL_BUTTON)) {
            this.closeButton = comp;
        } else if (name.equals(CANVAS)) {
            this.canvas = comp;
        }
    }

    public static boolean areAspectRatiosEqual(Dimension size, int width, int height) {
        if (size.height == 0 || height == 0) {
            return false;
        }
        double a = (double)size.width / (double)size.height;
        double b = (double)width / (double)height;
        double diff = a - b;
        return -0.01 < diff && diff < 0.01;
    }

    private int calculateColumnCount(List<Component> remotes) {
        int remoteCount = remotes.size();
        if (remoteCount == 1) {
            return 1;
        }
        if (remoteCount == 2 || remoteCount == 4) {
            return 2;
        }
        return 3;
    }

    @Override
    protected Component getComponent(Container parent) {
        return this.remotes.size() == 1 ? this.remotes.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentConstraints(Component c) {
        Map<Component, Object> map = this.constraints;
        synchronized (map) {
            return this.constraints.get(c);
        }
    }

    public Component getLocal() {
        return this.local;
    }

    public Component getLocalCloseButton() {
        return this.closeButton;
    }

    @Override
    public void layoutContainer(Container parent) {
        List<Object> remotes;
        Component local = this.getLocal();
        if (this.conference || this.remotes.size() > 1 && local != null) {
            remotes = new ArrayList<Component>();
            remotes.addAll(this.remotes);
            if (local != null) {
                remotes.add(local);
            }
        } else {
            remotes = this.remotes;
        }
        int remoteCount = remotes.size();
        Dimension parentSize = parent.getSize();
        if (!this.conference && remoteCount == 1) {
            super.layoutContainer(parent, local == null ? 0.5f : this.remoteAlignmentX);
        } else if (remoteCount > 0) {
            int columns = this.calculateColumnCount(remotes);
            int columnsMinus1 = columns - 1;
            int rows = (remoteCount + columnsMinus1) / columns;
            int rowsMinus1 = rows - 1;
            Rectangle bounds = new Rectangle(0, 0, (parentSize.width - columnsMinus1 * 10) / columns, parentSize.height / rows);
            for (int i = 0; i < remoteCount; ++i) {
                int column = i % columns;
                int row = i / columns;
                if (column == 0) {
                    int available;
                    bounds.x = 0;
                    if (row == rowsMinus1 && (available = remoteCount - i) < columns) {
                        bounds.x = (parentSize.width - available * bounds.width - (available - 1) * 10) / 2;
                    }
                } else {
                    bounds.x += bounds.width + 10;
                }
                bounds.y = row * bounds.height;
                super.layoutComponent((Component)remotes.get(i), bounds, 0.5f, 0.5f);
            }
        }
        if (local == null) {
            if (this.closeButton != null) {
                this.closeButton.setVisible(false);
            }
        } else {
            if (!remotes.contains(local)) {
                float alignmentX;
                int localY;
                int localX;
                Component remote0 = remotes.isEmpty() ? null : (Component)remotes.get(0);
                int height = Math.round((float)parentSize.height * 0.3f);
                int width = Math.round((float)parentSize.width * 0.3f);
                if (remoteCount == 1 && remote0 instanceof JLabel) {
                    localX = (parentSize.width - width) / 2;
                    localY = parentSize.height - height;
                    alignmentX = 0.5f;
                } else {
                    localX = (remote0 == null ? 0 : remote0.getX()) + 5;
                    localY = parentSize.height - height - 5;
                    alignmentX = 0.0f;
                }
                super.layoutComponent(local, new Rectangle(localX, localY, width, height), alignmentX, 1.0f);
            }
            if (this.closeButton != null) {
                this.closeButton.setVisible(local.isVisible());
                super.layoutComponent(this.closeButton, new Rectangle(local.getX() + local.getWidth() - this.closeButton.getWidth(), local.getY(), this.closeButton.getWidth(), this.closeButton.getHeight()), 0.5f, 0.5f);
            }
        }
        if (this.canvas != null) {
            this.canvas.setBounds(0, 0, parentSize.width, parentSize.height);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension prefSize;
        Dimension prefLayoutSize;
        List<Object> remotes;
        Component local = this.getLocal();
        if (this.conference || this.remotes.size() > 1 && local != null) {
            remotes = new ArrayList<Component>();
            remotes.addAll(this.remotes);
            if (local != null) {
                remotes.add(local);
            }
        } else {
            remotes = this.remotes;
        }
        int remoteCount = remotes.size();
        if (!this.conference && remoteCount == 1) {
            prefLayoutSize = super.preferredLayoutSize(parent);
        } else if (remoteCount > 0) {
            void var12_18;
            void var12_16;
            int row;
            int columns = this.calculateColumnCount(remotes);
            int columnsMinus1 = columns - 1;
            int rows = (remoteCount + columnsMinus1) / columns;
            int i = 0;
            Dimension[] prefSizes = new Dimension[columns * rows];
            for (Component component : remotes) {
                int column = columnsMinus1 - i % columns;
                row = i / columns;
                prefSizes[column + row * columns] = component.getPreferredSize();
                if (++i < remoteCount) continue;
                break;
            }
            int prefLayoutWidth = 0;
            boolean bl = false;
            while (var12_16 < columns) {
                int prefColumnWidth = 0;
                for (row = 0; row < rows; ++row) {
                    Dimension prefSize2 = prefSizes[var12_16 + row * columns];
                    if (prefSize2 == null) continue;
                    prefColumnWidth += prefSize2.width;
                }
                prefLayoutWidth += (prefColumnWidth /= rows);
                ++var12_16;
            }
            boolean bl2 = false;
            for (int row2 = 0; row2 < rows; ++row2) {
                int prefRowHeight = 0;
                for (int column = 0; column < columns; ++column) {
                    Dimension prefSize3 = prefSizes[column + row2 * columns];
                    if (prefSize3 == null) continue;
                    prefRowHeight = prefSize3.height;
                }
                var12_18 += (prefRowHeight /= columns);
            }
            prefLayoutSize = new Dimension(prefLayoutWidth + columnsMinus1 * 10, (int)var12_18);
        } else {
            prefLayoutSize = null;
        }
        if (local != null && !remotes.contains(local) && prefLayoutSize == null && (prefSize = local.getPreferredSize()) != null) {
            int prefHeight = Math.round((float)prefSize.height * 0.3f);
            int prefWidth = Math.round((float)prefSize.width * 0.3f);
            prefLayoutSize = new Dimension(prefWidth, prefHeight);
        }
        if (prefLayoutSize == null) {
            prefLayoutSize = super.preferredLayoutSize(parent);
        } else if (prefLayoutSize.height < 1 || prefLayoutSize.width < 1) {
            prefLayoutSize.height = 16;
            prefLayoutSize.width = 16;
        }
        return prefLayoutSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        super.removeLayoutComponent(comp);
        Map<Component, Object> map = this.constraints;
        synchronized (map) {
            this.constraints.remove(comp);
        }
        if (this.local == comp) {
            this.local = null;
        } else if (this.closeButton == comp) {
            this.closeButton = null;
        } else if (this.canvas == comp) {
            this.canvas = null;
        } else {
            this.remotes.remove(comp);
        }
    }
}

