/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.tabbed.TabPagerManager;
import org.jvnet.lafwidget.utils.ShadowPopupBorder;

public class TabPreviewControl
extends JPanel {
    protected JLabel iconLabel;
    protected JLabel titleLabel;
    protected JPanel previewImagePanel;
    protected BufferedImage previewImage;
    protected JTabbedPane tabPane;

    public TabPreviewControl(JTabbedPane tabPane, int tabIndex) {
        this.tabPane = tabPane;
        this.setLayout(new TabPreviewControlLayout());
        this.iconLabel = new JLabel(tabPane.getIconAt(tabIndex));
        this.titleLabel = new JLabel(tabPane.getTitleAt(tabIndex));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.previewImagePanel = new JPanel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                TabPreviewControl.this.paintTabThumbnail(g);
            }
        };
        this.add(this.iconLabel);
        this.add(this.titleLabel);
        this.add(this.previewImagePanel);
        boolean isSelected = tabPane.getSelectedIndex() == tabIndex;
        LineBorder innerBorder = isSelected ? new LineBorder(Color.black, 2) : new LineBorder(Color.black, 1);
        this.setBorder(new CompoundBorder(new ShadowPopupBorder(), innerBorder));
    }

    public synchronized void paintTabThumbnail(Graphics g) {
        if (this.previewImage != null) {
            float fadeFactor;
            int pw = this.previewImage.getWidth();
            int ph = this.previewImage.getHeight();
            int w = this.previewImagePanel.getWidth();
            int h = this.previewImagePanel.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            FadeTracker fadeTracker = FadeTracker.getInstance();
            if (fadeTracker.isTracked(this, FadeKind.ENABLE)) {
                fadeFactor = fadeTracker.getFade(this, FadeKind.ENABLE);
                g2.setComposite(AlphaComposite.getInstance(3, fadeFactor));
            }
            if (fadeTracker.isTracked(this.tabPane, TabPagerManager.HIDE_TAB_PAGER_FADE_KIND)) {
                fadeFactor = fadeTracker.getFade(this.tabPane, TabPagerManager.HIDE_TAB_PAGER_FADE_KIND);
                g2.setComposite(AlphaComposite.getInstance(3, fadeFactor));
            }
            int dx = (w - pw) / 2;
            int dy = (h - ph) / 2;
            g2.drawImage((Image)this.previewImage, dx, dy, null);
            g2.dispose();
        }
    }

    public void setTabIndex(int tabIndex) {
        this.iconLabel.setIcon(this.tabPane.getIconAt(tabIndex));
        this.titleLabel.setText(this.tabPane.getTitleAt(tabIndex));
        boolean isSelected = this.tabPane.getSelectedIndex() == tabIndex;
        LineBorder innerBorder = isSelected ? new LineBorder(Color.black, 2) : new LineBorder(Color.black, 1);
        this.setBorder(new CompoundBorder(new ShadowPopupBorder(), innerBorder));
    }

    public void setPreviewImage(BufferedImage previewImage, boolean toAnimate) {
        this.previewImage = previewImage;
        if (toAnimate) {
            this.previewImagePanel.putClientProperty("lafwidgets.animationKind", LafWidgetUtilities.getAnimationKind(this.tabPane));
            FadeTracker.getInstance().trackFadeIn(FadeKind.ENABLE, this.previewImagePanel, false, null);
        }
    }

    protected class TabPreviewControlLayout
    implements LayoutManager {
        protected TabPreviewControlLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = TabPreviewControl.this.getInsets();
            TabPreviewControl.this.iconLabel.setBounds(insets.left + 1, insets.top + 1, 16, 16);
            TabPreviewControl.this.titleLabel.setBounds(insets.left + 18, insets.top + 1, width - 18 - insets.left - insets.right, 16);
            TabPreviewControl.this.previewImagePanel.setBounds(insets.left + 1, insets.top + 17, width - insets.left - insets.right - 2, height - 17 - insets.top - insets.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }
    }
}

