/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib;

import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class DemoApp {
    private static final Logger LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ctreber.aclib.DemoApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger(clazz);
    }

    public static void main(String[] stringArray) {
        new DemoApp().run(stringArray);
    }

    private void run(String[] stringArray) {
        if (stringArray.length == 0) {
            JOptionPane.showMessageDialog(null, "Usage: java -jar aclibico.jar {<ICO file|subdir>}", "AC.lib ICO - Usage", 0);
            System.exit(1);
        }
        JFrame jFrame = this.createMainWindow();
        JPanel jPanel = this.createICOFilesPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jFrame.getContentPane().add(jScrollPane);
        List list = this.getICOFileList(stringArray);
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            ICOFile iCOFile = this.obtainICOFile(file);
            if (iCOFile == null) {
                this.addErrorMessage(jPanel, file);
                continue;
            }
            this.addICOPanel(jPanel, iCOFile);
        }
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private List getICOFileList(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.addAll(this.getFiles(stringArray[n]));
            ++n;
        }
        return arrayList;
    }

    private JFrame createMainWindow() {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        return jFrame;
    }

    private void addICOPanel(JPanel jPanel, ICOFile iCOFile) {
        JPanel jPanel2 = this.createICOFilePanel(iCOFile);
        jPanel.add(jPanel2);
        Iterator iterator = iCOFile.getDescriptors().iterator();
        while (iterator.hasNext()) {
            BitmapDescriptor bitmapDescriptor = (BitmapDescriptor)iterator.next();
            Image image = this.createImage(iCOFile, bitmapDescriptor);
            if (image == null) continue;
            this.addBitmap(jPanel2, bitmapDescriptor, image);
        }
    }

    private void addBitmap(JPanel jPanel, BitmapDescriptor bitmapDescriptor, Image image) {
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(new ImageIcon(image));
        jPanel2.add(jButton);
        JPanel jPanel3 = this.createBitmapText(bitmapDescriptor);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
    }

    private void addErrorMessage(JPanel jPanel, File file) {
        JLabel jLabel = new JLabel("Couldn't read ICO file " + file);
        jLabel.setForeground(Color.RED);
        jPanel.add(jLabel);
    }

    private JPanel createICOFilesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        return jPanel;
    }

    private Image createImage(ICOFile iCOFile, BitmapDescriptor bitmapDescriptor) {
        try {
            return bitmapDescriptor.getImageRGB();
        }
        catch (RuntimeException runtimeException) {
            LOG.error("Could not create image from " + iCOFile + ", " + bitmapDescriptor + " (reason " + runtimeException + ")", runtimeException);
            return null;
        }
    }

    private ICOFile obtainICOFile(File file) {
        try {
            return new ICOFile(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            LOG.error("Could not read ICO file " + file + " (reason: " + iOException + ")", iOException);
            return null;
        }
        catch (RuntimeException runtimeException) {
            LOG.error("Encoding problem?", runtimeException);
            return null;
        }
    }

    private JPanel createBitmapText(BitmapDescriptor bitmapDescriptor) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(new JLabel("Descriptor: " + bitmapDescriptor));
        jPanel.add(new JLabel("Header: " + bitmapDescriptor.getHeader()));
        jPanel.add(new JLabel("Bitmap: " + bitmapDescriptor.getBitmap()));
        return jPanel;
    }

    private JPanel createICOFilePanel(ICOFile iCOFile) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), iCOFile.toString()));
        return jPanel;
    }

    private List getFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(string);
        if (file.isFile()) {
            arrayList.add(file);
        } else {
            this.getFilesRecursively(arrayList, file);
        }
        return arrayList;
    }

    private void getFilesRecursively(List list, File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isFile() && file2.getName().toLowerCase().endsWith(".ico")) {
                list.add(file2);
            }
            if (file2.isDirectory()) {
                this.getFilesRecursively(list, file2);
            }
            ++n;
        }
    }
}

