/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib;

import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DemoAppSPI {
    private int _frames;

    public static void main(String[] stringArray) throws IOException {
        new DemoAppSPI().run(stringArray);
    }

    private void run(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: aclibico.sh <fileName:string> [{, <fileName:string>}]\nfileName can be an URL, too");
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ICOFile iCOFile = null;
            try {
                URL uRL = new URL(string);
                iCOFile = new ICOFile(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                iCOFile = new ICOFile(string);
            }
            int n2 = 0;
            while (n2 < iCOFile.getDescriptors().size()) {
                this.addEntry(string, iCOFile, n2);
                ++n2;
            }
            ++n;
        }
    }

    private void addEntry(String string, ICOFile iCOFile, int n) {
        BitmapDescriptor bitmapDescriptor = iCOFile.getDescriptor(n);
        System.out.println(DemoAppSPI.getCaption(string, n, bitmapDescriptor));
        Image image = bitmapDescriptor.getImageRGB();
        if (image != null) {
            JFrame jFrame = new JFrame(DemoAppSPI.getCaption(string, n, bitmapDescriptor));
            jFrame.getContentPane().add(new JButton(new ImageIcon(image)));
            jFrame.setSize(500, 200);
            jFrame.setVisible(true);
            ++this._frames;
            jFrame.setDefaultCloseOperation(2);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    DemoAppSPI.this.windowClose();
                }
            });
        } else {
            System.err.println("Could not create RGB image for image no. " + (1 + n));
        }
    }

    private void windowClose() {
        --this._frames;
        if (this._frames <= 0) {
            System.out.println("Bye!");
            System.exit(0);
        }
    }

    private static String getCaption(String string, int n, BitmapDescriptor bitmapDescriptor) {
        return String.valueOf(string) + ": " + "Entry no. " + (1 + n) + ", " + bitmapDescriptor.getWidth() + " x " + bitmapDescriptor.getHeight() + ", " + bitmapDescriptor.getBPP() + " BPP";
    }
}

