/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.codec;

import com.ctreber.aclib.codec.AbstractDecoder;
import java.io.IOException;
import java.io.InputStream;

public class StreamDecoder
extends AbstractDecoder {
    private final InputStream _stream;

    public StreamDecoder(InputStream inputStream) {
        this._stream = inputStream;
    }

    public void seek(long l) throws IOException {
        long l2 = l - this.getPos();
        if (l2 >= 0L) {
            long l3 = this._stream.skip(l2);
            if (l3 != l2) {
                throw new IOException("Tried to skip " + l2 + ", but skipped " + l3);
            }
            this._pos += l2;
        } else {
            throw new IllegalArgumentException("Can't seek a position already passed (skip " + l2 + ")");
        }
    }

    public byte[] readBytes(long l, byte[] byArray) throws IOException {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = new byte[(int)l];
        } else if ((long)byArray2.length < l) {
            throw new IllegalArgumentException("Insufficient space in buffer");
        }
        int n = this._stream.read(byArray2, 0, (int)l);
        if ((long)n != l) {
            throw new IOException("Tried to read " + l + " bytes, but obtained " + n);
        }
        this._pos += l;
        return byArray2;
    }

    public void close() throws IOException {
        this._stream.close();
    }
}

