/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.image.ico;

import com.ctreber.aclib.codec.AbstractDecoder;
import com.ctreber.aclib.image.ico.AbstractBitmap;
import com.ctreber.aclib.image.ico.AbstractBitmapIndexed;
import com.ctreber.aclib.image.ico.BitmapHeader;
import com.ctreber.aclib.image.ico.BitmapMask;
import java.awt.Image;
import java.io.IOException;
import org.apache.log4j.Logger;

public class BitmapDescriptor {
    private static final Logger LOG;
    private final int _width;
    private final int _height;
    private final int _colorCount;
    private final int _reserved;
    private final int _planes;
    private final int _bpp;
    private final long _size;
    private final long _offset;
    private BitmapHeader _header;
    private AbstractBitmap _bitmap;
    private BitmapMask _mask;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ctreber.aclib.image.ico.BitmapDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger(clazz);
    }

    public BitmapDescriptor(AbstractDecoder abstractDecoder) throws IOException {
        LOG.debug("Reading descriptor at " + abstractDecoder.getPos());
        this._width = abstractDecoder.readUInt1();
        this._height = abstractDecoder.readUInt1();
        this._colorCount = abstractDecoder.readUInt1();
        this._reserved = abstractDecoder.readUInt1();
        this._planes = abstractDecoder.readUInt2();
        this._bpp = abstractDecoder.readUInt2();
        this._size = abstractDecoder.readUInt4();
        this._offset = abstractDecoder.readUInt4();
        LOG.debug(this);
    }

    public String toString() {
        return "width: " + this._width + ", height: " + this._height + ", colorCount: " + this._colorCount + " (" + this.getColorCount() + ")" + ", planes: " + this._planes + ", BPP: " + this._bpp + ", size: " + this._size + ", offset: " + this._offset;
    }

    public Image getImageIndexed() {
        if (!(this._bitmap instanceof AbstractBitmapIndexed)) {
            return null;
        }
        return ((AbstractBitmapIndexed)this._bitmap).createImageIndexed();
    }

    public int getBPP() {
        if (this._bpp != 0) {
            return this._bpp;
        }
        return this._header.getBPP();
    }

    public int getBPPRaw() {
        return this._bpp;
    }

    public Image getImageRGB() {
        return this._bitmap.createImageRGB();
    }

    public int getColorCountRaw() {
        return this._colorCount;
    }

    public int getColorCount() {
        return this._colorCount == 0 ? 256 : this._colorCount;
    }

    public int getHeight() {
        return this._height;
    }

    public long getOffset() {
        return this._offset;
    }

    public int getPlanes() {
        return this._planes;
    }

    public int getReserved() {
        return this._reserved;
    }

    public long getSize() {
        return this._size;
    }

    public int getWidth() {
        return this._width;
    }

    public BitmapHeader getHeader() {
        return this._header;
    }

    void setHeader(BitmapHeader bitmapHeader) {
        this._header = bitmapHeader;
    }

    public BitmapMask getMask() {
        return this._mask;
    }

    public AbstractBitmap getBitmap() {
        return this._bitmap;
    }

    void setBitmap(AbstractBitmap abstractBitmap) {
        this._bitmap = abstractBitmap;
    }
}

