/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageProtocolVersionException;
import org.freedesktop.dbus.exceptions.MessageTypeException;

public class MessageReader {
    private InputStream in;
    private byte[] buf = null;
    private byte[] tbuf = null;
    private byte[] header = null;
    private byte[] body = null;
    private int[] len = new int[4];

    public MessageReader(InputStream inputStream) {
        this.in = new BufferedInputStream(inputStream);
    }

    public Message readMessage() throws IOException, DBusException {
        Message message;
        int n;
        if (null == this.buf) {
            this.buf = new byte[12];
            this.len[0] = 0;
        }
        if (this.len[0] < 12) {
            try {
                n = this.in.read(this.buf, this.len[0], 12 - this.len[0]);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return null;
            }
            if (-1 == n) {
                throw new EOFException(Gettext._("Underlying transport returned EOF"));
            }
            this.len[0] = this.len[0] + n;
        }
        if (this.len[0] == 0) {
            return null;
        }
        if (this.len[0] < 12) {
            return null;
        }
        byte by = this.buf[0];
        byte by2 = this.buf[1];
        byte by3 = this.buf[3];
        if (by3 > 1) {
            this.buf = null;
            throw new MessageProtocolVersionException(MessageFormat.format(Gettext._("Protocol version {0} is unsupported"), by3));
        }
        if (null == this.tbuf) {
            this.tbuf = new byte[4];
            this.len[1] = 0;
        }
        if (this.len[1] < 4) {
            try {
                n = this.in.read(this.tbuf, this.len[1], 4 - this.len[1]);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return null;
            }
            if (-1 == n) {
                throw new EOFException(Gettext._("Underlying transport returned EOF"));
            }
            this.len[1] = this.len[1] + n;
        }
        if (this.len[1] < 4) {
            return null;
        }
        int n2 = 0;
        if (null == this.header) {
            n2 = (int)Message.demarshallint(this.tbuf, 0, by, 4);
            if (0 != n2 % 8) {
                n2 += 8 - n2 % 8;
            }
        } else {
            n2 = this.header.length - 8;
        }
        if (null == this.header) {
            this.header = new byte[n2 + 8];
            System.arraycopy(this.tbuf, 0, this.header, 0, 4);
            this.len[2] = 0;
        }
        if (this.len[2] < n2) {
            try {
                n = this.in.read(this.header, 8 + this.len[2], n2 - this.len[2]);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return null;
            }
            if (-1 == n) {
                throw new EOFException(Gettext._("Underlying transport returned EOF"));
            }
            this.len[2] = this.len[2] + n;
        }
        if (this.len[2] < n2) {
            return null;
        }
        int n3 = 0;
        if (null == this.body) {
            n3 = (int)Message.demarshallint(this.buf, 4, by, 4);
        }
        if (null == this.body) {
            this.body = new byte[n3];
            this.len[3] = 0;
        }
        if (this.len[3] < this.body.length) {
            try {
                n = this.in.read(this.body, this.len[3], this.body.length - this.len[3]);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                return null;
            }
            if (-1 == n) {
                throw new EOFException(Gettext._("Underlying transport returned EOF"));
            }
            this.len[3] = this.len[3] + n;
        }
        if (this.len[3] < this.body.length) {
            return null;
        }
        switch (by2) {
            case 1: {
                message = new MethodCall();
                break;
            }
            case 2: {
                message = new MethodReturn();
                break;
            }
            case 4: {
                message = new DBusSignal();
                break;
            }
            case 3: {
                message = new Error();
                break;
            }
            default: {
                throw new MessageTypeException(MessageFormat.format(Gettext._("Message type {0} unsupported"), by2));
            }
        }
        try {
            message.populate(this.buf, this.header, this.body);
        }
        catch (DBusException dBusException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            this.buf = null;
            this.tbuf = null;
            this.body = null;
            this.header = null;
            throw dBusException;
        }
        catch (RuntimeException runtimeException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            this.buf = null;
            this.tbuf = null;
            this.body = null;
            this.header = null;
            throw runtimeException;
        }
        this.buf = null;
        this.tbuf = null;
        this.body = null;
        this.header = null;
        return message;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

