/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import com.apple.eawt.CocoaComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.swing.event.EventListenerList;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;
import org.jdesktop.jdic.browser.WebKitEngine;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;

public class WebKitWebBrowser
extends CocoaComponent
implements IWebBrowser {
    public static final int storeJavaObject = 1;
    public static final int loadURL = 2;
    public static final int resizeFrame = 3;
    public static final int stopLoading = 4;
    public static final int goBack = 5;
    public static final int goForward = 6;
    public static final int updateCursor = 7;
    public static final int runJS = 8;
    public static final int textLarger = 9;
    public static final int textSmaller = 10;
    public static final int search = 11;
    public static final int dispose = 12;
    public static final int ordercallback = 13;
    public static final int loadURLFromString = 14;
    public static final int reload = 15;
    public static final int INIT_WIDTH = 500;
    public static final int INIT_HEIGHT = 420;
    public static final int WEB_VIEW_POLICY_NONE = 0;
    public static final int WEB_VIEW_POLICY_IN_OLD_WINDOW = 1;
    public static final int WEB_VIEW_POLICY_IN_NEW_WINDOW = 2;
    protected boolean needResize = false;
    URL lastURL = null;
    private String HTMLSource = null;
    int nsObject = 0;
    protected int newWebViewCreatingPolicy = 1;
    protected EventListenerList listenerList = new EventListenerList();
    private URL url;
    private boolean backEnabled;
    private boolean forwardEnabled;
    private static String failReason;
    private static IBrowserEngine engine;
    private boolean synchronize = false;
    private String initFailureMessage = "WebBrowser is not initialized.";
    private boolean isInitialized = false;

    public native int createNSView1();

    public WebKitWebBrowser() {
        BrowserEngineManager.instance().setActiveEngine(BrowserEngineManager.WEBKIT);
    }

    public int getNewWebViewCreatingPolicy() {
        return this.newWebViewCreatingPolicy;
    }

    public void setNewWebViewCreatingPolicy(int n) {
        this.newWebViewCreatingPolicy = n;
        if (this.newWebViewCreatingPolicy < 0 || this.newWebViewCreatingPolicy > 2) {
            this.newWebViewCreatingPolicy = 1;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.sendMsg(1, (Object)this);
        if (this.url != null) {
            this.sendMsg(2, this.url.toString());
        }
    }

    public void refresh() {
        this.sendMsg(3, (Object)this);
        Container container = this.getParent();
        if (container != null) {
            container.repaint();
        }
        if (this.needResize) {
            Dimension dimension = this.getSize();
            ++dimension.width;
            ++dimension.height;
            this.setSize(dimension);
            --dimension.width;
            --dimension.height;
            this.setSize(dimension);
            this.needResize = false;
        }
    }

    public void sendMsg(int n) {
        if (this.nsObject != 0) {
            this.sendMessage(n, null);
        }
    }

    public void sendMsg(int n, Object object) {
        if (this.nsObject != 0) {
            this.sendMessage(n, object);
        }
    }

    public String executeScript(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new Object[]{string, stringBuffer};
        this.sendMsg(8, objectArray);
        return stringBuffer.toString();
    }

    public void reload() {
        this.sendMsg(15);
    }

    public void makeTextLarger() {
        this.sendMsg(9);
    }

    public void makeTextSmaller() {
        this.sendMsg(10);
    }

    protected void reRenderDocument() {
        this.makeTextLarger();
        this.makeTextSmaller();
    }

    public void validate() {
        super.validate();
    }

    public void dispose() {
        this.sendMsg(12);
    }

    protected void orderCallback() {
        this.sendMsg(13);
    }

    protected void callback(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    public boolean runJavaScriptAlertPanelWithMessage(String string) {
        System.out.println("Java runJavaScriptAlertPanelWithMessage " + string);
        return true;
    }

    public String getContent() {
        return this.HTMLSource;
    }

    private void clearHTMLSource() {
        this.HTMLSource = null;
    }

    public void setHTMLSource(String string) {
        this.clearHTMLSource();
        if (string != null) {
            this.HTMLSource = new String(string);
        }
    }

    public void setContent(String string) {
        this.clearHTMLSource();
        if (string != null) {
            this.HTMLSource = new String(string);
        }
    }

    public void invokeFromWebKitThread(Runnable runnable) {
        this.sendMsg(13, runnable);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public boolean searchForString(String string, boolean bl, boolean bl2, boolean bl3) {
        Object[] objectArray = new Object[]{string, new boolean[4]};
        ((boolean[])objectArray[1])[0] = bl;
        ((boolean[])objectArray[1])[1] = bl2;
        ((boolean[])objectArray[1])[2] = bl3;
        ((boolean[])objectArray[1])[3] = false;
        this.sendMsg(11, objectArray);
        return ((boolean[])objectArray[1])[3];
    }

    public void finishURLLoading() {
        this.refresh();
        this.fireWebBrowserEvent(this, 3004, null);
    }

    public void startURLLoading(String string) {
        if (string == null) {
            return;
        }
        this.clearHTMLSource();
        this.url = null;
        try {
            this.url = new URL(string);
        }
        catch (Throwable throwable) {
            this.url = null;
        }
        this.fireWebBrowserEvent(this, 3003, null);
    }

    public void mouseDidMoveOverElement(Object object) {
    }

    public int createNSView() {
        this.nsObject = this.createNSView1();
        return this.nsObject;
    }

    public int getNativeWindow() {
        return this.nsObject;
    }

    public int getInstanceNum() {
        return 0;
    }

    public void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getInitFailureMessage() {
        return this.initFailureMessage;
    }

    public void setInitFailureMessage(String string) {
        this.initFailureMessage = string;
    }

    public boolean isSynchronize() {
        return this.synchronize;
    }

    public static String getFailReason() {
        return failReason;
    }

    public static void setFailReason(String string) {
        failReason = string;
    }

    public boolean isBackEnabled() {
        return this.backEnabled;
    }

    public void setBackEnabled(boolean bl) {
        this.backEnabled = bl;
    }

    public boolean isForwardEnabled() {
        return this.forwardEnabled;
    }

    public void setForwardEnabled(boolean bl) {
        this.forwardEnabled = bl;
    }

    public void dispatchWebBrowserEvent(WebBrowserEvent webBrowserEvent) {
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(160, 90);
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 270);
    }

    public void setURLTitle(String string) {
        this.fireWebBrowserEvent(this, 3023, string);
    }

    public void setURLIcon(ByteBuffer byteBuffer) {
    }

    public void setBackButtonEnable(boolean bl) {
        this.backEnabled = bl;
    }

    public void setForwardButtonEnable(boolean bl) {
        this.forwardEnabled = bl;
    }

    public void errorOccurred(String string, String string2) {
        failReason = string;
        this.fireWebBrowserEvent(this, 3006, string);
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL() {
        this.setURL(null, null);
    }

    public void setURL(URL uRL) {
        this.setURL(uRL, null);
    }

    public void setURL(URL uRL, String string) {
        this.url = uRL;
        if (uRL != null) {
            this.sendMsg(2, uRL.toString());
        } else {
            this.sendMsg(2, "about:blank");
        }
    }

    public void setURL(URL uRL, String string, String string2) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public void back() {
        this.sendMsg(5);
    }

    public void forward() {
        this.sendMsg(6);
    }

    public void stop() {
        this.sendMsg(4);
    }

    public IBrowserEngine getBrowserEngine() {
        return engine;
    }

    public Component asComponent() {
        return this;
    }

    public synchronized void addWebBrowserListener(WebBrowserListener webBrowserListener) {
        this.listenerList.add(WebBrowserListener.class, webBrowserListener);
    }

    public synchronized void removeWebBrowserListener(WebBrowserListener webBrowserListener) {
        this.listenerList.remove(WebBrowserListener.class, webBrowserListener);
    }

    protected void fireWebBrowserEvent(IWebBrowser iWebBrowser, int n, String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        WebBrowserEvent webBrowserEvent = null;
        block10: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jdesktop$jdic$browser$WebBrowserListener == null ? WebKitWebBrowser.class$("org.jdesktop.jdic.browser.WebBrowserListener") : class$org$jdesktop$jdic$browser$WebBrowserListener)) continue;
            if (webBrowserEvent == null) {
                webBrowserEvent = new WebBrowserEvent(iWebBrowser, n, string);
            }
            switch (n) {
                case 3042: {
                    ((WebBrowserListener)objectArray[i + 1]).initializationCompleted(webBrowserEvent);
                    continue block10;
                }
                case 3003: {
                    ((WebBrowserListener)objectArray[i + 1]).downloadStarted(webBrowserEvent);
                    continue block10;
                }
                case 3004: {
                    ((WebBrowserListener)objectArray[i + 1]).downloadCompleted(webBrowserEvent);
                    continue block10;
                }
                case 3005: {
                    ((WebBrowserListener)objectArray[i + 1]).downloadProgress(webBrowserEvent);
                    continue block10;
                }
                case 3006: {
                    ((WebBrowserListener)objectArray[i + 1]).downloadError(webBrowserEvent);
                    continue block10;
                }
                case 3007: {
                    ((WebBrowserListener)objectArray[i + 1]).documentCompleted(webBrowserEvent);
                    continue block10;
                }
                case 3023: {
                    ((WebBrowserListener)objectArray[i + 1]).titleChange(webBrowserEvent);
                    continue block10;
                }
                case 3024: {
                    ((WebBrowserListener)objectArray[i + 1]).statusTextChange(webBrowserEvent);
                }
            }
        }
    }

    static {
        engine = new WebKitEngine();
        WebBrowserUtil.loadLibrary();
    }
}

