/*
 * Decompiled with CFR 0.152.
 */
package com.t4l.jmf;

import com.t4l.jmf.RGBConverter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.utility.LoggerSingleton;

public class JPEGDecoder
implements Codec {
    private static final Logger logger = LoggerSingleton.logger;
    private static final JPEGFormat jpegFormat = new JPEGFormat();
    private static final RGBFormat rgbFormat = new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1);
    static Hashtable imageTable = new Hashtable();

    protected static void readJPEG(byte[] data, BufferedImage dest) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ImageInputStream stream = ImageIO.createImageInputStream(in);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        ImageReader reader = iter.next();
        if (reader == null) {
            throw new UnsupportedOperationException("This image is unsupported.");
        }
        reader.setInput(stream, false);
        ImageReadParam param = reader.getDefaultReadParam();
        param.setDestination(dest);
        reader.read(0, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable hashtable = imageTable;
        synchronized (hashtable) {
            imageTable.clear();
        }
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new String[0];
    }

    public String getName() {
        return "JPEG Decoder";
    }

    public Format[] getSupportedInputFormats() {
        return new VideoFormat[]{jpegFormat};
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return new VideoFormat[]{rgbFormat};
        }
        if (input.relax().matches(jpegFormat)) {
            VideoFormat inputVideoFormat = (VideoFormat)input;
            return new VideoFormat[]{new RGBFormat(inputVideoFormat.getSize(), -1, Format.intArray, inputVideoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255)};
        }
        return new Format[0];
    }

    public void open() throws ResourceUnavailableException {
    }

    public int process(Buffer input, Buffer output) {
        Format inputFormat = input.getFormat();
        Format outputFormat = output.getFormat();
        if (inputFormat.relax().matches(jpegFormat) && (outputFormat == null || outputFormat.relax().matches(rgbFormat))) {
            return this.processJPEGtoRGB(input, output);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processJPEGtoRGB(Buffer input, Buffer output) {
        Hashtable hashtable = imageTable;
        synchronized (hashtable) {
            try {
                int[] intArray;
                VideoFormat inputFormat = (VideoFormat)input.getFormat();
                RGBFormat outputFormat = (RGBFormat)output.getFormat();
                if (outputFormat == null) {
                    int width = inputFormat.getSize().width;
                    int height = inputFormat.getSize().height;
                    outputFormat = new RGBFormat(new Dimension(width, height), width * height, Format.intArray, inputFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, width, 0, 1);
                    output.setFormat(outputFormat);
                }
                byte[] b = (byte[])input.getData();
                Dimension d = inputFormat.getSize();
                BufferedImage dest = (BufferedImage)imageTable.get(d);
                if (dest == null) {
                    dest = new BufferedImage(d.width, d.height, 1);
                }
                JPEGDecoder.readJPEG(b, dest);
                imageTable.put(d, dest);
                Object obj = output.getData();
                if (obj instanceof int[]) {
                    intArray = (int[])obj;
                } else {
                    intArray = new int[dest.getWidth() * dest.getHeight()];
                    output.setData(intArray);
                }
                RGBConverter.populateArray(dest, intArray, (RGBFormat)output.getFormat());
                output.setDiscard(input.isDiscard());
                output.setDuration(input.getDuration());
                output.setEOM(input.isEOM());
                output.setFlags(input.getFlags());
                output.setHeader(null);
                output.setTimeStamp(input.getTimeStamp());
                output.setSequenceNumber(input.getSequenceNumber());
                output.setOffset(0);
                output.setLength(dest.getWidth() * dest.getHeight());
                return 0;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "" + t, t);
                return 1;
            }
        }
    }

    public void reset() {
    }

    public Format setInputFormat(Format f) {
        if (f.relax().matches(jpegFormat)) {
            return f;
        }
        return null;
    }

    public Format setOutputFormat(Format f) {
        if (f.relax().matches(rgbFormat)) {
            return f;
        }
        return null;
    }
}

