/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTPSourceInfoCache;
import net.sf.fmj.media.rtp.SSRCInfo;

public abstract class RTPSourceInfo
implements Participant {
    RTPSourceInfoCache sic;
    private SSRCInfo[] ssrc;
    private SourceDescription cname;

    RTPSourceInfo(String cname, RTPSourceInfoCache sic) {
        this.cname = new SourceDescription(1, cname, 0, false);
        this.sic = sic;
        this.ssrc = new SSRCInfo[0];
    }

    synchronized void addSSRC(SSRCInfo ssrcinfo) {
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (this.ssrc[i] != ssrcinfo) continue;
            return;
        }
        this.ssrc = new SSRCInfo[this.ssrc.length + 1];
        System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length - 1);
        this.ssrc[this.ssrc.length - 1] = ssrcinfo;
    }

    public String getCNAME() {
        return this.cname.getDescription();
    }

    SourceDescription getCNAMESDES() {
        return this.cname;
    }

    public Vector getReports() {
        Vector<SSRCInfo> reportlist = new Vector<SSRCInfo>();
        for (int i = 0; i < this.ssrc.length; ++i) {
            reportlist.addElement(this.ssrc[i]);
        }
        reportlist.trimToSize();
        return reportlist;
    }

    public Vector getSourceDescription() {
        Vector sdeslist = null;
        if (this.ssrc.length == 0) {
            sdeslist = new Vector(0);
            return sdeslist;
        }
        sdeslist = this.ssrc[0].getSourceDescription();
        return sdeslist;
    }

    RTPStream getSSRCStream(long filterssrc) {
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (!(this.ssrc[i] instanceof RTPStream) || this.ssrc[i].ssrc != (int)filterssrc) continue;
            return (RTPStream)((Object)this.ssrc[i]);
        }
        return null;
    }

    int getStreamCount() {
        return this.ssrc.length;
    }

    public Vector getStreams() {
        Vector<SSRCInfo> recvstreams = new Vector<SSRCInfo>();
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (!this.ssrc[i].isActive()) continue;
            recvstreams.addElement(this.ssrc[i]);
        }
        recvstreams.trimToSize();
        return recvstreams;
    }

    synchronized void removeSSRC(SSRCInfo ssrcinfo) {
        if (ssrcinfo.dsource != null) {
            this.sic.ssrccache.sm.removeDataSource(ssrcinfo.dsource);
        }
        for (int i = 0; i < this.ssrc.length; ++i) {
            if (this.ssrc[i] != ssrcinfo) continue;
            this.ssrc[i] = this.ssrc[this.ssrc.length - 1];
            this.ssrc = new SSRCInfo[this.ssrc.length - 1];
            System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length);
            break;
        }
        if (this.ssrc.length == 0) {
            this.sic.remove(this.cname.getDescription());
        }
    }
}

