/* Example2.java
 * =========================================================================
 * This file is part of the JLaTeXMath Library - http://jlatexmath.sourceforge.net
 * 
 * Copyright (C) 2009 DENIZET Calixte
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;

import org.scilab.forge.jlatexmath.TeXConstants; 
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

import org.scilab.forge.jlatexmath.cache.JLaTeXMathCache;

/**
 * A class to test LaTeX rendering.
 **/
public class Example2 {
    public static void main(String[] args) {
	
	String latex = "\\begin{array}{l}";
	latex += "\\forall\\varepsilon\\in\\mathbb{R}_+^*\\ \\exists\\eta>0\\ |x-x_0|\\leq\\eta\\Longrightarrow|f(x)-f(x_0)|\\leq\\varepsilon\\\\";
	latex += "\\det\\begin{bmatrix}a_{11}&a_{12}&\\cdots&a_{1n}\\\\a_{21}&\\ddots&&\\vdots\\\\\\vdots&&\\ddots&\\vdots\\\\a_{n1}&\\cdots&\\cdots&a_{nn}\\end{bmatrix}\\overset{\\mathrm{def}}{=}\\sum_{\\sigma\\in\\mathfrak{S}_n}\\varepsilon(\\sigma)\\prod_{k=1}^n a_{k\\sigma(k)}\\\\";
	latex += "\\sideset{_\\alpha^\\beta}{_\\gamma^\\delta}{\\begin{pmatrix}a&b\\\\c&d\\end{pmatrix}}\\\\";
	latex += "\\int_0^\\infty{x^{2n} e^{-a x^2}\\,dx} = \\frac{2n-1}{2a} \\int_0^\\infty{x^{2(n-1)} e^{-a x^2}\\,dx} = \\frac{(2n-1)!!}{2^{n+1}} \\sqrt{\\frac{\\pi}{a^{2n+1}}}\\\\";
	latex += "\\int_a^b{f(x)\\,dx} = (b - a) \\sum\\limits_{n = 1}^\\infty  {\\sum\\limits_{m = 1}^{2^n  - 1} {\\left( { - 1} \\right)^{m + 1} } } 2^{ - n} f(a + m\\left( {b - a} \\right)2^{-n} )\\\\";
	latex += "\\int_{-\\pi}^{\\pi} \\sin(\\alpha x) \\sin^n(\\beta x) dx = \\textstyle{\\left \\{ \\begin{array}{cc} (-1)^{(n+1)/2} (-1)^m \\frac{2 \\pi}{2^n} \\binom{n}{m} & n \\mbox{ odd},\\ \\alpha = \\beta (2m-n) \\\\ 0 & \\mbox{otherwise} \\\\ \\end{array} \\right .}\\\\";
	latex += "L = \\int_a^b \\sqrt{ \\left|\\sum_{i,j=1}^ng_{ij}(\\gamma(t))\\left(\\frac{d}{dt}x^i\\circ\\gamma(t)\\right)\\left(\\frac{d}{dt}x^j\\circ\\gamma(t)\\right)\\right|}\\,dt\\\\";
	latex += "\\begin{array}{rl} s &= \\int_a^b\\left\\|\\frac{d}{dt}\\vec{r}\\,(u(t),v(t))\\right\\|\\,dt \\\\ &= \\int_a^b \\sqrt{u'(t)^2\\,\\vec{r}_u\\cdot\\vec{r}_u + 2u'(t)v'(t)\\, \\vec{r}_u\\cdot\\vec{r}_v+ v'(t)^2\\,\\vec{r}_v\\cdot\\vec{r}_v}\\,\\,\\, dt. \\end{array}\\\\";
	latex += "\\end{array}";

	//latex = "\\text{salut calixte $\\frac12$}";

	//latex = "{A'}^2\\ \\ A'\\ A'''\\ A'^2\\ \\text{A'-B''}A'-B''\\text{A?`B}";
	//latex = "A_1^2\\ A^1_2\\ A^1^2\\ A_1_2\\ A^1^2_3\\ A_1^2_3_4";
	
	//latex = "\\begin{array}{|l|}\\begin  {array}{c}Hello\\cr Calixte\\end{array}a\\end{array}";

	//latex = "\\left| f \\int_\\Omega \\left|\\widetilde{S}^{-1,0}_{a,-} W_2(\\Omega, \\Gamma_1)\\right|\\ \\right|";

	//latex = "\\fbox{\\text{Salut}}\\ovalbox{\\text{Mon cher}}\\shadowbox{\\text{Calixte}}\\doublebox{\\text{Denizet}}";
	//latex = "\\shadowbox{\\frac12}";//\\fbox{\\rotatebox[origin=Bl]{90}{\\dbend}}";
	
	latex = "\\text{A\\raisebox{1cm}{B}g\\raisebox{1cm}[1.5cm]{B}D\\raisebox{1cm}[1.5cm][2cm]{B}C}";
	latex = "AB\\text";
	latex ="\\textcircled{\\texttt1}\\textcircled{\\texttt S}\\textcircled{\\texttt P}\\textcircled{A}\\textcircled{g}\\textcircled{12}";
	latex = "\\OE\\oe\\cal{ABCD}''\\text{\\it\\sc\\bf abcd'' Γεια σας κόσμο}";
	latex = "\\begin{array}{l}1,234,567.89\\cr 1\\mathpunct.234\\mathpunct.567,89\\end{array}";
	latex = "\\textit{123456789}";
	//latex = "\\text{A\\rotatebox[origin=bl]{45}{bl}\\rotatebox[origin=c]{45}{c}\\rotatebox[origin=br]{45}{br}\\rotatebox[origin=tl]{45}{tl}\\rotatebox[origin=tr]{45}{tr}\\rotatebox[origin=Bl]{45}{Bl}\\rotatebox[origin=Br]{45}{Br}}";

//\\Gamma\\varepsilon\\iota\\alpha\\ Γεια\\ \\text{Γεια σας κόσμο}";
	//System.out.println((int)latex.charAt(1));

	//TeXFormula formula = TeXFormula.getPartialTeXFormula(latex);
	TeXFormula formula = new TeXFormula(true, latex);
	//formula.setDEBUG(true);
	//formula.setDPITarget(300);
	TeXIcon icon = formula.createTeXIcon(TeXConstants.STYLE_DISPLAY, Integer.parseInt(args[0]));
	icon.setInsets(new Insets(5, 5, 5, 5));
	
	BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), BufferedImage.TYPE_INT_ARGB);
	Graphics2D g2 = image.createGraphics();
	g2.setColor(Color.white);
	g2.fillRect(0,0,icon.getIconWidth(),icon.getIconHeight());
	JLabel jl = new JLabel();
	//jl.setForeground(new Color(0, 0, 0));
	icon.paintIcon(jl, g2, 0, 0);
	File file = new File("Example2.png");
	try {
	    ImageIO.write(image, "png", file.getAbsoluteFile());
	    } catch (IOException ex) { }
    }    
}