/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.math;

import jm.audio.math.Factorize;
import jm.audio.math.RealFloatFFT;

public class RealFloatFFT_Radix2
extends RealFloatFFT {
    private int logn;

    public RealFloatFFT_Radix2(int n) {
        super(n);
        this.logn = Factorize.log2(n);
        if (this.logn < 0) {
            throw new IllegalArgumentException(n + " is not a power of 2");
        }
    }

    @Override
    public void transform(float[] fArray, int n, int n2) {
        this.checkData(fArray, n, n2);
        if (this.n == 1) {
            return;
        }
        this.bitreverse(fArray, n, n2);
        int n3 = 1;
        int n4 = this.n;
        for (int i = 1; i <= this.logn; ++i) {
            float f;
            float f2;
            int n5;
            int n6 = n3;
            n3 = 2 * n3;
            n4 /= 2;
            for (n5 = 0; n5 < n4; ++n5) {
                f2 = fArray[n + n2 * n5 * n3] + fArray[n + n2 * (n5 * n3 + n6)];
                f = fArray[n + n2 * n5 * n3] - fArray[n + n2 * (n5 * n3 + n6)];
                fArray[n + n2 * n5 * n3] = f2;
                fArray[n + n2 * (n5 * n3 + n6)] = f;
            }
            f2 = 1.0f;
            f = 0.0f;
            double d = Math.PI * -2 / (double)n3;
            float f3 = (float)Math.sin(d);
            float f4 = (float)Math.sin(d / 2.0);
            float f5 = 2.0f * f4 * f4;
            for (int j = 1; j < n6 / 2; ++j) {
                float f6 = f2 - f3 * f - f5 * f2;
                float f7 = f + f3 * f2 - f5 * f;
                f2 = f6;
                f = f7;
                for (n5 = 0; n5 < n4; ++n5) {
                    f6 = fArray[n + n2 * (n5 * n3 + j)];
                    f7 = fArray[n + n2 * (n5 * n3 + n6 - j)];
                    float f8 = fArray[n + n2 * (n5 * n3 + n6 + j)];
                    float f9 = fArray[n + n2 * (n5 * n3 + n3 - j)];
                    fArray[n + n2 * (n5 * n3 + j)] = f6 + f2 * f8 - f * f9;
                    fArray[n + n2 * (n5 * n3 + n3 - j)] = f7 + f2 * f9 + f * f8;
                    fArray[n + n2 * (n5 * n3 + n6 - j)] = f6 - f2 * f8 + f * f9;
                    fArray[n + n2 * (n5 * n3 + n6 + j)] = -(f7 - f2 * f9 - f * f8);
                }
            }
            if (n6 <= 1) continue;
            for (n5 = 0; n5 < n4; ++n5) {
                int n7 = n + n2 * (n5 * n3 + n3 - n6 / 2);
                fArray[n7] = fArray[n7] * -1.0f;
            }
        }
    }

    @Override
    public void backtransform(float[] fArray, int n, int n2) {
        this.checkData(fArray, n, n2);
        if (this.n == 1) {
            return;
        }
        int n3 = this.n;
        int n4 = 1;
        int n5 = this.n / 2;
        for (int i = 1; i <= this.logn; ++i) {
            float f;
            float f2;
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                f2 = fArray[n + n2 * n6 * n3];
                f = fArray[n + n2 * (n6 * n3 + n5)];
                fArray[n + n2 * n6 * n3] = f2 + f;
                fArray[n + n2 * (n6 * n3 + n5)] = f2 - f;
            }
            f2 = 1.0f;
            f = 0.0f;
            double d = Math.PI * 2 / (double)n3;
            float f3 = (float)Math.sin(d);
            float f4 = (float)Math.sin(d / 2.0);
            float f5 = 2.0f * f4 * f4;
            for (int j = 1; j < n5 / 2; ++j) {
                float f6 = f2 - f3 * f - f5 * f2;
                float f7 = f + f3 * f2 - f5 * f;
                f2 = f6;
                f = f7;
                for (n6 = 0; n6 < n4; ++n6) {
                    float f8 = fArray[n + n2 * (n6 * n3 + j)];
                    float f9 = fArray[n + n2 * (n6 * n3 + n3 - j)];
                    float f10 = fArray[n + n2 * (n6 * n3 + n5 - j)];
                    float f11 = -fArray[n + n2 * (n6 * n3 + n5 + j)];
                    fArray[n + n2 * (n6 * n3 + j)] = f8 + f10;
                    fArray[n + n2 * (n6 * n3 + n5 - j)] = f9 + f11;
                    float f12 = f8 - f10;
                    float f13 = f9 - f11;
                    fArray[n + n2 * (n6 * n3 + n5 + j)] = f2 * f12 - f * f13;
                    fArray[n + n2 * (n6 * n3 + n3 - j)] = f2 * f13 + f * f12;
                }
            }
            if (n5 > 1) {
                for (n6 = 0; n6 < n4; ++n6) {
                    int n7 = n + n2 * (n6 * n3 + n5 / 2);
                    fArray[n7] = fArray[n7] * 2.0f;
                    int n8 = n + n2 * (n6 * n3 + n5 + n5 / 2);
                    fArray[n8] = fArray[n8] * -2.0f;
                }
            }
            n5 /= 2;
            n3 /= 2;
            n4 *= 2;
        }
        this.bitreverse(fArray, n, n2);
    }

    @Override
    public float[] toWraparoundOrder(float[] fArray) {
        return this.toWraparoundOrder(fArray, 0, 1);
    }

    @Override
    public float[] toWraparoundOrder(float[] fArray, int n, int n2) {
        this.checkData(fArray, n, n2);
        float[] fArray2 = new float[2 * this.n];
        int n3 = this.n / 2;
        fArray2[0] = fArray[n];
        fArray2[1] = 0.0f;
        fArray2[this.n] = fArray[n + n2 * n3];
        fArray2[this.n + 1] = 0.0f;
        for (int i = 1; i < n3; ++i) {
            fArray2[2 * i] = fArray[n + n2 * i];
            fArray2[2 * i + 1] = fArray[n + n2 * (this.n - i)];
            fArray2[2 * (this.n - i)] = fArray[n + n2 * i];
            fArray2[2 * (this.n - i) + 1] = -fArray[n + n2 * (this.n - i)];
        }
        return fArray2;
    }

    protected void bitreverse(float[] fArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.n - 1; ++i) {
            int n4 = this.n / 2;
            if (i < n3) {
                float f = fArray[n + n2 * i];
                fArray[n + n2 * i] = fArray[n + n2 * n3];
                fArray[n + n2 * n3] = f;
            }
            while (n4 <= n3) {
                n3 -= n4;
                n4 /= 2;
            }
            n3 += n4;
        }
    }
}

