/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class AllPass
extends AudioObject {
    private float decay;
    private int delay;
    private float[] delayLine;
    private int delayIndex;

    public AllPass(AudioObject audioObject, int n) {
        this(audioObject, n, 0.5);
    }

    public AllPass(AudioObject audioObject, int n, double d) {
        super(audioObject, "[AllPass]");
        this.decay = (float)d;
        this.delay = n;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        int n2 = this.previous[0].nextWork(fArray);
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            fArray[n3] = fArray[n3] + this.delayLine[this.delayIndex] * this.decay;
            float f = fArray[n] * -this.decay;
            float f2 = this.delayLine[this.delayIndex];
            this.delayLine[this.delayIndex] = fArray[n];
            fArray[n] = f + f2;
            if (this.delayIndex < this.delayLine.length) continue;
            this.delayIndex = 0;
        }
        return n;
    }

    @Override
    public void build() {
        int n = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
        this.delayLine = new float[n * this.channels];
        this.delayIndex = 0;
    }
}

