/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.EnvPoint;

public class Envelope
extends AudioObject
implements JMC {
    private EnvPoint[] graphPoints;
    private float[] graphShape;
    private int position = 1;
    private boolean primary;
    private boolean useNotePoints = false;
    private int notePointIndex;

    public Envelope(Instrument instrument, int n, int n2, EnvPoint[] envPointArray) {
        super(instrument, n, "[Envelope]");
        this.channels = n2;
        this.graphPoints = envPointArray;
        this.primary = true;
    }

    public Envelope(Instrument instrument, int n, int n2, double[] dArray) {
        super(instrument, n, "[Envelope]");
        this.channels = n2;
        this.breakPointsToGraphPoints(dArray);
        this.primary = true;
    }

    public Envelope(Instrument instrument, int n, int n2, int n3) {
        super(instrument, n, "[Envelope]");
        this.channels = n2;
        this.useNotePoints = true;
        this.notePointIndex = n3;
        this.primary = true;
    }

    public Envelope(AudioObject audioObject) {
        super(audioObject, "[Envelope]");
        this.useNotePoints = true;
        this.notePointIndex = 0;
        this.primary = false;
    }

    public Envelope(AudioObject audioObject, int n) {
        super(audioObject, "[Envelope]");
        this.useNotePoints = true;
        this.notePointIndex = n;
        this.primary = false;
    }

    public Envelope(AudioObject audioObject, EnvPoint[] envPointArray) {
        super(audioObject, "[Envelope]");
        this.graphPoints = envPointArray;
        this.primary = false;
    }

    public Envelope(AudioObject audioObject, double[] dArray) {
        super(audioObject, "[Envelope]");
        this.breakPointsToGraphPoints(dArray);
        this.primary = false;
    }

    public void setBreakPoints(double[] dArray) {
        this.breakPointsToGraphPoints(dArray);
    }

    private void breakPointsToGraphPoints(double[] dArray) {
        this.graphPoints = new EnvPoint[dArray.length / 2];
        int n = 0;
        for (int i = 0; i < dArray.length / 2; ++i) {
            this.graphPoints[i] = new EnvPoint((float)dArray[n], (float)dArray[n + 1]);
            n += 2;
        }
    }

    @Override
    public int work(float[] fArray) throws AOException {
        if (this.finished && this.inst.iterations <= 0) {
            return fArray.length;
        }
        if (this.primary) {
            int n = fArray.length;
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                try {
                    fArray[i] = this.graphShape[this.position];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    fArray[i] = 0.0f;
                }
                if (n2 == this.channels) {
                    n2 = 1;
                    ++this.position;
                    continue;
                }
                ++n2;
            }
            return n;
        }
        int n = this.previous[0].nextWork(fArray);
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            try {
                fArray[i] = fArray[i] * this.graphShape[this.position];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                fArray[i] = 0.0f;
            }
            if (n3 == this.channels) {
                n3 = 1;
                ++this.position;
                continue;
            }
            ++n3;
        }
        return n;
    }

    @Override
    public void build() {
        int n;
        if (this.useNotePoints) {
            this.breakPointsToGraphPoints(this.currentNote.getBreakPoints(this.notePointIndex));
        }
        this.graphShape = new float[this.numOfSamples];
        if (this.numOfSamples <= this.graphPoints.length * 4) {
            for (int i = 0; i < this.graphShape.length; ++i) {
                this.graphShape[i] = 1.0f;
            }
            return;
        }
        if ((double)this.graphPoints[0].x != -1.0) {
            for (n = 0; n < this.graphPoints.length; ++n) {
                this.graphPoints[n].X = (int)((float)this.numOfSamples * this.graphPoints[n].x);
                --this.graphPoints[n].X;
            }
        }
        n = 0;
        block2: for (int i = 0; i < this.graphPoints.length - 1; ++i) {
            float f = (this.graphPoints[i].y - this.graphPoints[i + 1].y) / (float)(this.graphPoints[i].X - this.graphPoints[i + 1].X);
            float f2 = this.graphPoints[i + 1].y - f * (float)this.graphPoints[i + 1].X;
            while (true) {
                this.graphShape[n] = f * (float)n + f2;
                if (n >= this.graphPoints[i + 1].X) continue block2;
                ++n;
            }
        }
        this.position = 0;
    }
}

