/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class FGTR
extends AudioObject {
    private float[][] FGTArray;
    private int bCounter;
    private int gCounter;
    private int gDuration;
    private int grainsPerBuffer;
    private float bandwidthTop;
    private float bandwidthBottom;
    private float spatial;
    private float highestAmp;
    private float frequency;
    private float grainDuration;

    public FGTR(AudioObject audioObject) {
        super(audioObject, "[FGTR]");
    }

    @Override
    public int work(float[] fArray) throws AOException {
        this.gCounter = 0;
        while (this.gCounter < this.grainsPerBuffer) {
            this.bCounter = (int)this.FGTArray[this.gCounter][0];
            this.gDuration = (int)this.FGTArray[this.gCounter][1];
            this.bandwidthTop = this.FGTArray[this.gCounter][2];
            this.bandwidthBottom = this.FGTArray[this.gCounter][3];
            this.spatial = this.FGTArray[this.gCounter][4];
            this.highestAmp = this.FGTArray[this.gCounter][5];
            this.frequency = (float)((double)(this.bandwidthTop + this.bandwidthBottom) * 0.5);
            int n = 0;
            while ((float)n < this.grainDuration) {
                fArray[this.bCounter] = fArray[this.bCounter] + (float)(Math.sin(Math.PI * 2 * (double)n * (double)(this.frequency * (float)fArray.length / (float)(this.sampleRate * this.channels))) * (Math.sin(Math.PI * (double)((float)n / this.grainDuration)) * (double)this.highestAmp));
                ++this.bCounter;
                ++n;
            }
            ++this.gCounter;
        }
        return 0;
    }
}

