/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Grain2
extends AudioObject {
    private int grainSampSize = 1000;
    private int spaceSamp = 1000;
    private int grainCount = 0;
    private int spaceCount = 0;
    private int offset = 0;
    private boolean grainOn = true;

    public Grain2(AudioObject audioObject, int n, int n2, boolean bl, int n3, int n4) {
        super(audioObject, "[Grain]");
        this.grainSampSize = n * n3;
        this.spaceSamp = n2 * n3;
        this.grainOn = bl;
        this.offset = n4;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        int n2 = this.previous[0].nextWork(fArray);
        int n3 = this.offset;
        if (this.offset > 0) {
            for (n = 0; n < this.offset; ++n) {
                fArray[n] = 0.0f;
            }
            this.offset = 0;
        }
        for (n = n3; n < n2; ++n) {
            if (this.grainOn) {
                fArray[n] = fArray[n] * (float)Math.sin(Math.PI * (double)this.grainCount / (double)this.grainSampSize);
            }
            if (this.grainOn && this.grainCount < this.grainSampSize) {
                ++this.grainCount;
            } else if (this.grainOn) {
                this.grainOn = false;
                this.grainCount = 0;
            }
            if (!this.grainOn) {
                fArray[n] = 0.0f;
            }
            if (!this.grainOn && this.spaceCount < this.spaceSamp) {
                ++this.spaceCount;
                continue;
            }
            if (this.grainOn) continue;
            this.grainOn = true;
            this.spaceCount = 0;
        }
        return n2;
    }

    public void setGrainDur(int n) {
        this.grainSampSize = n;
        System.out.println("Space4: " + this.grainSampSize);
    }

    public void setSpaceDur(int n) {
        this.spaceSamp = n;
        System.out.println("Space4: " + this.spaceSamp);
    }
}

