/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Granulator
extends AudioObject {
    private int grainDuration = 1323;
    private int envelopeType = 1;
    private int nog;
    private float cfm;
    private int cgd;
    private float[] grain;
    private float[] newbuf;
    private int grainCnt = 0;
    private int grainsPerSecond = 10;
    private float[] tailBuf;
    private float freqMod = 1.0f;
    private float[] inBuffer = null;
    private boolean inBufActive = false;
    private boolean ri = false;
    private boolean rgd = false;
    private int rdist = 0;
    private int rdisttemp = 0;
    private int gdb = 1000;
    private int gdt = 1000;
    private boolean rf = false;
    private float rfb = 0.99f;
    private float rft = 1.01f;
    private float[] durationArray;
    private float[] gpsArray;
    private float[] freqArray;
    private boolean premapped = false;

    public Granulator(AudioObject audioObject, int n, int n2, int n3, int n4) {
        super(audioObject, "[Granulator]");
        this.grainDuration = n3;
        this.grainsPerSecond = n4;
        this.cgd = 0;
        this.grain = new float[this.grainDuration];
        this.tailBuf = new float[0];
        this.sampleRate = n;
        this.channels = n2;
    }

    public Granulator(AudioObject audioObject, int n, int n2, float[] fArray, float[] fArray2, float[] fArray3, boolean bl, boolean bl2, boolean bl3, int n3) {
        super(audioObject, "[Granulator]");
        this.durationArray = fArray;
        this.gpsArray = fArray2;
        this.freqArray = fArray3;
        this.grain = new float[(int)this.durationArray[0]];
        this.ri = bl;
        this.rgd = bl2;
        this.rf = bl3;
        this.tailBuf = new float[0];
        this.rdist = n3;
        this.premapped = true;
        this.sampleRate = n;
        this.channels = n2;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        int n2;
        if (this.inBuffer == null) {
            this.newbuf = new float[fArray.length];
            this.previous[0].nextWork(this.newbuf);
        } else {
            this.newbuf = new float[fArray.length];
            for (n2 = 0; n2 < this.inBuffer.length && n2 < this.newbuf.length; ++n2) {
                this.newbuf[n2] = this.inBuffer[n2];
            }
            this.inBuffer = null;
        }
        if (this.grainsPerSecond <= 0) {
            this.grainsPerSecond = 1;
        }
        this.nog = (int)((float)this.newbuf.length / ((float)(this.sampleRate * this.channels) / (float)this.grainsPerSecond));
        if (this.nog <= 0) {
            this.nog = 1;
        }
        n2 = this.newbuf.length / this.nog;
        for (n = 0; n < fArray.length && n < this.tailBuf.length; ++n) {
            int n3 = n;
            fArray[n3] = fArray[n3] + this.tailBuf[n];
        }
        this.tailBuf = new float[this.newbuf.length];
        this.inBufActive = true;
        for (n = 0; n < this.nog; ++n) {
            this.rdisttemp = this.rdist > 0 ? (int)(Math.random() * (double)this.rdist) : 0;
            int n4 = n * n2 + this.rdisttemp;
            this.setGrain(n4 - this.rdisttemp);
            for (int i = 0; i < this.grain.length; ++i) {
                if (n4 >= fArray.length) {
                    int n5 = n4 - fArray.length;
                    this.tailBuf[n5] = this.tailBuf[n5] + this.grain[i];
                } else {
                    int n6 = n4;
                    fArray[n6] = fArray[n6] + this.grain[i];
                }
                ++n4;
                ++this.grainCnt;
            }
        }
        this.inBufActive = false;
        return fArray.length;
    }

    public void setFreqMod(float f) {
        this.freqMod = f;
    }

    public void setGrainDuration(int n) {
        this.grainDuration = n;
    }

    public void setGrainsPerSecond(int n) {
        this.grainsPerSecond = n;
    }

    public void setEnvelopeType(int n) {
        this.envelopeType = n;
    }

    public void setRandomGrainDuration(boolean bl) {
        this.rgd = bl;
    }

    public void setRandomGrainBottom(int n) {
        this.gdb = n;
    }

    public void setRandomGrainTop(int n) {
        this.gdt = n;
    }

    public void setRandomIndex(boolean bl) {
        this.ri = bl;
    }

    public void setRandomFreq(boolean bl) {
        this.rf = bl;
    }

    public void setRandomDist(int n) {
        this.rdist = n;
    }

    public void setRandomFreqBottom(float f) {
        this.rfb = f;
    }

    public void setRandomFreqTop(float f) {
        this.rft = f;
    }

    private void setGrain(int n) throws AOException {
        int n2;
        if (this.ri) {
            n = (int)(Math.random() * (double)this.newbuf.length);
        }
        float[] fArray = this.newbuf;
        this.cgd = this.rgd ? this.gdb + (int)(Math.random() * (double)this.gdt) : this.grainDuration;
        this.cfm = this.freqMod;
        if (this.rf) {
            this.cfm = (float)((double)this.rfb + Math.random() * (double)(this.rft - this.rfb));
        }
        if (this.inBufActive) {
            this.inBuffer = new float[this.newbuf.length];
            n2 = this.previous[0].nextWork(this.inBuffer);
            this.inBufActive = false;
        }
        this.grain = new float[this.cgd];
        n2 = 0;
        float f = 0.0f;
        double d = -1.0 / (double)((1.0f - this.cfm) / this.cfm);
        double d2 = 0.0;
        int n3 = 0;
        if (d < 0.0) {
            d = -1.0 / d;
            n3 = 1;
        }
        if (d == 0.0) {
            n3 = 2;
        }
        int n4 = 0;
        int n5 = n;
        while (true) {
            block21: {
                block22: {
                    block19: {
                        block20: {
                            if (n5 == fArray.length) {
                                n5 = 0;
                                fArray = this.inBuffer;
                            }
                            if (n3 != 0) break block19;
                            if (++n4 < (int)(d + d2)) break block20;
                            d2 = (d + d2) % 1.0;
                            n4 = 0;
                            break block21;
                        }
                        if (n2 >= this.cgd) break;
                        this.grain[n2++] = fArray[n5];
                        break block22;
                    }
                    if (n3 == 1) {
                        if (d + d2 >= 1.0) {
                            float f2 = (f - fArray[n5]) / (float)((int)d + 1);
                            for (int i = 0; i < (int)(d + d2); ++i) {
                                this.grain[n2++] = f2 * (float)i + fArray[n5];
                                if (n2 == this.cgd) break;
                            }
                        }
                        if (n2 == this.cgd) break;
                        this.grain[n2++] = fArray[n5];
                        f = fArray[n5];
                        d2 = (d + d2) % 1.0;
                    } else {
                        this.grain[n2++] = fArray[n5];
                    }
                }
                if (n2 == this.cgd) break;
            }
            ++n5;
        }
        if (this.envelopeType <= 1) {
            for (n5 = 0; n5 < this.cgd; ++n5) {
                this.grain[n5] = this.grain[n5] * (float)(0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)n5 / (double)this.cgd));
            }
        } else if (this.envelopeType == 3) {
            for (n5 = 0; n5 < this.cgd / 2; ++n5) {
                this.grain[n5] = this.grain[n5] * 2.0f;
            }
            for (n5 = this.cgd / 2; n5 < this.cgd; ++n5) {
                this.grain[n5] = this.grain[n5] * -2.0f + 2.0f;
            }
        } else {
            for (n5 = 0; n5 < this.cgd; ++n5) {
                this.grain[n5] = this.grain[n5] * (float)Math.sin(Math.PI * (double)n5 / (double)this.cgd);
            }
        }
    }
}

