/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class Oscillator
extends AudioObject {
    public static final int SINE_WAVE = 0;
    public static final int COSINE_WAVE = 1;
    public static final int TRIANGLE_WAVE = 2;
    public static final int SQUARE_WAVE = 3;
    public static final int SAWTOOTH_WAVE = 4;
    public static final int SAWDOWN_WAVE = 5;
    public static final int SABERSAW_WAVE = 6;
    public static final int PULSE_WAVE = 7;
    public static final int AMPLITUDE = 0;
    public static final int FREQUENCY = 1;
    private float si;
    private float phase;
    private int choice;
    private float amp = 1.0f;
    private float frq = -1.0f;
    private float frqRatio = 1.0f;
    private int waveType = 0;
    private double pulseWidth = 0.15;

    public Oscillator(AudioObject[] audioObjectArray) throws AOException {
        super(audioObjectArray, "[Oscillator]");
        if (audioObjectArray.length > 2) {
            throw new AOException(this.name, 1);
        }
    }

    public Oscillator(AudioObject audioObject, int n, int n2) {
        super(audioObject, "[Oscillator]");
        this.waveType = n;
        this.choice = n2;
    }

    public Oscillator(AudioObject audioObject, int n, int n2, double d) {
        super(audioObject, "[Oscillator]");
        this.waveType = n;
        this.choice = n2;
        if (n2 == 1) {
            this.frq = (float)d;
        } else {
            this.amp = (float)d;
        }
    }

    public Oscillator(Instrument instrument) {
        this(instrument, 0);
    }

    public Oscillator(Instrument instrument, int n) {
        this(instrument, n, 44100);
    }

    public Oscillator(Instrument instrument, int n, int n2) {
        this(instrument, n, n2, 1);
    }

    public Oscillator(Instrument instrument, int n, int n2, int n3) {
        super(instrument, n2, "[Oscillator]");
        this.waveType = n;
        this.channels = n3;
    }

    public Oscillator(Instrument instrument, int n, int n2, int n3, int n4, double d) {
        super(instrument, n2, "[Oscillator]");
        this.waveType = n;
        this.channels = n3;
        this.choice = n4;
        if (this.choice == 1) {
            this.frq = (float)d;
        } else {
            this.amp = (float)d;
        }
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n = fArray.length / this.channels;
        int n2 = 0;
        if (this.inputs == 2) {
            float[] fArray2;
            float[] fArray3 = new float[n];
            int n3 = this.previous[0].nextWork(fArray3);
            if (n3 != this.previous[1].work(fArray2 = new float[n3])) {
                throw new AOException(this.name, 0);
            }
            int n4 = 0;
            while (n2 < fArray.length) {
                this.setSI(fArray2[n4] * this.frqRatio);
                float f = this.getWaveSample() * this.amp * fArray3[n4];
                for (int i = 0; i < this.channels; ++i) {
                    fArray[n2++] = f;
                }
                ++n4;
            }
        } else if (this.inputs == 1 && this.choice == 0) {
            float[] fArray4 = new float[n];
            int n5 = this.previous[0].nextWork(fArray4);
            int n6 = 0;
            while (n2 < fArray.length) {
                float f = this.getWaveSample() * this.amp * fArray4[n6];
                for (int i = 0; i < this.channels; ++i) {
                    fArray[n2++] = f;
                }
                ++n6;
            }
        } else if (this.inputs == 1 && this.choice == 1) {
            float[] fArray5 = new float[n];
            int n7 = this.previous[0].work(fArray5);
            for (int i = 0; i < n; ++i) {
                this.setSI(fArray5[i] * this.frqRatio);
                float f = this.getWaveSample() * this.amp;
                for (int j = 0; j < this.channels; ++j) {
                    fArray[n2++] = f;
                }
            }
        } else {
            while (n2 < fArray.length) {
                if (this.choice == 1) {
                    this.setSI(this.frq * this.frqRatio);
                }
                float f = this.getWaveSample() * this.amp;
                for (int i = 0; i < this.channels; ++i) {
                    try {
                        fArray[n2++] = f;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        --n2;
                    }
                }
            }
        }
        return n2;
    }

    @Override
    public void build() {
        if (this.frq < 0.0f) {
            float f = (float)this.currentNote.getFrequency();
            this.setSI(f *= this.frqRatio);
        } else {
            this.frq *= this.frqRatio;
            this.setSI(this.frq);
        }
    }

    public void setChoice(int n) {
        this.choice = n;
    }

    public void setAmp(float f) {
        this.amp = f;
        this.choice = 0;
    }

    public float getAmp() {
        return this.amp;
    }

    public void setFrq(float f) {
        this.frq = f;
        this.choice = 1;
    }

    public void setFrqRatio(double d) {
        this.frqRatio = (float)d;
    }

    protected void setSI(double d) {
        this.si = (float)Math.PI * 2 / ((float)this.sampleRate / (float)d);
    }

    protected float getWaveSample() {
        switch (this.waveType) {
            case 0: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float f = (float)Math.sin(this.phase + (float)Math.PI * 2);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f;
            }
            case 1: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float f = (float)Math.cos(this.phase + (float)Math.PI * 2);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f;
            }
            case 2: {
                float f;
                float f2 = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                if ((f = 0.15915494f * this.phase) <= 0.25f) {
                    f2 = (float)((double)f * 4.0);
                }
                if (f > 0.25f && f <= 0.75f) {
                    f2 = (float)(4.0 * (0.5 - (double)f));
                }
                if (f > 0.75f) {
                    f2 = (float)(((double)f - 1.0) * 4.0);
                }
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f2;
            }
            case 3: {
                float f;
                float f3 = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                f3 = (f = 0.15915494f * this.phase) < 0.5f ? 1.0f : -1.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f3;
            }
            case 4: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float f = 0.31830987f * this.phase;
                float f4 = (float)((double)f - 1.0);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f4;
            }
            case 5: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float f = 0.31830987f * this.phase;
                float f5 = (float)(1.0 - (double)f);
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f5;
            }
            case 6: {
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                float f = 0.15915494f * this.phase;
                float f6 = (float)Math.exp(f) - 2.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f6;
            }
            case 7: {
                float f;
                float f7 = 0.0f;
                if (this.phase < 0.0f) {
                    this.phase += (float)Math.PI * 2;
                }
                f7 = (f = 0.15915494f * this.phase) < (float)this.pulseWidth ? 1.0f : -1.0f;
                this.phase += this.si;
                if (this.phase >= (float)Math.PI * 2) {
                    this.phase -= (float)Math.PI * 2;
                }
                return f7;
            }
        }
        System.err.println("Incorrect oscillator type selected.");
        System.exit(1);
        return 0.0f;
    }

    public void setPulseWidth(double d) {
        if (d >= 0.0 && d <= 1.0) {
            this.pulseWidth = d;
        } else {
            System.err.println("Pulse wide must be between 0.0 and 1.0");
        }
    }

    public void setPhase(double d) {
        this.phase = (float)d;
    }
}

