/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public final class Pluck
extends AudioObject {
    private int index = 0;
    float[] kernel = null;
    private boolean primary = true;
    private float prevSample = 0.0f;
    private float feedback = 0.49f;
    private float decay = 0.5f;
    private int delay = 1;
    private float[] delayLine;
    private int delayIndex;

    public Pluck(Instrument instrument, int n, int n2) {
        this(instrument, n, n2, 0.49);
    }

    public Pluck(Instrument instrument, int n, int n2, double d) {
        super(instrument, n, "[Pluck]");
        this.channels = n2;
        this.feedback = (float)d;
    }

    public Pluck(AudioObject audioObject) {
        this(audioObject, 0.5);
    }

    public Pluck(AudioObject audioObject, double d) {
        super(audioObject, "[Pluck]");
        this.primary = false;
        this.feedback = (float)d;
    }

    public void setFeedback(double d) {
        this.feedback = (float)d;
    }

    @Override
    public void build() {
        int n;
        double d = this.currentNote.getFrequency();
        int n2 = (int)((double)this.sampleRate / d);
        this.kernel = new float[n2];
        for (n = 0; n < n2; ++n) {
            this.kernel[n] = this.primary ? (float)(Math.random() * 2.0 - 1.0) : 0.0f;
        }
        n = (int)((float)this.delay / 1000.0f * (float)this.sampleRate);
        this.delayLine = new float[n * this.channels];
        this.delayIndex = 0;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n = 0;
        float f = 0.0f;
        if (this.primary) {
            if (this.index >= this.kernel.length) {
                this.index = 0;
            }
            while (n < fArray.length) {
                f = this.kernel[this.index];
                for (int i = 0; i < this.channels; ++i) {
                    fArray[n] = this.kernel[this.index];
                    try {
                        int n2 = n;
                        fArray[n2] = fArray[n2] + this.delayLine[this.delayIndex] * this.decay;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        System.err.println("jMusic Pluck audio object error: i = " + n + " delayIndex = " + this.delayIndex);
                    }
                    float f2 = fArray[n] * -this.decay;
                    float f3 = this.delayLine[this.delayIndex];
                    this.delayLine[this.delayIndex] = fArray[n];
                    fArray[n] = f2 + f3;
                    if (this.delayIndex >= this.delayLine.length) {
                        this.delayIndex = 0;
                    }
                    ++n;
                }
                this.kernel[this.index] = (this.kernel[this.index] + this.prevSample) * this.feedback;
                this.prevSample = f;
                ++this.index;
                if (this.index < this.kernel.length) continue;
                this.index = 0;
            }
        } else {
            if (this.index >= this.kernel.length) {
                this.index = 0;
            }
            while (n < fArray.length) {
                f = fArray[n];
                this.kernel[this.index] = (fArray[n] + this.prevSample) * this.feedback;
                for (int i = 0; i < this.channels; ++i) {
                    fArray[n++] = this.kernel[this.index];
                }
                this.prevSample = f;
                ++this.index;
                if (this.index < this.kernel.length) continue;
                this.index = 0;
            }
        }
        return n;
    }
}

