/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.SpringPipe;

public class Spring
extends AudioObject {
    private SpringPipe springNetwork;
    private int numberOfNodes = 8;
    private double springConstant;
    private double massFriction;
    private double jitter;

    public Spring(Instrument instrument, int n) {
        this(instrument, n, 44100.0, 1.0);
    }

    public Spring(Instrument instrument, int n, double d, double d2) {
        this(instrument, n, d, d2, 0.0, 44100, 1);
    }

    public Spring(Instrument instrument, int n, double d, double d2, double d3, int n2, int n3) {
        super(instrument, n2, "[WaveTable]");
        this.numberOfNodes = n;
        this.springConstant = d;
        this.jitter = d3;
        this.massFriction = d2;
        this.channels = n3;
    }

    @Override
    public void build() {
        this.springNetwork = new SpringPipe(this.numberOfNodes, this.springConstant, this.massFriction, this.jitter);
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n = 0;
        while (n < fArray.length) {
            for (int i = 0; i < this.channels; ++i) {
                fArray[n++] = (float)(this.springNetwork.getNextNodePosition(0) / (double)(40 / this.numberOfNodes) - 3.0);
            }
        }
        return n;
    }
}

