/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public final class Value
extends AudioObject {
    private float theValue;
    private double changeRatio = 1.0;
    int noteAttribute = 0;
    public static final int FIXED = 0;
    public static final int NOTE_PITCH = 1;
    public static final int NOTE_DYNAMIC = 2;
    public static final int NOTE_DURATION = 3;
    public static final int NOTE_RHYTHM_VALUE = 4;

    public Value(Instrument instrument, int n, int n2, float f) {
        super(instrument, n, "[Value]");
        this.theValue = f;
        this.channels = n2;
    }

    public Value(Instrument instrument, int n, int n2, int n3) {
        super(instrument, n, "[Value]");
        this.noteAttribute = n3;
        this.channels = n2;
    }

    public double getChangeRation() {
        return this.changeRatio;
    }

    public void setChangeRation(double d) {
        this.changeRatio = d;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = this.theValue;
        }
        return n;
    }

    @Override
    public void build() {
        switch (this.noteAttribute) {
            case 0: {
                break;
            }
            case 1: {
                this.theValue = (float)(this.currentNote.getFrequency() * this.changeRatio);
                break;
            }
            case 2: {
                this.theValue = 127.0f / (float)((double)this.currentNote.getDynamic() * this.changeRatio);
                break;
            }
            case 3: {
                this.theValue = (float)(this.currentNote.getDuration() * this.changeRatio);
                break;
            }
            case 4: {
                this.theValue = (float)(this.currentNote.getRhythmValue() * this.changeRatio);
                break;
            }
            default: {
                System.err.println(this.name + " A value setting of " + this.theValue + " is not supported yet");
                System.exit(1);
            }
        }
    }
}

