/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Volume
extends AudioObject {
    float mainVolume = 1.0f;
    float volume = 1.0f;
    double linearVolumeValue = 1.0;
    private int returned;
    private int index;
    private float[] tmp;

    public Volume(AudioObject audioObject) {
        this(audioObject, 1.0f);
    }

    public Volume(AudioObject audioObject, double d) {
        this(audioObject, (float)d);
    }

    public Volume(AudioObject audioObject, float f) {
        super(audioObject, "[Volume]");
        this.mainVolume = f;
    }

    @Override
    public void build() {
        this.linearVolumeValue = (double)this.currentNote.getDynamic() / 127.0;
        this.volume = (float)(1.0 - Math.log(128.0 - (double)this.currentNote.getDynamic()) * 0.2) * this.mainVolume;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        this.returned = this.previous[0].nextWork(fArray);
        if (this.inputs == 2) {
            if (this.tmp == null || this.tmp.length != fArray.length) {
                this.tmp = new float[fArray.length];
            } else {
                this.index = 0;
                while (this.index < this.tmp.length) {
                    this.tmp[this.index] = 0.0f;
                    ++this.index;
                }
            }
            if (this.returned != this.previous[1].nextWork(this.tmp)) {
                throw new AOException(this.name, 0);
            }
            this.index = 0;
            while (this.index < this.returned) {
                fArray[this.index] = fArray[this.index] * this.tmp[this.index];
                ++this.index;
            }
        } else {
            this.index = 0;
            while (this.index < this.returned) {
                fArray[this.index] = fArray[this.index] * this.volume;
                ++this.index;
            }
        }
        return this.returned;
    }

    public void setVolume(double d) {
        this.linearVolumeValue = d;
        this.volume = (float)Math.min(1.0, Math.abs(Math.log(1.0 - d) * 0.2));
    }

    public double getVolume() {
        return this.linearVolumeValue;
    }
}

