/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class WaveTable
extends AudioObject {
    private float[] waveTable;
    private float si;
    private float phase;
    private int aoDestination;
    private float amp = 1.0f;
    private float frq = -1.0f;
    private float frqRatio = 1.0f;
    public static final int AMPLITUDE = 0;
    public static final int FREQUENCY = 1;
    public static final int MONO = 1;
    public static final int STEREO = 2;

    public WaveTable(AudioObject[] audioObjectArray, float[] fArray) throws AOException {
        super(audioObjectArray, "[WaveTable]");
        if (audioObjectArray.length > 2) {
            throw new AOException(this.name, 1);
        }
        this.waveTable = fArray;
    }

    public WaveTable(AudioObject audioObject, float[] fArray, int n) {
        super(audioObject, "[WaveTable]");
        this.waveTable = fArray;
        this.aoDestination = n;
    }

    public WaveTable(Instrument instrument, int n, float[] fArray, int n2, int n3, float f) {
        super(instrument, n, "[WaveTable]");
        this.waveTable = fArray;
        this.channels = n2;
        this.aoDestination = n3;
        if (n3 == 1) {
            this.frq = f;
        } else {
            this.amp = f;
        }
    }

    public WaveTable(Instrument instrument, int n, float[] fArray, int n2) {
        super(instrument, n, "[WaveTable]");
        this.waveTable = fArray;
        this.channels = n2;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n = fArray.length / this.channels;
        int n2 = 0;
        if (this.inputs == 2) {
            float[] fArray2;
            float[] fArray3 = new float[n];
            int n3 = this.previous[0].nextWork(fArray3);
            if (n3 != this.previous[1].work(fArray2 = new float[n3])) {
                throw new AOException(this.name, 0);
            }
            int n4 = 0;
            while (n2 < fArray.length) {
                this.setSI((int)fArray2[n4]);
                if (this.phase < 0.0f) {
                    this.phase = (float)this.waveTable.length + this.phase;
                }
                float f = this.waveTable[(int)this.phase] * (this.amp * fArray3[n4]);
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int i = 0; i < this.channels; ++i) {
                    fArray[n2++] = f;
                }
                ++n4;
            }
        } else if (this.inputs == 1 && this.aoDestination == 0) {
            float[] fArray4 = new float[n];
            int n5 = this.previous[0].nextWork(fArray4);
            int n6 = 0;
            while (n2 < fArray.length) {
                float f = this.waveTable[(int)this.phase] * (this.amp * fArray4[n6]);
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int i = 0; i < this.channels; ++i) {
                    fArray[n2++] = f;
                }
                ++n6;
            }
        } else if (this.inputs == 1 && this.aoDestination == 1) {
            float[] fArray5 = new float[n];
            int n7 = this.previous[0].work(fArray5);
            for (int i = 0; i < n; ++i) {
                this.setSI((int)fArray5[i]);
                if (this.phase < 0.0f) {
                    this.phase = (float)this.waveTable.length + this.phase;
                }
                float f = this.waveTable[(int)this.phase] * this.amp;
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int j = 0; j < this.channels; ++j) {
                    fArray[n2++] = f;
                }
            }
        } else {
            while (n2 < fArray.length) {
                float f = this.waveTable[(int)this.phase] * this.amp;
                this.phase += this.si;
                if (this.phase >= (float)this.waveTable.length) {
                    this.phase -= (float)this.waveTable.length;
                }
                for (int i = 0; i < this.channels; ++i) {
                    try {
                        fArray[n2++] = f;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        --n2;
                    }
                }
            }
        }
        return n2;
    }

    @Override
    public void build() {
        float f = (float)this.currentNote.getFrequency() * this.frqRatio;
        if (this.frq < 0.0f) {
            this.setSI(f);
        } else {
            this.setSI(this.frq);
        }
    }

    public void setAmp(float f) {
        this.amp = f;
    }

    public void setFrq(float f) {
        this.frq = f;
    }

    public void setFrqRatio(float f) {
        this.frqRatio = f;
    }

    protected void setSI(float f) {
        this.si = f / (float)this.sampleRate * (float)this.waveTable.length;
    }
}

