/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;

public class JmMidiPlayer
extends OutputStream {
    private Sequencer sequencer = MidiSystem.getSequencer();
    private Transmitter transmitter;
    private Receiver receiver;
    private MidiDevice synthesizer = JmMidiPlayer.getSynthesizer();
    ByteArrayOutputStream os;

    private static MidiDevice getSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        MidiDevice midiDevice = null;
        boolean bl = false;
        for (int i = 0; i < infoArray.length; ++i) {
            if (bl) continue;
            try {
                MidiDevice.Info info = infoArray[i - 1];
                System.out.print(info.toString());
                System.out.print(" Getting Info ");
                midiDevice = MidiSystem.getMidiDevice(info);
                if (!(midiDevice instanceof Sequencer)) {
                    System.out.print(" Opening ");
                    bl = true;
                    System.out.println(" Opened");
                    continue;
                }
                System.out.println(" Not a Sequencer");
                continue;
            }
            catch (Throwable throwable) {
                System.out.println(" Exception " + throwable.getMessage());
            }
        }
        if (bl) {
            return midiDevice;
        }
        System.out.println("No Synthesizer Device Found");
        throw new MidiUnavailableException("No Synthesizer Device Found");
    }

    public JmMidiPlayer() throws MidiUnavailableException {
        this.transmitter = this.sequencer.getTransmitter();
        this.receiver = this.synthesizer.getReceiver();
        this.transmitter.setReceiver(this.receiver);
        this.sequencer.open();
        if (this.sequencer.isOpen()) {
            // empty if block
        }
        this.os = new ByteArrayOutputStream();
        MidiDevice.Info info = this.synthesizer.getDeviceInfo();
        MidiDevice.Info info2 = this.sequencer.getDeviceInfo();
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            MidiDevice.Info info3 = infoArray[i];
            System.out.print(info3.toString());
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info3);
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.out.println(" Unavailable");
            }
        }
        if (this.sequencer.isOpen()) {
            // empty if block
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{new Integer(n).byteValue()};
        this.write(byArray);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    public void play() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.os.toByteArray());
            Sequence sequence = MidiSystem.getSequence(byteArrayInputStream);
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            this.sequencer.setSequence(sequence);
            this.sequencer.start();
            while (this.sequencer.isRunning()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.sequencer.stop();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.out.println("Bad Midi Data " + invalidMidiDataException.getMessage());
        }
        catch (MidiUnavailableException midiUnavailableException) {
            System.out.println("Unable to Re-Open Sequencer " + midiUnavailableException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IO Exception in Midi " + iOException.getMessage());
        }
    }

    @Override
    public void close() {
        this.sequencer.close();
    }
}

