/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jm.JMC;
import jm.gui.cpn.BassStave;
import jm.gui.cpn.CpnZoomScreen;
import jm.gui.cpn.GrandStave;
import jm.gui.cpn.JmMidiPlayer;
import jm.gui.cpn.LetterNotesEditor;
import jm.gui.cpn.ParmScreen;
import jm.gui.cpn.PhraseViewer;
import jm.gui.cpn.PianoStave;
import jm.gui.cpn.Stave;
import jm.gui.cpn.TrebleStave;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Play;
import jm.util.Read;
import jm.util.Write;

public class Notate
extends Frame
implements ActionListener,
WindowListener,
JMC {
    private Score score;
    private Phrase[] phraseArray;
    private Stave[] staveArray;
    private int scrollHeight = 130;
    private int locationX = 0;
    private int locationY = 0;
    private Dialog keyDialog;
    private Dialog timeDialog;
    private MenuItem keySig;
    private MenuItem open;
    private MenuItem openJmXml;
    private MenuItem openjm;
    private MenuItem play;
    private MenuItem stop;
    private MenuItem delete;
    private MenuItem clear;
    private MenuItem newStave;
    private MenuItem close;
    private MenuItem timeSig;
    private MenuItem saveJmXml;
    private MenuItem saveJM;
    private MenuItem saveMidi;
    private MenuItem quit;
    private MenuItem trebleStave;
    private MenuItem bassStave;
    private MenuItem pianoStave;
    private MenuItem grandStave;
    private MenuItem automaticStave;
    private MenuItem appendMidiFile;
    private MenuItem insertMidiFile;
    private MenuItem setParameters;
    private MenuItem playAll;
    private MenuItem playMeasure;
    private MenuItem repeatAll;
    private MenuItem repeatMeasure;
    private MenuItem stopPlay;
    private MenuItem earTrain;
    private MenuItem addNotes;
    private MenuItem adjustTiming;
    private MenuItem viewDetails;
    private MenuItem viewTitle;
    private MenuItem viewZoom;
    private MenuItem barNumbers;
    public boolean timeToStop;
    private Panel scoreBG;
    private GridBagConstraints constraints;
    private GridBagLayout layout;
    private ScrollPane scroll;
    private String lastFileName = "*.mid";
    private String lastDirectory = "";
    private String fileNameFilter = "*.mid";
    private boolean zoomed;
    private Phrase beforeZoom = new Phrase();
    private Phrase afterZoom = new Phrase();
    private int height = 0;
    private int width = 700;

    public Notate() {
        this(new Phrase(), 0, 0);
        this.clearZoom();
    }

    public Notate(int n, int n2) {
        this(new Phrase(), n, n2);
        this.clearZoom();
    }

    public Notate(Phrase phrase) {
        this(phrase, 0, 0);
        this.clearZoom();
    }

    private void clearZoom() {
        this.zoomed = false;
    }

    public Notate(Phrase phrase, int n, int n2) {
        super("CPN: " + phrase.getTitle());
        this.clearZoom();
        this.score = new Score(new Part(phrase));
        this.locationX = n;
        this.locationY = n2;
        this.score = new Score(new Part(phrase));
        this.init();
    }

    public Notate(Score score, int n, int n2) {
        super("CPN: " + score.getTitle());
        this.clearZoom();
        this.score = score;
        this.locationX = n;
        this.locationY = n2;
        this.init();
    }

    public void init() {
        this.addWindowListener(this);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File", true);
        Menu menu2 = new Menu("Tools", true);
        Menu menu3 = new Menu("Play", true);
        Menu menu4 = new Menu("View", true);
        this.newStave = new MenuItem("New", new MenuShortcut(78));
        this.newStave.addActionListener(this);
        menu.add(this.newStave);
        this.open = new MenuItem("Open MIDI file...", new MenuShortcut(79));
        this.open.addActionListener(this);
        menu.add(this.open);
        this.openJmXml = new MenuItem("Open jMusic XML file...");
        this.openJmXml.addActionListener(this);
        menu.add(this.openJmXml);
        this.openjm = new MenuItem("Open jm file..");
        this.openjm.addActionListener(this);
        menu.add(this.openjm);
        this.close = new MenuItem("Close", new MenuShortcut(87));
        this.close.addActionListener(this);
        menu.add(this.close);
        menu.add("-");
        this.delete = new MenuItem("Delete last note", new MenuShortcut(68));
        this.delete.addActionListener(this);
        menu.add(this.delete);
        this.clear = new MenuItem("Clear all notes", new MenuShortcut(67));
        this.clear.addActionListener(this);
        menu.add(this.clear);
        menu.add("-");
        this.keySig = new MenuItem("Key Signature", new MenuShortcut(75));
        this.keySig.addActionListener(this);
        menu.add(this.keySig);
        this.timeSig = new MenuItem("Time Signature", new MenuShortcut(84));
        this.timeSig.addActionListener(this);
        menu.add(this.timeSig);
        menu.add("-");
        this.saveMidi = new MenuItem("Save as a MIDI file...", new MenuShortcut(83));
        this.saveMidi.addActionListener(this);
        menu.add(this.saveMidi);
        this.saveJmXml = new MenuItem("Save as a jMusic XML file...", new MenuShortcut(83, true));
        this.saveJmXml.addActionListener(this);
        menu.add(this.saveJmXml);
        this.saveJM = new MenuItem("Save as a jm file...");
        this.saveJM.addActionListener(this);
        menu.add(this.saveJM);
        menu.add("-");
        this.setParameters = new MenuItem("Set Parameters...");
        this.setParameters.addActionListener(this);
        menu2.add(this.setParameters);
        this.addNotes = new MenuItem("Add Notes by Letter");
        this.addNotes.addActionListener(this);
        menu2.add(this.addNotes);
        this.adjustTiming = new MenuItem("Quantize Timing");
        this.adjustTiming.addActionListener(this);
        menu2.add(this.adjustTiming);
        this.playAll = new MenuItem("Play All", new MenuShortcut(80));
        this.playAll.addActionListener(this);
        menu3.add(this.playAll);
        this.repeatAll = new MenuItem("Repeat All");
        this.repeatAll.addActionListener(this);
        menu3.add(this.repeatAll);
        this.playMeasure = new MenuItem("Play Last Measure");
        this.playMeasure.addActionListener(this);
        menu3.add(this.playMeasure);
        this.repeatMeasure = new MenuItem("Repeat Last Measure");
        this.repeatMeasure.addActionListener(this);
        menu3.add(this.repeatMeasure);
        this.stopPlay = new MenuItem("Stop Playback", new MenuShortcut(80, true));
        this.stopPlay.addActionListener(this);
        menu3.add(this.stopPlay);
        Menu menu5 = new Menu("Stave");
        menu.add(menu5);
        this.trebleStave = new MenuItem("Treble");
        this.trebleStave.addActionListener(this);
        menu5.add(this.trebleStave);
        this.bassStave = new MenuItem("Bass");
        this.bassStave.addActionListener(this);
        menu5.add(this.bassStave);
        this.pianoStave = new MenuItem("Piano");
        this.pianoStave.addActionListener(this);
        menu5.add(this.pianoStave);
        this.grandStave = new MenuItem("Grand");
        this.grandStave.addActionListener(this);
        menu5.add(this.grandStave);
        this.automaticStave = new MenuItem("Automatic");
        this.automaticStave.addActionListener(this);
        menu5.add(this.automaticStave);
        menu.add("-");
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        menu.add(this.quit);
        this.viewDetails = new MenuItem("Note data as text");
        this.viewDetails.addActionListener(this);
        menu4.add(this.viewDetails);
        this.viewZoom = new MenuItem("View phrase section", new MenuShortcut(86));
        this.viewZoom.addActionListener(this);
        menu4.add(this.viewZoom);
        this.barNumbers = new MenuItem("Bar Numbers", new MenuShortcut(66));
        this.barNumbers.addActionListener(this);
        menu4.add(this.barNumbers);
        this.viewTitle = new MenuItem("Stave Title");
        this.viewTitle.addActionListener(this);
        menu4.add(this.viewTitle);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        menuBar.add(menu4);
        this.setMenuBar(menuBar);
        this.scroll = new ScrollPane(1);
        this.scroll.getHAdjustable().setUnitIncrement(10);
        this.scroll.getVAdjustable().setUnitIncrement(10);
        this.scoreBG = new Panel();
        this.layout = new GridBagLayout();
        this.scoreBG.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
        this.setupConstraints();
        this.scroll.add(this.scoreBG);
        this.add(this.scroll);
        this.setupArrays();
        this.makeAppropriateStaves();
        this.pack();
        this.setLocation(this.locationX, this.locationY);
        this.show();
    }

    private void setupArrays() {
        this.phraseArray = new Phrase[this.score.size()];
        this.staveArray = new Stave[this.score.size()];
        for (int i = 0; i < this.staveArray.length; ++i) {
            this.phraseArray[i] = this.score.getPart(i).getPhrase(0);
            this.staveArray[i] = new PianoStave();
            this.staveArray[i].setKeySignature(this.score.getKeySignature());
            this.staveArray[i].setMetre(this.score.getNumerator());
            this.staveArray[i].setBarNumbers(true);
        }
    }

    private void setupConstraints() {
        this.constraints.weightx = 100.0;
        this.constraints.weighty = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 1;
    }

    private void calcHeight() {
        this.height = 0;
        for (int i = 0; i < this.staveArray.length; ++i) {
            this.height += this.staveArray[i].getSize().height;
        }
    }

    private void makeAppropriateStaves() {
        Stave[] staveArray = new Stave[this.staveArray.length];
        for (int i = 0; i < this.score.size(); ++i) {
            Phrase phrase = this.score.getPart(i).getPhrase(0);
            staveArray[i] = new PianoStave();
            if (phrase.getHighestPitch() < 93 && phrase.getLowestPitch() > 54) {
                staveArray[i] = new TrebleStave();
                continue;
            }
            if (phrase.getHighestPitch() < 65 && phrase.getLowestPitch() > 35) {
                staveArray[i] = new BassStave();
                continue;
            }
            if (phrase.getHighestPitch() <= 93 && phrase.getLowestPitch() >= 35) continue;
            staveArray[i] = new GrandStave();
        }
        this.updateAllStaves(staveArray);
    }

    private void makeTrebleStave() {
        Stave[] staveArray = new Stave[this.score.size()];
        for (int i = 0; i < this.staveArray.length; ++i) {
            staveArray[i] = new TrebleStave();
        }
        this.updateAllStaves(staveArray);
    }

    private void updateAllStaves(Stave[] staveArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.scoreBG.removeAll();
        for (int i = 0; i < this.staveArray.length; ++i) {
            staveArray[i].setKeySignature(this.staveArray[i].getKeySignature());
            staveArray[i].setMetre(this.staveArray[i].getMetre());
            staveArray[i].setBarNumbers(this.staveArray[i].getBarNumbers());
            staveArray[i].setPhrase(this.phraseArray[i]);
            this.staveArray[i] = staveArray[i];
            staveArray[i] = null;
            this.constraints.gridy = n;
            n2 = this.staveArray[i].getClass().isInstance(new TrebleStave()) || this.staveArray[i].getClass().isInstance(new BassStave()) ? 1 : (this.staveArray[i].getClass().isInstance(new PianoStave()) ? 2 : 3);
            this.constraints.gridheight = n2;
            this.scoreBG.add((Component)this.staveArray[i], this.constraints);
            n += n2;
            n3 += this.staveArray[i].getPanelHeight();
        }
        this.scroll.setSize(new Dimension(this.width, n3));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setSize(new Dimension(this.width, Math.min(dimension.height - 40, n3 + 40)));
        this.pack();
    }

    private void makeBassStave() {
        Stave[] staveArray = new Stave[this.score.size()];
        for (int i = 0; i < this.staveArray.length; ++i) {
            staveArray[i] = new BassStave();
        }
        this.updateAllStaves(staveArray);
    }

    private void makePianoStave() {
        Stave[] staveArray = new Stave[this.score.size()];
        for (int i = 0; i < staveArray.length; ++i) {
            staveArray[i] = new PianoStave();
        }
        this.updateAllStaves(staveArray);
    }

    private void makeGrandStave() {
        Stave[] staveArray = new Stave[this.score.size()];
        for (int i = 0; i < staveArray.length; ++i) {
            staveArray[i] = new GrandStave();
        }
        this.updateAllStaves(staveArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.newStave) {
            new Notate();
        } else if (actionEvent.getSource() == this.open) {
            this.openMidi();
        } else if (actionEvent.getSource() == this.openjm) {
            this.openJM();
        } else if (actionEvent.getSource() == this.openJmXml) {
            this.openJMXML();
        } else if (actionEvent.getSource() == this.keySig) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                if (this.staveArray[i].getKeySignature() == 0) {
                    this.staveArray[i].setKeySignature(2);
                    this.staveArray[i].repaint();
                    continue;
                }
                this.staveArray[i].setKeySignature(0);
                this.staveArray[i].repaint();
            }
        } else if (actionEvent.getSource() == this.timeSig) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                if (this.staveArray[i].getMetre() == 0.0) {
                    this.staveArray[i].setMetre(4.0);
                    this.staveArray[i].repaint();
                    continue;
                }
                this.staveArray[i].setMetre(0.0);
                this.staveArray[i].repaint();
            }
        } else if (actionEvent.getSource() == this.saveJM) {
            this.saveJM();
        } else if (actionEvent.getSource() == this.saveJmXml) {
            this.saveJMXML();
        } else if (actionEvent.getSource() == this.saveMidi) {
            this.saveMidi();
        } else if (actionEvent.getSource() == this.quit) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.delete) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].deleteLastNote();
            }
        } else if (actionEvent.getSource() == this.clear) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].getPhrase().empty();
                this.staveArray[i].repaint();
            }
        } else if (actionEvent.getSource() == this.trebleStave) {
            this.setCursor(new Cursor(3));
            this.makeTrebleStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (actionEvent.getSource() == this.bassStave) {
            this.setCursor(new Cursor(3));
            this.makeBassStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (actionEvent.getSource() == this.pianoStave) {
            this.setCursor(new Cursor(3));
            this.makePianoStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (actionEvent.getSource() == this.grandStave) {
            this.setCursor(new Cursor(3));
            this.makeGrandStave();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (actionEvent.getSource() == this.automaticStave) {
            this.setCursor(new Cursor(3));
            this.makeAppropriateStaves();
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].repaint();
            }
            this.setCursor(new Cursor(0));
        } else if (actionEvent.getSource() == this.setParameters) {
            ParmScreen parmScreen = new ParmScreen(this);
            double d = this.staveArray[0].getPhrase().getTempo();
            parmScreen.getParms(this.staveArray[0].getPhrase(), 15, 15);
            this.repaint();
        } else if (actionEvent.getSource() == this.playAll) {
            Play.midi(this.score, false);
        } else if (actionEvent.getSource() == this.repeatAll) {
            Play.midiCycle(this.score);
        } else if (actionEvent.getSource() == this.stopPlay) {
            Play.stopMidi();
            Play.stopMidiCycle();
        } else if (actionEvent.getSource() == this.repeatMeasure) {
            Play.midiCycle(this.getLastMeasure());
        } else if (actionEvent.getSource() == this.playMeasure) {
            Play.midi(this.getLastMeasure(), false);
        } else if (actionEvent.getSource() == this.addNotes) {
            LetterNotesEditor letterNotesEditor = new LetterNotesEditor(this);
            letterNotesEditor.getNotes(this.staveArray[0]);
            this.staveArray[0].repaint();
        } else if (actionEvent.getSource() == this.adjustTiming) {
            Notate.adjustTimeValues(this.staveArray[0].getPhrase());
            this.staveArray[0].repaint();
        } else if (actionEvent.getSource() == this.viewDetails) {
            PhraseViewer phraseViewer = new PhraseViewer(this);
            phraseViewer.showPhrase(this.staveArray[0], this.staveArray[0].getPhrase(), 15, 15);
        } else if (actionEvent.getSource() == this.viewZoom) {
            if (!this.zoomed) {
                CpnZoomScreen cpnZoomScreen = new CpnZoomScreen(this);
                this.beforeZoom = this.staveArray[0].getPhrase().copy();
                this.afterZoom = this.staveArray[0].getPhrase().copy();
                this.beforeZoom.empty();
                this.afterZoom.empty();
                cpnZoomScreen.zoomIn(this.beforeZoom, this.staveArray[0].getPhrase(), this.afterZoom);
                if (this.beforeZoom.size() + this.afterZoom.size() > 0) {
                    this.zoomed = true;
                    this.viewZoom.setLabel("View complete phrase");
                    this.repaint();
                }
            } else {
                CpnZoomScreen.zoomOut(this.beforeZoom, this.staveArray[0].getPhrase(), this.afterZoom);
                this.zoomed = false;
                this.viewZoom.setLabel("View phrase section");
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.barNumbers) {
            for (int i = 0; i < this.staveArray.length; ++i) {
                this.staveArray[i].setBarNumbers(!this.staveArray[i].getBarNumbers());
                this.staveArray[i].repaint();
            }
        } else if (actionEvent.getSource() == this.viewTitle) {
            this.toggleDisplayTitle();
        }
    }

    public void openMidi() {
        Score score = new Score();
        FileDialog fileDialog = new FileDialog((Frame)this, "Select a MIDI file.", 0);
        fileDialog.setDirectory(this.lastDirectory);
        fileDialog.setFile(this.lastFileName);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            this.lastFileName = string;
            this.lastDirectory = fileDialog.getDirectory();
            Read.midi(score, this.lastDirectory + string);
            this.setNewScore(score);
        }
    }

    private void setNewScore(Score score) {
        this.score = score;
        this.setupArrays();
        this.makeAppropriateStaves();
    }

    public void openJM() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select a jm score file.", 0);
        fileDialog.setDirectory(this.lastDirectory);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            this.lastDirectory = fileDialog.getDirectory();
            Read.jm(score, this.lastDirectory + string);
            this.setNewScore(score);
        }
    }

    public void openJMXML() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select a jMusic XML score file.", 0);
        fileDialog.setDirectory(this.lastDirectory);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            this.lastDirectory = fileDialog.getDirectory();
            Read.xml(score, this.lastDirectory + string);
            this.setNewScore(score);
        }
    }

    public void saveMidi() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as a MIDI file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.midi(this.score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void saveJM() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as a jm file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.jm(this.score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void saveJMXML() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as a jMusic XML file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.xml(this.score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public Phrase readMidiPhrase() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select a MIDI file.", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        Phrase phrase = new Phrase(0.0);
        Score score = new Score();
        if (string != null) {
            Read.midi(score, fileDialog.getDirectory() + string);
        }
        score.clean();
        if (score.size() > 0 && score.getPart(0).size() > 0) {
            phrase = score.getPart(0).getPhrase(0);
        }
        return phrase;
    }

    private Score getLastMeasure() {
        double d;
        int n;
        double d2 = this.phraseArray[0].getNumerator();
        double d3 = d2 * (double)(n = (int)((d = this.score.getEndTime()) / d2));
        if (d3 == d) {
            d3 -= d2;
        }
        Score score = this.score.copy(d3, d);
        for (int i = 0; i < score.size(); ++i) {
            score.getPart(i).getPhrase(0).setStartTime(0.0);
        }
        return score;
    }

    private static double getRhythmAdjustment(double d, double d2) {
        double d3 = d / d2;
        double d4 = 0.0;
        double d5 = Math.floor(d3);
        for (double d6 = 1.0E-5; Math.floor(d3 + d6) > d5 && d6 > 1.0E-14; d6 /= 2.0) {
            d4 = d6;
        }
        return d4 * d2;
    }

    private static void adjustTimeValues(Phrase phrase) {
        double d;
        double d2;
        int n;
        for (n = 0; n < phrase.size(); ++n) {
            d2 = phrase.getNote(n).getRhythmValue();
            d = Notate.getRhythmAdjustment(d2, 0.00390625);
            phrase.getNote(n).setRhythmValue(d2 + d);
        }
        double d3 = 0.0;
        for (n = 0; n < phrase.size(); ++n) {
            d2 = phrase.getNote(n).getRhythmValue();
            d = Notate.getRhythmAdjustment(d3 += d2, 1.0);
            phrase.getNote(n).setRhythmValue(d2 + d);
            d3 += d;
        }
    }

    public void toggleDisplayTitle() {
        for (int i = 0; i < this.staveArray.length; ++i) {
            this.staveArray[i].setDisplayTitle(!this.staveArray[i].getDisplayTitle());
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
        if (windowEvent.getSource() == this.keyDialog) {
            this.keyDialog.dispose();
        }
        if (windowEvent.getSource() == this.timeDialog) {
            this.timeDialog.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    class PlayRepeater
    extends Thread {
        JmMidiPlayer midiPlayer;
        Notate n;

        public PlayRepeater(String string, Notate notate2, JmMidiPlayer jmMidiPlayer) {
            super(string);
            this.n = notate2;
            this.midiPlayer = jmMidiPlayer;
        }

        @Override
        public void run() {
            do {
                this.midiPlayer.play();
            } while (!this.n.timeToStop);
        }
    }
}

