/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.Vector;
import jm.music.data.Phrase;

public class ParmScreen
extends Dialog
implements ActionListener,
WindowListener {
    private List instrumentList;
    private List volumeList;
    private List tempoList;
    private Button instrumentButton;
    private Button volumeButton;
    private Button tempoButton;
    private Button closeButton;
    private Label instrumentLabel;
    private Label volumeLabel;
    private Label tempoLabel;
    private Phrase phrase;

    public ParmScreen(Frame frame) {
        super(frame, "Set Music Parameters", true);
        this.initializeLists();
        this.initializeButtons();
        this.initializeLabels();
        this.setSize(500, 400);
        this.placeControls();
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void getParms(Phrase phrase, int n, int n2) {
        this.phrase = phrase;
        this.setLocation(n, n2);
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tempoButton) {
            System.out.print("Adjusting Tempo ");
            System.out.print(this.tempoList.getSelectedItem());
            double d = this.phrase.getTempo();
            if (d < 10.0) {
                d = 60.0;
            }
            double d2 = ParmScreen.getTempo(this.tempoList.getSelectedItem());
            this.phrase.setTempo(d2);
            this.multiplyTimesBy(d / d2);
        } else if (actionEvent.getSource() == this.volumeButton) {
            this.setVolume(ParmScreen.getVolume(this.volumeList.getSelectedItem()));
        } else if (actionEvent.getSource() == this.instrumentButton) {
            this.phrase.setInstrument(ParmScreen.getInstrument(this.instrumentList.getSelectedItem()));
        } else if (actionEvent.getSource() == this.closeButton) {
            this.dispose();
        }
    }

    private void initializeLists() {
        this.initializeInstrumentList();
        this.initializeVolumeList();
        this.initializeTempoList();
    }

    private void initializeInstrumentList() {
        this.instrumentList = new List();
        this.instrumentList.add("Accordion             21");
        this.instrumentList.add("Applausen            126");
        this.instrumentList.add("Bandneon              23");
        this.instrumentList.add("Banjo                105");
        this.instrumentList.add("Bagpipes             109");
        this.instrumentList.add("Bass   (Acoustic)     32");
        this.instrumentList.add("Bass   (Fingerd)      33");
        this.instrumentList.add("Bass   (Fretless)     35");
        this.instrumentList.add("Bass   (Picked)       34");
        this.instrumentList.add("Bass   (Slap)         36");
        this.instrumentList.add("Bass   (Synth)        38");
        this.instrumentList.add("Bass   (Synth)        38");
        this.instrumentList.add("Bassoon               70");
        this.instrumentList.add("Bottle                76");
        this.instrumentList.add("Brass  (Synthetic)    62");
        this.instrumentList.add("Calliope              82");
        this.instrumentList.add("Celeste                8");
        this.instrumentList.add("Cello                 42");
        this.instrumentList.add("Charang               84");
        this.instrumentList.add("Choir                 52");
        this.instrumentList.add("Clarinet              71");
        this.instrumentList.add("Clavinet               7");
        this.instrumentList.add("Contrabass            43");
        this.instrumentList.add("English Horn          69");
        this.instrumentList.add("Fiddle               110");
        this.instrumentList.add("French Horn           60");
        this.instrumentList.add("Flute                 73");
        this.instrumentList.add("Glockenspiel           9");
        this.instrumentList.add("Guitar (Clean)        27");
        this.instrumentList.add("Guitar (Distorted)    30");
        this.instrumentList.add("Guitar Harmonics      31");
        this.instrumentList.add("Guitar (Jazz)         26");
        this.instrumentList.add("Guitar (Muted)        28");
        this.instrumentList.add("Guitar (Nylon)        24");
        this.instrumentList.add("Guitar (Overdrive)    29");
        this.instrumentList.add("Guitar (Steel)        25");
        this.instrumentList.add("Harmonica             22");
        this.instrumentList.add("Harp                  46");
        this.instrumentList.add("Harpsichord           76");
        this.instrumentList.add("Marimba               12");
        this.instrumentList.add("Music Box             10");
        this.instrumentList.add("Oboe                  68");
        this.instrumentList.add("Ocarina               79");
        this.instrumentList.add("Orchestra Hit         55");
        this.instrumentList.add("Organ                 16");
        this.instrumentList.add("Organ (Church)        19");
        this.instrumentList.add("Organ (Reed)          20");
        this.instrumentList.add("Pan Flute             75");
        this.instrumentList.add("Piano                  0");
        this.instrumentList.add("Piano (Electric)       4");
        this.instrumentList.add("Piano (Honkeytonk)     3");
        this.instrumentList.add("Piccolo               72");
        this.instrumentList.add("Recorder              74");
        this.instrumentList.add("Saxophone (Alto)      65");
        this.instrumentList.add("Saxophone (Soprano)   64");
        this.instrumentList.add("Saxophone (Tenor)     66");
        this.instrumentList.add("Saxophone (Baritone)  67");
        this.instrumentList.add("Shakuhachi            77");
        this.instrumentList.add("Steel Drums          114");
        this.instrumentList.add("Strings               48");
        this.instrumentList.add("Strings (Pizzicato)   45");
        this.instrumentList.add("Strings (Slow)        51");
        this.instrumentList.add("Strings (Synth)       50");
        this.instrumentList.add("Strings (Tremolo)     44");
        this.instrumentList.add("Tom-Tom              119");
        this.instrumentList.add("Trombone              57");
        this.instrumentList.add("Trumpet               56");
        this.instrumentList.add("Trumpet (Muted)       59");
        this.instrumentList.add("Tuba                  58");
        this.instrumentList.add("Tubular Bell          14");
        this.instrumentList.add("Timpani               47");
        this.instrumentList.add("Vibraphone            11");
        this.instrumentList.add("Viola                 41");
        this.instrumentList.add("Violin                40");
        this.instrumentList.add("Voice                 53");
        this.instrumentList.add("Vox                   56");
        this.instrumentList.add("Whistle               78");
        this.instrumentList.add("Wood Block           115");
        this.instrumentList.add("Xylophone             13");
    }

    private void initializeVolumeList() {
        this.volumeList = new List();
        int n = 7;
        int n2 = 256;
        int n3 = 6;
        for (int i = n; i <= n2; i += n3) {
            this.volumeList.add(new Integer(i).toString());
        }
    }

    private void initializeTempoList() {
        double d;
        this.tempoList = new List();
        for (d = 36.0; d < 143.0; d += 2.0) {
            this.tempoList.add(new Double(d).toString());
        }
        for (d = 144.0; d < 250.0; d += 4.0) {
            this.tempoList.add(new Double(d).toString());
        }
        for (d = 256.0; d < 404.0; d += 8.0) {
            this.tempoList.add(new Double(d).toString());
        }
    }

    private void initializeButtons() {
        this.instrumentButton = new Button("Apply");
        this.volumeButton = new Button("Apply");
        this.tempoButton = new Button("Apply");
        this.closeButton = new Button("Close");
    }

    private void initializeLabels() {
        this.instrumentLabel = new Label("Instrument");
        this.volumeLabel = new Label("Volume");
        this.tempoLabel = new Label("Tempo");
    }

    private void placeControls() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagLayout.setConstraints(this.instrumentLabel, gridBagConstraints);
        this.add(this.instrumentLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.instrumentList, gridBagConstraints);
        this.add(this.instrumentList);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 2;
        Panel panel = new Panel();
        panel.add(this.instrumentButton);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.volumeLabel, gridBagConstraints);
        this.add(this.volumeLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.volumeList, gridBagConstraints);
        this.add(this.volumeList);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 2;
        Panel panel2 = new Panel();
        panel2.add(this.volumeButton);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.add(panel2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.tempoLabel, gridBagConstraints);
        this.add(this.tempoLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.tempoList, gridBagConstraints);
        this.add(this.tempoList);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 2;
        Panel panel3 = new Panel();
        panel3.add(this.tempoButton);
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        this.add(panel3);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        this.add(this.closeButton);
        this.instrumentButton.addActionListener(this);
        this.volumeButton.addActionListener(this);
        this.tempoButton.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    private static double getTempo(String string) {
        return new Double(ParmScreen.pullFirst(string));
    }

    private static int getVolume(String string) {
        return new Integer(ParmScreen.pullLast(string));
    }

    private static int getInstrument(String string) {
        return new Integer(ParmScreen.pullLast(string));
    }

    private void setVolume(int n) {
        Vector vector = this.phrase.getNoteList();
        for (int i = 0; i < vector.size(); ++i) {
            if (this.phrase.getNote(i).getDynamic() == 0) continue;
            this.phrase.getNote(i).setDynamic(n);
        }
    }

    private void multiplyTimesBy(double d) {
        Vector vector = this.phrase.getNoteList();
        System.out.println(d);
        for (int i = 0; i < vector.size(); ++i) {
        }
    }

    private static String pullFirst(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        while (string2 == "" && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private static String pullLast(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3 == "") continue;
            string2 = string3;
        }
        return string2;
    }
}

