/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import jm.gui.graph.Statistics;

public class StatisticsList
implements Cloneable,
Serializable {
    private transient Statistics[] elementData;
    private int size;
    protected transient int modCount = 0;

    public StatisticsList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Statistics[n];
    }

    public StatisticsList() {
        this(10);
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.size < n) {
            Statistics[] statisticsArray = this.elementData;
            this.elementData = new Statistics[this.size];
            System.arraycopy(statisticsArray, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            Statistics[] statisticsArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Statistics[n3];
            System.arraycopy(statisticsArray, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Statistics statistics) {
        return this.indexOf(statistics) >= 0;
    }

    public int indexOf(Statistics statistics) {
        if (statistics == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!statistics.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Statistics statistics) {
        if (statistics == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!statistics.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            StatisticsList statisticsList = (StatisticsList)super.clone();
            statisticsList.elementData = new Statistics[this.size];
            System.arraycopy(this.elementData, 0, statisticsList.elementData, 0, this.size);
            statisticsList.modCount = 0;
            return statisticsList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Statistics[] toArray() {
        Statistics[] statisticsArray = new Statistics[this.size];
        System.arraycopy(this.elementData, 0, statisticsArray, 0, this.size);
        return statisticsArray;
    }

    public Statistics[] toArray(Statistics[] statisticsArray) {
        if (statisticsArray.length < this.size) {
            statisticsArray = (Statistics[])Array.newInstance(statisticsArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, statisticsArray, 0, this.size);
        if (statisticsArray.length > this.size) {
            statisticsArray[this.size] = null;
        }
        return statisticsArray;
    }

    public Statistics get(int n) {
        this.rangeCheck(n);
        return this.elementData[n];
    }

    public Statistics set(int n, Statistics statistics) {
        this.rangeCheck(n);
        Statistics statistics2 = this.elementData[n];
        this.elementData[n] = statistics;
        return statistics2;
    }

    public boolean add(Statistics statistics) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = statistics;
        return true;
    }

    public void add(int n, Statistics statistics) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = statistics;
        ++this.size;
    }

    public Statistics remove(int n) {
        this.rangeCheck(n);
        ++this.modCount;
        Statistics statistics = this.elementData[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return statistics;
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = null;
        }
    }

    private void rangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = new Statistics[n];
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = (Statistics)objectInputStream.readObject();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticsList)) {
            return false;
        }
        StatisticsList statisticsList = (StatisticsList)object;
        if (this.size == statisticsList.size()) {
            for (int i = 0; i < this.size; ++i) {
                Statistics statistics = this.get(i);
                Statistics statistics2 = statisticsList.get(i);
                if (statistics != null ? statistics.equals(statistics2) : statistics2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            Statistics statistics = this.get(i);
            n = 31 * n + (statistics == null ? 0 : statistics.hashCode());
        }
        return n;
    }

    public boolean remove(Statistics statistics) {
        if (statistics == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.get(i) != null) continue;
                this.remove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!statistics.equals(this.get(i))) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = this.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(this.get(i)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

