/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.sketch;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.gui.sketch.SketchScore;

public class SketchRuler
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener {
    private int startX;
    private int height = 15;
    private int barNumbCount = 2;
    private SketchScore sketchScore;
    private Font font = new Font("Helvetica", 0, 10);

    public SketchRuler(SketchScore sketchScore) {
        this.sketchScore = sketchScore;
        this.setSize((int)(SketchScore.score.getEndTime() * sketchScore.beatWidth), this.height);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setCursor(new Cursor(13));
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void paint(Graphics graphics) {
        double d = this.sketchScore.beatWidth;
        graphics.setFont(this.font);
        for (int i = 0; i < this.sketchScore.getSketchScoreArea().getNewWidth(); ++i) {
            int n = (int)Math.round((double)i * d);
            if (i % this.barNumbCount == 0) {
                graphics.drawLine(n, 0, n, this.height);
                if (!(d > 15.0)) continue;
                graphics.drawString("" + i, n + 2, this.height - 2);
                continue;
            }
            graphics.drawLine(n, this.height / 2, n, this.height);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(10));
        this.startX = mouseEvent.getX();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(13));
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        double d = this.sketchScore.beatWidth;
        if ((d += ((double)mouseEvent.getX() - (double)this.startX) / 5.0) < 1.0) {
            d = 1.0;
        }
        if (d > 256.0) {
            d = 256.0;
        }
        this.sketchScore.beatWidth = d;
        this.startX = mouseEvent.getX();
        this.sketchScore.update();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\b') {
            this.repaint();
        }
    }
}

