/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.gui.wave.WaveRuler;
import jm.gui.wave.WaveView;

public class WaveScrollPanel
extends Panel
implements ActionListener,
AdjustmentListener {
    private Label name;
    private Label bitSize;
    private Label sampleRate;
    private Label channels;
    private Label resLable;
    private Button minus;
    private Button plus;
    private Button play;
    private Button stop;
    private WaveView viewer;
    private WaveRuler ruler = new WaveRuler();
    private Panel resizePanel;
    private Scrollbar scroll = new Scrollbar(0);
    private Font font = new Font("Helvetica", 0, 10);

    public WaveScrollPanel() {
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.resizePanel = new Panel();
        this.resLable = new Label("Display Resolution: 1:0");
        this.resLable.setFont(this.font);
        this.resizePanel.add(this.resLable);
        this.minus = new Button("-");
        this.minus.addActionListener(this);
        this.resizePanel.add(this.minus);
        this.plus = new Button("+");
        this.plus.addActionListener(this);
        this.resizePanel.add(this.plus);
        this.add((Component)this.resizePanel, "East");
        Panel panel = new Panel();
        this.play = new Button("Play");
        this.play.addActionListener(this);
        panel.add(this.play);
        this.stop = new Button("Stop");
        this.stop.setEnabled(false);
        this.stop.addActionListener(this);
        panel.add(this.stop);
        this.name = new Label();
        this.name.setFont(this.font);
        panel.add(this.name);
        this.bitSize = new Label();
        this.bitSize.setFont(this.font);
        panel.add(this.bitSize);
        this.sampleRate = new Label();
        this.sampleRate.setFont(this.font);
        panel.add(this.sampleRate);
        this.channels = new Label();
        this.channels.setFont(this.font);
        panel.add(this.channels);
        this.add((Component)panel, "West");
        this.scroll.addAdjustmentListener(this);
        this.add((Component)this.scroll, "South");
        this.ruler.setWaveScrollPanel(this);
        this.add((Component)this.ruler, "North");
    }

    public void setViewer(WaveView waveView) {
        this.viewer = waveView;
        this.setResolution(waveView.getResolution());
    }

    public void setScrollbarAttributes(int n, int n2, int n3) {
        this.scroll.setUnitIncrement(1000);
        this.scroll.setBlockIncrement(n2 * n3 / 2);
        this.scroll.setMinimum(0);
        this.scroll.setMaximum(n * 2);
        this.scroll.setVisibleAmount(n2 * n3);
    }

    public void setScrollbarResolution(int n) {
        if (this.viewer != null) {
            this.scroll.setVisibleAmount(this.viewer.getWidth() * n);
            this.scroll.setBlockIncrement(this.viewer.getWidth() * n / 2);
        } else {
            this.scroll.setVisibleAmount(204800);
            this.scroll.setBlockIncrement(102400);
        }
    }

    public void setScrollbarValue(int n) {
        this.scroll.setValue(n);
    }

    public void setResolution(int n) {
        String string = new String("Display Resolution = 1:" + n);
        if (n < 1000) {
            string = string + "  ";
        }
        this.resLable.setText(string);
        this.ruler.setMarkerWidth(this.viewer.getSampleRate() / n);
        this.repaint();
    }

    public void setFileName(String string) {
        this.name.setText("File = " + string + ". ");
        this.repaint();
    }

    public void setBitSize(int n) {
        this.bitSize.setText("Bit Depth = " + n + ". ");
        this.repaint();
    }

    public void setSampleRate(int n) {
        this.sampleRate.setText("Sample Rate = " + n + ". ");
        this.repaint();
    }

    public void setChannels(int n) {
        this.channels.setText("Channels = " + n + ". ");
        this.repaint();
    }

    public WaveRuler getWaveRuler() {
        return this.ruler;
    }

    public WaveView getWaveView() {
        return this.viewer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.minus && (n = this.viewer.getResolution()) > 0 && n <= 1024) {
            this.setResolution(n *= 2);
            this.plus.setEnabled(true);
            if (n > 1024) {
                this.minus.setEnabled(false);
            }
            this.viewer.setResolution(n);
        }
        if (actionEvent.getSource() == this.plus && (n = this.viewer.getResolution()) > 1) {
            this.setResolution(n /= 2);
            this.minus.setEnabled(true);
            if (n < 2) {
                this.plus.setEnabled(false);
            }
            this.viewer.setResolution(n);
        }
        if (actionEvent.getSource() == this.play) {
            this.stop.setEnabled(true);
            this.viewer.playFile();
        }
        if (actionEvent.getSource() == this.stop) {
            this.viewer.pauseFile();
            this.stop.setEnabled(false);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.viewer.setStartPos(this.scroll.getValue());
        this.ruler.repaint();
    }
}

