/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import jm.audio.RTMixer;
import jm.gui.wave.WaveCanvas;
import jm.gui.wave.WaveFileReader;
import jm.gui.wave.WaveScrollPanel;
import jm.music.rt.RTLine;
import jm.util.AudioRTLine;

public class WaveView
implements ActionListener,
ComponentListener {
    private String lastFileName = "Drunk.au";
    private String lastDirectory = "";
    private WaveFileReader afr;
    private int width = 600;
    private int channelHeight = 200;
    private int amplitude = 1;
    private int channels;
    private float[] data;
    private int resolution = 256;
    private int segmentSize;
    private int startPos = 0;
    private MenuItem size1;
    private MenuItem size2;
    private MenuItem size4;
    private MenuItem size8;
    private MenuItem size16;
    private MenuItem size32;
    private MenuItem size64;
    private MenuItem size128;
    private MenuItem size256;
    private MenuItem size512;
    private MenuItem size1024;
    private MenuItem size2048;
    private MenuItem size4096;
    private MenuItem openFile;
    private MenuItem quit;
    private MenuItem changeColor;
    private MenuItem vSmall;
    private MenuItem small;
    private MenuItem medium;
    private MenuItem large;
    private MenuItem huge;
    private MenuItem times1;
    private MenuItem times2;
    private MenuItem times3;
    private MenuItem times4;
    private Frame f = new Frame();
    private WaveCanvas[] canvases = new WaveCanvas[8];
    private ScrollPane sp = new ScrollPane(2);
    private WaveScrollPanel scrollPanel = new WaveScrollPanel();
    private boolean whiteColor = true;
    private RTMixer mixer;
    private int lastStartPos = -1;

    public WaveView() {
        this.openFile();
        this.drawWave(0, 0);
    }

    public WaveView(String string) {
        this(string, 0, 0);
    }

    public WaveView(String string, int n, int n2) {
        this.lastFileName = string;
        this.afr = new WaveFileReader(string);
        this.init();
        this.drawWave(n, n2);
        this.f.setTitle("jMusic Wave Viewer: " + this.lastFileName);
    }

    public void openFile() {
        FileDialog fileDialog = new FileDialog(this.f, "Select a 16 bit audio file in .au format (no compression).", 0);
        fileDialog.setDirectory(this.lastDirectory);
        fileDialog.setFile(this.lastFileName);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            this.lastFileName = string;
            this.lastDirectory = fileDialog.getDirectory();
            this.afr = new WaveFileReader(this.lastDirectory + string);
            this.updateScrollInfo();
            this.init();
            this.setupPanel();
            this.lastFileName = string;
            this.f.setTitle("jMusic Wave Viewer: " + this.lastFileName);
            if (!this.whiteColor) {
                this.changeColor();
                boolean bl = this.whiteColor = !this.whiteColor;
            }
            if (this.channels <= 2) {
                this.setHeight(200);
            }
            if (this.channels > 2) {
                this.setHeight(100);
            }
            if (this.channels > 4) {
                this.setHeight(50);
            }
            this.f.repaint();
        }
    }

    private void init() {
        this.channels = this.afr.getChannels();
        if (this.channels > 8) {
            System.out.println("jMusic wave viewer error: Files with more than 8 channels are not supported :(");
            System.exit(1);
        }
        this.segmentSize = this.width * this.resolution * this.channels;
        this.data = this.afr.getSamples(this.segmentSize, this.startPos);
        this.setupChannels();
        if (this.channels <= 2) {
            this.setHeight(200);
        }
        if (this.channels > 2) {
            this.setHeight(100);
        }
        if (this.channels > 4) {
            this.setHeight(50);
        }
        this.scrollPanel.setScrollbarAttributes(this.afr.getWaveSize(), this.width, this.resolution);
    }

    private void drawWave(int n, int n2) {
        this.f.setName("jMusic Wave Viewer: " + this.lastFileName);
        this.f.setLocation(n, n2);
        this.f.setLayout(new BorderLayout());
        this.sp.setSize(new Dimension(this.width, (this.channelHeight + 1) * this.channels));
        this.setupPanel();
        this.f.add((Component)this.sp, "Center");
        this.scrollPanel.setViewer(this);
        this.updateScrollInfo();
        this.scrollPanel.setScrollbarAttributes(this.afr.getWaveSize(), this.width, this.resolution);
        this.f.add((Component)this.scrollPanel, "South");
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Wave", true);
        Menu menu2 = new Menu("Height", true);
        Menu menu3 = new Menu("Resolution", true);
        Menu menu4 = new Menu("Amplitude", true);
        this.size1 = new MenuItem("1:1");
        this.size1.addActionListener(this);
        menu3.add(this.size1);
        this.size2 = new MenuItem("1:2");
        this.size2.addActionListener(this);
        menu3.add(this.size2);
        this.size4 = new MenuItem("1:4");
        this.size4.addActionListener(this);
        menu3.add(this.size4);
        this.size8 = new MenuItem("1:8");
        this.size8.addActionListener(this);
        menu3.add(this.size8);
        this.size16 = new MenuItem("1:16");
        this.size16.addActionListener(this);
        menu3.add(this.size16);
        this.size32 = new MenuItem("1:32");
        this.size32.addActionListener(this);
        menu3.add(this.size32);
        this.size64 = new MenuItem("1:64");
        this.size64.addActionListener(this);
        menu3.add(this.size64);
        this.size128 = new MenuItem("1:128");
        this.size128.addActionListener(this);
        menu3.add(this.size128);
        this.size256 = new MenuItem("1:256");
        this.size256.addActionListener(this);
        menu3.add(this.size256);
        this.size512 = new MenuItem("1:512");
        this.size512.addActionListener(this);
        menu3.add(this.size512);
        this.size1024 = new MenuItem("1:1024");
        this.size1024.addActionListener(this);
        menu3.add(this.size1024);
        this.size2048 = new MenuItem("1:2048");
        this.size2048.addActionListener(this);
        menu3.add(this.size2048);
        this.openFile = new MenuItem("Open...", new MenuShortcut(79));
        this.openFile.addActionListener(this);
        menu.add(this.openFile);
        this.changeColor = new MenuItem("Change Color", new MenuShortcut(67));
        this.changeColor.addActionListener(this);
        menu.add(this.changeColor);
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        menu.add(this.quit);
        this.vSmall = new MenuItem("X Small");
        this.vSmall.addActionListener(this);
        menu2.add(this.vSmall);
        this.small = new MenuItem("Small");
        this.small.addActionListener(this);
        menu2.add(this.small);
        this.medium = new MenuItem("Medium");
        this.medium.addActionListener(this);
        menu2.add(this.medium);
        this.large = new MenuItem("Large");
        this.large.addActionListener(this);
        menu2.add(this.large);
        this.huge = new MenuItem("X Large");
        this.huge.addActionListener(this);
        menu2.add(this.huge);
        this.times1 = new MenuItem("x1");
        this.times1.addActionListener(this);
        menu4.add(this.times1);
        this.times2 = new MenuItem("x2");
        this.times2.addActionListener(this);
        menu4.add(this.times2);
        this.times3 = new MenuItem("x3");
        this.times3.addActionListener(this);
        menu4.add(this.times3);
        this.times4 = new MenuItem("x4");
        this.times4.addActionListener(this);
        menu4.add(this.times4);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        menuBar.add(menu4);
        this.f.setMenuBar(menuBar);
        this.sp.setSize(new Dimension(this.width, (this.channelHeight + 1) * this.channels));
        this.f.pack();
        this.width = this.f.getSize().width;
        this.f.setVisible(true);
        this.f.addComponentListener(this);
    }

    private void updateScrollInfo() {
        this.scrollPanel.setFileName(this.lastFileName);
        this.scrollPanel.setBitSize(this.afr.getBitResolution());
        this.scrollPanel.setSampleRate(this.afr.getSampleRate());
        this.scrollPanel.setChannels(this.afr.getChannels());
        this.scrollPanel.getWaveRuler().setMarkerWidth(this.afr.getSampleRate() / this.resolution);
        this.scrollPanel.setScrollbarValue(this.startPos);
        this.scrollPanel.setScrollbarResolution(this.resolution);
    }

    private void setupChannels() {
        int n;
        this.channels = this.afr.getChannels();
        float[][] fArray = new float[this.channels][this.segmentSize / this.channels];
        int n2 = 0;
        for (n = 0; n < this.segmentSize; n += this.channels) {
            for (int i = 0; i < this.channels; ++i) {
                fArray[i][n2] = this.data[n + i];
            }
            ++n2;
        }
        for (n = 0; n < this.channels; ++n) {
            this.canvases[n] = new WaveCanvas();
            this.canvases[n].setSize(new Dimension(this.width, this.channelHeight + 1));
            this.canvases[n].setData(fArray[n]);
            this.canvases[n].setResolution(this.resolution);
            this.canvases[n].setHeight(this.channelHeight);
            this.canvases[n].setAmplitude(this.amplitude);
            this.canvases[n].setWaveSize(this.afr.getWaveSize());
        }
    }

    public void setStartPos(int n) {
        this.startPos = n;
        this.reRead();
        for (int i = 0; i < this.channels; ++i) {
            this.canvases[i].setFastDraw(false);
            this.canvases[i].repaint();
        }
    }

    public int getStartPos() {
        return this.startPos;
    }

    private void reRead() {
        this.segmentSize = this.width * this.resolution * this.channels;
        if (this.segmentSize < 0) {
            return;
        }
        if (this.segmentSize > this.afr.getWaveSize() * this.channels * this.resolution) {
            this.segmentSize = this.afr.getWaveSize() * this.channels * this.resolution;
        }
        if (this.startPos != this.lastStartPos) {
            this.data = this.afr.getSamples(this.segmentSize, this.startPos);
            this.updateChannelData();
            this.lastStartPos = this.startPos;
        }
    }

    private void updateChannelData() {
        int n;
        float[][] fArray = new float[this.channels][this.segmentSize / this.channels];
        int n2 = 0;
        for (n = 0; n < this.segmentSize; n += this.channels) {
            for (int i = 0; i < this.channels; ++i) {
                fArray[i][n2] = this.data[n + i];
            }
            ++n2;
        }
        for (n = 0; n < this.channels; ++n) {
            this.canvases[n].setData(fArray[n]);
            this.canvases[n].setResolution(this.resolution);
        }
    }

    private void setupPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(this.channels, 1));
        panel.setSize(new Dimension(this.width, this.channelHeight * this.channels));
        for (int i = 0; i < this.channels; ++i) {
            panel.add(this.canvases[i]);
        }
        this.sp.add(panel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.size1) {
            this.setResolution(1);
        }
        if (actionEvent.getSource() == this.size2) {
            this.setResolution(2);
        }
        if (actionEvent.getSource() == this.size4) {
            this.setResolution(4);
        }
        if (actionEvent.getSource() == this.size8) {
            this.setResolution(8);
        }
        if (actionEvent.getSource() == this.size16) {
            this.setResolution(16);
        }
        if (actionEvent.getSource() == this.size32) {
            this.setResolution(32);
        }
        if (actionEvent.getSource() == this.size64) {
            this.setResolution(64);
        }
        if (actionEvent.getSource() == this.size128) {
            this.setResolution(128);
        }
        if (actionEvent.getSource() == this.size256) {
            this.setResolution(256);
        }
        if (actionEvent.getSource() == this.size512) {
            this.setResolution(512);
        }
        if (actionEvent.getSource() == this.size1024) {
            this.setResolution(1024);
        }
        if (actionEvent.getSource() == this.size2048) {
            this.setResolution(2048);
        }
        if (actionEvent.getSource() == this.openFile) {
            this.openFile();
        }
        if (actionEvent.getSource() == this.quit) {
            System.exit(0);
        }
        if (actionEvent.getSource() == this.vSmall) {
            this.setHeight(25);
        }
        if (actionEvent.getSource() == this.small) {
            this.setHeight(50);
        }
        if (actionEvent.getSource() == this.medium) {
            this.setHeight(100);
        }
        if (actionEvent.getSource() == this.large) {
            this.setHeight(200);
        }
        if (actionEvent.getSource() == this.huge) {
            this.setHeight(300);
        }
        if (actionEvent.getSource() == this.times1) {
            this.setAmplitude(1);
        }
        if (actionEvent.getSource() == this.times2) {
            this.setAmplitude(2);
        }
        if (actionEvent.getSource() == this.times3) {
            this.setAmplitude(3);
        }
        if (actionEvent.getSource() == this.times4) {
            this.setAmplitude(4);
        }
        if (actionEvent.getSource() == this.changeColor) {
            this.changeColor();
        }
    }

    private void changeColor() {
        for (int i = 0; i < this.channels; ++i) {
            this.canvases[i].toggleColor();
        }
        this.whiteColor = !this.whiteColor;
    }

    public void setResolution(int n) {
        if (n > 0 && n <= 2048) {
            this.resolution = n;
            if (this.afr.getWaveSize() / this.resolution < this.width) {
                this.startPos = 0;
            }
            this.reRead();
            this.scrollPanel.setResolution(n);
            this.scrollPanel.setScrollbarResolution(n);
            for (int i = 0; i < this.channels; ++i) {
                this.canvases[i].setResolution(n);
            }
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getSampleRate() {
        return this.afr.getSampleRate();
    }

    public int getChannels() {
        return this.afr.getChannels();
    }

    public String getFileName() {
        return this.lastDirectory + this.lastFileName;
    }

    public int getWidth() {
        return this.width;
    }

    public void repaint() {
        this.sp.setSize(this.f.getSize().width, this.f.getSize().height);
        for (int i = 0; i < this.channels; ++i) {
            this.canvases[i].setSize(this.f.getSize().width, this.canvases[i].getSize().height);
            this.canvases[i].repaint();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.f.getSize().width > this.width) {
            this.width = this.f.getSize().width;
            this.reRead();
        } else {
            this.width = this.f.getSize().width;
        }
        for (int i = 0; i < this.channels; ++i) {
            this.canvases[i].setSize(this.width, this.canvases[i].getSize().height);
            this.canvases[i].setResized(true);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setHeight(int n) {
        this.channelHeight = n;
        this.setupChannels();
        this.setupPanel();
        this.sp.setSize(new Dimension(this.width, (this.channelHeight + 1) * this.channels));
        if (!this.whiteColor) {
            this.changeColor();
            this.whiteColor = !this.whiteColor;
        }
        this.f.pack();
        this.repaint();
        this.sp.repaint();
    }

    public void setAmplitude(int n) {
        this.amplitude = n;
        for (int i = 0; i < this.channels; ++i) {
            this.canvases[i].setAmplitude(n);
        }
    }

    public void playFile() {
        if (this.channels > 2) {
            System.out.println("jMusic Wave View notification: Sorry, only mono and stereo files can be played at present.");
        } else {
            System.out.println("---- Playing audio file '" + this.getFileName() + "'... Sample rate = " + this.afr.getSampleRate() + " Channels = " + this.afr.getChannels() + " ----");
            RTLine[] rTLineArray = new RTLine[]{new AudioRTLine(this.getFileName())};
            this.mixer = new RTMixer(rTLineArray);
            this.mixer.begin();
        }
    }

    public void pauseFile() {
        if (this.mixer != null) {
            // empty if block
        }
        this.mixer.pause();
    }

    public void unPauseFile() {
        if (this.mixer != null) {
            this.mixer.unPause();
        }
    }
}

