/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import jm.JMC;
import jm.midi.MidiUtil;
import jm.midi.SMF;
import jm.midi.Track;
import jm.midi.event.CChange;
import jm.midi.event.EndTrack;
import jm.midi.event.Event;
import jm.midi.event.KeySig;
import jm.midi.event.NoteOn;
import jm.midi.event.PChange;
import jm.midi.event.TempoEvent;
import jm.midi.event.TimeSig;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public final class MidiParser
implements JMC {
    private static double tickRemainder = 0.0;

    public static void SMFToScore(Score score, SMF sMF) {
        System.out.println("Convert SMF to JM");
        Enumeration enumeration = sMF.getTrackList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = new Part();
            Track track = (Track)enumeration.nextElement();
            Vector vector = track.getEvtList();
            Vector vector2 = new Vector();
            MidiParser.sortEvents(score, vector, vector2, sMF, part);
            for (int i = 0; i < vector2.size(); ++i) {
                part.addPhrase((Phrase)vector2.elementAt(i));
            }
            score.addPart(part);
            score.clean();
        }
    }

    private static void sortEvents(Score score, Vector vector, Vector vector2, SMF sMF, Part part) {
        double d = 0.0;
        double[] dArray = new double[100];
        Note[] noteArray = new Note[100];
        boolean bl = false;
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Event event;
            Event event2 = (Event)vector.elementAt(i);
            d += (double)event2.getTime() / (double)sMF.getPPQN();
            if (event2.getID() == 7) {
                event = (PChange)event2;
                part.setInstrument(((PChange)event).getValue());
                continue;
            }
            if (event2.getID() == 16) {
                event = (TempoEvent)event2;
                score.setTempo(((TempoEvent)event).getTempo());
                continue;
            }
            if (event2.getID() == 5) {
                event = (NoteOn)event2;
                part.setChannel(((NoteOn)event).getMidiChannel());
                short s = ((NoteOn)event).getPitch();
                short s2 = ((NoteOn)event).getVelocity();
                short s3 = ((NoteOn)event).getMidiChannel();
                if (s2 <= 0) continue;
                MidiParser.noteOn(n, noteArray, sMF, i, dArray, d, vector2, s3, s, s2, vector);
                continue;
            }
            if (event2 instanceof TimeSig) {
                event = (TimeSig)event2;
                score.setNumerator(((TimeSig)event).getNumerator());
                score.setDenominator(((TimeSig)event).getDenominator());
                continue;
            }
            if (!(event2 instanceof KeySig)) continue;
            event = (KeySig)event2;
            score.setKeySignature(((KeySig)event).getKeySig());
            score.setKeyQuality(((KeySig)event).getKeyQuality());
        }
    }

    private static void noteOn(int n, Note[] noteArray, SMF sMF, int n2, double[] dArray, double d, Vector vector, short s, short s2, int n3, Vector vector2) {
        n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(dArray[i] <= d + 0.08)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            n = vector.size();
            vector.addElement(new Phrase(d));
            dArray[n] = d;
        }
        if (d > dArray[n] && noteArray[n] != null) {
            double d2 = d - dArray[n];
            if (d2 < 0.25) {
                double d3 = noteArray[n].getRhythmValue();
                noteArray[n].setRhythmValue(d3 + d2);
            } else {
                Note note = new Note(Integer.MIN_VALUE, d2, 0);
                note.setPan(s);
                note.setDuration(d2);
                note.setOffset(0.0);
                ((Phrase)vector.elementAt(n)).addNote(note);
            }
            int n4 = n;
            dArray[n4] = dArray[n4] + d2;
        }
        double d4 = MidiUtil.getEndEvt(s2, vector2, n2) / (double)sMF.getPPQN();
        Note note = new Note(s2, d4, n3);
        note.setDuration(d4);
        noteArray[n] = note;
        ((Phrase)vector.elementAt(n)).addNote(noteArray[n]);
        int n5 = n;
        dArray[n5] = dArray[n5] + noteArray[n].getRhythmValue();
    }

    public static void scoreToSMF(Score score, SMF sMF) {
        System.out.println("Converting to SMF data structure...");
        double d = score.getTempo();
        double d2 = 1.0;
        double d3 = 1.0;
        Track track = new Track();
        track.addEvent(new TempoEvent(0, score.getTempo()));
        track.addEvent(new TimeSig(0, score.getNumerator(), score.getDenominator()));
        track.addEvent(new KeySig(0, score.getKeySignature()));
        track.addEvent(new EndTrack());
        sMF.getTrackList().addElement(track);
        int n = 0;
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Track track2 = new Track();
            Part part = (Part)enumeration.nextElement();
            System.out.print("    Part " + n + " '" + part.getTitle() + "' to SMF Track on Ch. " + part.getChannel() + ": ");
            ++n;
            d2 = part.getTempo() != -1.0 ? d / part.getTempo() : 1.0;
            int n2 = part.getPhraseList().size();
            block1: for (int i = 0; i < n2; ++i) {
                Phrase phrase = (Phrase)part.getPhraseList().elementAt(i);
                for (int j = 0; j < n2; ++j) {
                    Phrase phrase2 = (Phrase)part.getPhraseList().elementAt(j);
                    if (!(phrase2.getStartTime() > phrase.getStartTime())) continue;
                    part.getPhraseList().setElementAt(phrase2, i);
                    part.getPhraseList().setElementAt(phrase, j);
                    continue block1;
                }
            }
            class EventPair {
                public double time;
                public Event ev;

                public EventPair(double d, Event event) {
                    this.time = d;
                    this.ev = event;
                }
            }
            LinkedList<EventPair> linkedList = new LinkedList<EventPair>();
            if (part.getInstrument() != -1) {
                linkedList.add(new EventPair(0.0, new PChange((short)part.getInstrument(), (short)part.getChannel(), 0)));
            }
            if (part.getNumerator() != Integer.MIN_VALUE) {
                linkedList.add(new EventPair(0.0, new TimeSig(part.getNumerator(), part.getDenominator())));
            }
            if (part.getKeySignature() != Integer.MIN_VALUE) {
                linkedList.add(new EventPair(0.0, new KeySig(part.getKeySignature(), part.getKeyQuality())));
            }
            Enumeration enumeration2 = part.getPhraseList().elements();
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n3 = 0;
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                Enumeration enumeration3 = phrase.getNoteList().elements();
                d5 = phrase.getStartTime() * d2;
                if (phrase.getInstrument() != -1) {
                    linkedList.add(new EventPair(0.0, new PChange((short)phrase.getInstrument(), (short)part.getChannel(), 0)));
                }
                d3 = phrase.getTempo() != -1.0 ? d / phrase.getTempo() : d2;
                boolean bl = false;
                System.out.print(" Phrase " + n3++ + ":");
                double d7 = -1.0;
                MidiParser.resetTicker();
                while (enumeration3.hasMoreElements()) {
                    Note note = (Note)enumeration3.nextElement();
                    d6 = note.getOffset();
                    if (note.getPan() != d7) {
                        d7 = note.getPan();
                        linkedList.add(new EventPair(d5 + d6, new CChange(10, (short)(d7 * 127.0), (short)part.getChannel(), 0)));
                    }
                    int n4 = 0;
                    if (note.getPitchType()) {
                        System.err.println("jMusic warning: converting note frequency to the closest MIDI pitch for SMF.");
                        n4 = Note.freqToMidiPitch(note.getFrequency());
                    } else {
                        n4 = note.getPitch();
                    }
                    if (n4 != Integer.MIN_VALUE) {
                        linkedList.add(new EventPair(new Double(d5 + d6), new NoteOn((short)n4, (short)note.getDynamic(), (short)part.getChannel(), 0)));
                        double d8 = d5 + note.getDuration() * d3;
                        linkedList.add(new EventPair(new Double(d8 + d6), new NoteOn((short)n4, 0, (short)part.getChannel(), 0)));
                    }
                    d5 += MidiParser.tickRounder(note.getRhythmValue() * d3);
                    System.out.print(".");
                }
            }
            class CompareKey
            implements Comparator {
                CompareKey() {
                }

                public int compare(Object object, Object object2) {
                    EventPair eventPair = (EventPair)object;
                    EventPair eventPair2 = (EventPair)object2;
                    if (eventPair.time - eventPair2.time < 0.0) {
                        return -1;
                    }
                    if (eventPair.time - eventPair2.time > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            }
            Collections.sort(linkedList, new CompareKey());
            double d9 = 0.0;
            MidiParser.resetTicker();
            for (int i = 0; i < linkedList.size(); ++i) {
                EventPair eventPair = (EventPair)linkedList.get(i);
                Event event = eventPair.ev;
                double d10 = eventPair.time;
                int n5 = (int)((d10 - d9) * (double)sMF.getPPQN() + 0.5);
                d9 = d10;
                event.setTime(n5);
                track2.addEvent(event);
            }
            track2.addEvent(new EndTrack());
            sMF.getTrackList().addElement(track2);
            System.out.println();
        }
    }

    private static boolean zeroVelEventQ(Event event) {
        return event.getID() == 5 && ((NoteOn)event).getVelocity() == 0;
    }

    private static void resetTicker() {
        tickRemainder = 0.0;
    }

    private static double tickRounder(double d) {
        int n = (int)(d * 480.0);
        double d2 = (double)n * 0.0020833333333333333;
        if ((tickRemainder += d - d2) > 0.0010416666666666667) {
            d2 += 0.0020833333333333333;
            tickRemainder -= 0.0020833333333333333;
        }
        return d2;
    }
}

